/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.BaseDetailsBean;
import org.alfresco.web.bean.dialog.NavigationSupport;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.ui.common.component.UIActionLink;

public class SpaceLinkDetailsDialog
extends BaseDetailsBean
implements NavigationSupport {
    private static final long serialVersionUID = 8372741472120796169L;
    private static final String MSG_DETAILS_OF = "details_of";
    private static final String MSG_LOCATION = "location";
    private static final String MSG_CLOSE = "close";
    private static final String MSG_LEFT_QUOTE = "left_qoute";
    private static final String MSG_RIGHT_QUOTE = "right_quote";

    public Node getSpace() {
        return this.getNode();
    }

    @Override
    protected Node getLinkResolvedNode() {
        Node space = this.getSpace();
        if (ApplicationModel.TYPE_FOLDERLINK.equals((Object)space.getType())) {
            NodeRef destRef = (NodeRef)space.getProperties().get(ContentModel.PROP_LINK_DESTINATION);
            if (this.getNodeService().exists(destRef)) {
                space = new Node(destRef);
            }
        }
        return space;
    }

    @Override
    public Node getNode() {
        return this.browseBean.getActionSpace();
    }

    @Override
    protected String getPropertiesPanelId() {
        return "space-props";
    }

    @Override
    public Map getTemplateModel() {
        HashMap<String, Object> model = new HashMap<String, Object>(1, 1.0f);
        model.put("space", this.getSpace().getNodeRef());
        model.put("imageresolver", this.imageResolver);
        return model;
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        return null;
    }

    @Override
    public String getCurrentItemId() {
        return this.getId();
    }

    @Override
    public void nextItem(ActionEvent event) {
        boolean foundNextItem = false;
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String id = params.get("id");
        if (id != null && id.length() != 0) {
            NodeRef currNodeRef = new NodeRef(Repository.getStoreRef(), id);
            List<Node> nodes = this.browseBean.getParentNodes(currNodeRef);
            if (nodes.size() > 1) {
                for (int i = 0; i < nodes.size(); ++i) {
                    if (!id.equals(nodes.get(i).getId())) continue;
                    Node next = i != nodes.size() - 1 ? nodes.get(i + 1) : nodes.get(0);
                    this.browseBean.setupSpaceAction(next.getId(), false);
                    foundNextItem = true;
                }
            }
            if (!foundNextItem) {
                Node currNode = new Node(currNodeRef);
                this.navigator.setupDispatchContext(currNode);
            }
        }
    }

    @Override
    public void previousItem(ActionEvent event) {
        boolean foundPreviousItem = false;
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String id = params.get("id");
        if (id != null && id.length() != 0) {
            NodeRef currNodeRef = new NodeRef(Repository.getStoreRef(), id);
            List<Node> nodes = this.browseBean.getParentNodes(currNodeRef);
            if (nodes.size() > 1) {
                for (int i = 0; i < nodes.size(); ++i) {
                    if (!id.equals(nodes.get(i).getId())) continue;
                    Node previous = i != 0 ? nodes.get(i - 1) : nodes.get(nodes.size() - 1);
                    this.browseBean.setupSpaceAction(previous.getId(), false);
                    foundPreviousItem = true;
                }
            }
            if (!foundPreviousItem) {
                Node currNode = new Node(currNodeRef);
                this.navigator.setupDispatchContext(currNode);
            }
        }
    }

    @Override
    public String getCancelButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), MSG_CLOSE);
    }

    @Override
    public String getContainerSubTitle() {
        return Application.getMessage(FacesContext.getCurrentInstance(), MSG_LOCATION) + ": " + this.getSpace().getNodePath().toDisplayPath(this.getNodeService(), this.getPermissionService());
    }

    @Override
    public String getContainerTitle() {
        FacesContext fc = FacesContext.getCurrentInstance();
        return Application.getMessage(fc, MSG_DETAILS_OF) + " " + Application.getMessage(fc, MSG_LEFT_QUOTE) + this.getName() + Application.getMessage(fc, MSG_RIGHT_QUOTE);
    }

    @Override
    public String getOutcome() {
        return "dialog:close:dialog:showSpaceDetails";
    }

    @Override
    public String cancel() {
        this.navigator.resetCurrentNodeProperties();
        return super.cancel();
    }
}

