/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.SysAdminParams;
import org.alfresco.repo.template.I18NMessageMethod;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.util.UrlUtil;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.BaseTemplateContentServlet;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.repo.component.template.DefaultModelHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.mail.javamail.MimeMessagePreparator;

public class TemplateMailHelperBean
implements Serializable {
    private static final long serialVersionUID = 9117248002321651339L;
    private static Log logger = LogFactory.getLog(TemplateMailHelperBean.class);
    private transient JavaMailSender mailSender;
    private transient NodeService nodeService;
    private String subject = "";
    private String body = "";
    private String automaticText = "";
    private String template = null;
    private String usingTemplate = null;
    private String finalBody;

    public void setMailSender(JavaMailSender mailSender) {
        this.mailSender = mailSender;
    }

    protected JavaMailSender getMailSender() {
        if (this.mailSender == null) {
            this.mailSender = (JavaMailSender)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "mailService");
        }
        return this.mailSender;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    protected NodeService getNodeService() {
        if (this.nodeService == null) {
            this.nodeService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getNodeService();
        }
        return this.nodeService;
    }

    public void notifyUser(NodeRef person, NodeRef node, final String from, String roleText) {
        final String to = (String)((Object)this.getNodeService().getProperty(person, ContentModel.PROP_EMAIL));
        if (to != null && to.length() != 0) {
            String body = this.body;
            if (this.usingTemplate != null) {
                FacesContext fc = FacesContext.getCurrentInstance();
                NodeRef templateRef = new NodeRef(Repository.getStoreRef(), this.usingTemplate);
                ServiceRegistry services = Repository.getServiceRegistry(fc);
                Map<String, Object> model = DefaultModelHelper.buildDefaultModel(services, Application.getCurrentUser(fc), templateRef);
                model.put("role", roleText);
                model.put("space", node);
                model.put("url", new BaseTemplateContentServlet.URLHelper(fc));
                model.put("msg", new I18NMessageMethod());
                model.put("document", node);
                if (this.nodeService.getType(node).equals((Object)ContentModel.TYPE_CONTENT)) {
                    NodeRef parentNodeRef = ((ChildAssociationRef)this.nodeService.getParentAssocs(node).get(0)).getParentRef();
                    if (parentNodeRef == null) {
                        throw new IllegalArgumentException("Parent folder doesn't exists for node: " + node);
                    }
                    model.put("space", parentNodeRef);
                }
                model.put("shareUrl", UrlUtil.getShareUrl((SysAdminParams)services.getSysAdminParams()));
                body = services.getTemplateService().processTemplate("freemarker", templateRef.toString(), model);
            }
            this.finalBody = body;
            MimeMessagePreparator mailPreparer = new MimeMessagePreparator(){

                public void prepare(MimeMessage mimeMessage) throws MessagingException {
                    MimeMessageHelper message = new MimeMessageHelper(mimeMessage);
                    message.setTo(to);
                    message.setSubject(TemplateMailHelperBean.this.subject);
                    message.setText(TemplateMailHelperBean.this.finalBody);
                    message.setFrom(from);
                }
            };
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Sending notification email to: " + to + "\n...with subject:\n" + this.subject + "\n...with body:\n" + body));
            }
            try {
                this.getMailSender().send(mailPreparer);
            }
            catch (Throwable e) {
                logger.error((Object)("Failed to send email to " + to), e);
            }
        }
    }

    public void insertTemplate(ActionEvent event) {
        if (this.template != null && !this.template.equals("none")) {
            try {
                NodeRef templateRef = new NodeRef(Repository.getStoreRef(), this.template);
                ContentService cs = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getContentService();
                ContentReader reader = cs.getReader(templateRef, ContentModel.PROP_CONTENT);
                if (reader != null && reader.exists()) {
                    this.body = reader.getContentString();
                    this.usingTemplate = this.template;
                }
            }
            catch (Throwable err) {
                Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_generic"), err.getMessage()), err);
            }
        }
    }

    public void discardTemplate(ActionEvent event) {
        this.body = this.automaticText;
        this.usingTemplate = null;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getAutomaticText() {
        return this.automaticText;
    }

    public void setAutomaticText(String automaticText) {
        this.automaticText = automaticText;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getUsingTemplate() {
        return this.usingTemplate;
    }

    public void setUsingTemplate(String usingTemplate) {
        this.usingTemplate = usingTemplate;
    }
}

