/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.actions.handlers;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.actions.handlers.BaseActionHandler;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wizard.IWizardBean;

public class CopyHandler
extends BaseActionHandler {
    private static final long serialVersionUID = -3570705279828902437L;
    private static final String PROP_DEEPCOPY = "deepCopy";

    @Override
    public String getJSPPath() {
        return this.getJSPPath("copy");
    }

    @Override
    public void prepareForSave(Map<String, Serializable> actionProps, Map<String, Serializable> repoProps) {
        NodeRef destNodeRef = (NodeRef)actionProps.get("destinationLocation");
        repoProps.put("destination-folder", (Serializable)destNodeRef);
        Boolean deepCopy = (Boolean)actionProps.get(PROP_DEEPCOPY);
        repoProps.put("deep-copy", deepCopy);
    }

    @Override
    public void prepareForEdit(Map<String, Serializable> actionProps, Map<String, Serializable> repoProps) {
        NodeRef destNodeRef = (NodeRef)repoProps.get("destination-folder");
        actionProps.put("destinationLocation", (Serializable)destNodeRef);
        Boolean deepCopy = (Boolean)repoProps.get("deep-copy");
        actionProps.put(PROP_DEEPCOPY, deepCopy);
    }

    @Override
    public String generateSummary(FacesContext context, IWizardBean wizard, Map<String, Serializable> actionProps) {
        NodeRef space = (NodeRef)actionProps.get("destinationLocation");
        String spaceName = Repository.getNameForNode(Repository.getServiceRegistry(context).getNodeService(), space);
        return MessageFormat.format(Application.getMessage(context, "action_copy"), spaceName);
    }
}

