/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.actions.handlers;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.Pair;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.actions.handlers.BaseActionHandler;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.AVMUtil;
import org.alfresco.web.bean.wcm.WebProject;
import org.alfresco.web.bean.wizard.IWizardBean;

public class CopyToWebProjectHandler
extends BaseActionHandler {
    private static final long serialVersionUID = -6725139406646296868L;

    @Override
    public String getJSPPath() {
        return this.getJSPPath("copy-to-web-project");
    }

    @Override
    public void prepareForSave(Map<String, Serializable> actionProps, Map<String, Serializable> repoProps) {
        NodeRef destNodeRef = (NodeRef)actionProps.get("destinationLocation");
        if (destNodeRef.getStoreRef().getProtocol().equals("workspace")) {
            WebProject webProject = new WebProject(destNodeRef);
            String storeName = AVMUtil.buildUserMainStoreName(webProject.getStoreId(), Application.getCurrentUser(FacesContext.getCurrentInstance()).getUserName());
            String rootPath = AVMUtil.buildStoreWebappPath(storeName, "ROOT");
            destNodeRef = AVMNodeConverter.ToNodeRef((int)-1, (String)rootPath);
        }
        repoProps.put("destination-folder", (Serializable)destNodeRef);
    }

    @Override
    public void prepareForEdit(Map<String, Serializable> actionProps, Map<String, Serializable> repoProps) {
        NodeRef destNodeRef = (NodeRef)repoProps.get("destination-folder");
        actionProps.put("destinationLocation", (Serializable)destNodeRef);
    }

    @Override
    public String generateSummary(FacesContext context, IWizardBean wizard, Map<String, Serializable> actionProps) {
        NodeRef dest = (NodeRef)actionProps.get("destinationLocation");
        String folder = "/";
        String webProject = "?";
        if (dest.getStoreRef().getProtocol().equals("avm")) {
            Pair avmNode = AVMNodeConverter.ToAVMVersionPath((NodeRef)dest);
            String avmPath = (String)avmNode.getSecond();
            folder = avmPath.substring(avmPath.indexOf("ROOT") + 4);
            NodeRef webProjectNode = Repository.getServiceRegistry(context).getWebProjectService().getWebProjectNodeFromPath(avmPath);
            webProject = Repository.getNameForNode(Repository.getServiceRegistry(context).getNodeService(), webProjectNode);
        } else if (dest.getStoreRef().getProtocol().equals("avm")) {
            webProject = Repository.getNameForNode(Repository.getServiceRegistry(context).getNodeService(), dest);
        }
        return MessageFormat.format(Application.getMessage(context, "action_copy_to_web_project_folder"), folder, webProject);
    }
}

