/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.actions.handlers;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.actions.handlers.BaseActionHandler;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wizard.IWizardBean;

public class LinkCategoryHandler
extends BaseActionHandler {
    private static final long serialVersionUID = -5956987738674149920L;
    protected static final String PROP_CATEGORY = "category";

    @Override
    public String getJSPPath() {
        return this.getJSPPath("link-category");
    }

    @Override
    public void prepareForSave(Map<String, Serializable> actionProps, Map<String, Serializable> repoProps) {
        repoProps.put("category-aspect", (Serializable)ContentModel.ASPECT_GEN_CLASSIFIABLE);
        NodeRef catNodeRef = (NodeRef)actionProps.get(PROP_CATEGORY);
        repoProps.put("category-value", (Serializable)catNodeRef);
    }

    @Override
    public void prepareForEdit(Map<String, Serializable> actionProps, Map<String, Serializable> repoProps) {
        NodeRef catNodeRef = (NodeRef)repoProps.get("category-value");
        actionProps.put(PROP_CATEGORY, (Serializable)catNodeRef);
    }

    @Override
    public String generateSummary(FacesContext context, IWizardBean wizard, Map<String, Serializable> actionProps) {
        NodeRef cat = (NodeRef)actionProps.get(PROP_CATEGORY);
        String name = Repository.getNameForNode(Repository.getServiceRegistry(context).getNodeService(), cat);
        return MessageFormat.format(Application.getMessage(context, "action_link_category"), name);
    }
}

