/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.admin;

import java.text.MessageFormat;
import java.util.HashMap;
import javax.faces.context.FacesContext;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.BrowseBean;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.Repository;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExportDialog
extends BaseDialogBean {
    private static final long serialVersionUID = -2592252768301728700L;
    private static final Log logger = LogFactory.getLog(ExportDialog.class);
    private static final String ALL_SPACES = "all";
    private static final String CURRENT_SPACE = "current";
    private static final String DEFAULT_OUTCOME = "dialog:close";
    private static final String MSG_EXPORT_TITLE = "export_title";
    private static final String MSG_LEFT_QUOTE = "left_qoute";
    private static final String MSG_RIGHT_QUOTE = "right_quote";
    protected BrowseBean browseBean;
    private transient ActionService actionService;
    private String packageName;
    private String encoding = "UTF-8";
    private String mode = "current";
    private NodeRef destination;
    private boolean includeChildren = true;
    private boolean runInBackground = true;
    private boolean includeSelf;

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Called export for " + this.mode + " with package name: " + this.packageName));
        }
        Action action = null;
        NodeRef startNode = this.browseBean.getActionSpace().getNodeRef();
        if (this.mode.equals(ALL_SPACES)) {
            HashMap<String, String> params = new HashMap<String, String>(5);
            params.put("package-name", this.packageName);
            params.put("destination", (String)this.destination);
            action = this.getActionService().createAction("repository-export", params);
        } else {
            HashMap<String, Object> params = new HashMap<String, Object>(5);
            params.put("store", Repository.getStoreRef().toString());
            params.put("package-name", this.packageName);
            params.put("encoding", this.encoding);
            params.put("destination", this.destination);
            params.put("include-children", this.includeChildren);
            params.put("include-self", new Boolean(this.includeSelf));
            action = this.getActionService().createAction("export", params);
        }
        action.setExecuteAsynchronously(this.runInBackground);
        this.getActionService().executeAction(action, startNode);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executed space export action with action params of " + action.getParameterValues()));
        }
        this.reset();
        return outcome;
    }

    @Override
    public String getContainerTitle() {
        FacesContext fc = FacesContext.getCurrentInstance();
        String name = Application.getMessage(fc, MSG_LEFT_QUOTE) + this.browseBean.getActionSpace().getName() + Application.getMessage(fc, MSG_RIGHT_QUOTE);
        return MessageFormat.format(Application.getMessage(fc, MSG_EXPORT_TITLE), name);
    }

    @Override
    public String cancel() {
        this.reset();
        return DEFAULT_OUTCOME;
    }

    public void reset() {
        this.packageName = null;
        this.mode = CURRENT_SPACE;
        this.destination = null;
        this.includeChildren = true;
        this.includeSelf = false;
        this.runInBackground = true;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public NodeRef getDestination() {
        return this.destination;
    }

    public void setDestination(NodeRef destination) {
        this.destination = destination;
    }

    public boolean getIncludeChildren() {
        return this.includeChildren;
    }

    public void setIncludeChildren(boolean includeChildren) {
        this.includeChildren = includeChildren;
    }

    public boolean getIncludeSelf() {
        return this.includeSelf;
    }

    public void setIncludeSelf(boolean includeSelf) {
        this.includeSelf = includeSelf;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean getRunInBackground() {
        return this.runInBackground;
    }

    public void setRunInBackground(boolean runInBackground) {
        this.runInBackground = runInBackground;
    }

    @Override
    public void setBrowseBean(BrowseBean browseBean) {
        this.browseBean = browseBean;
    }

    public void setActionService(ActionService actionService) {
        this.actionService = actionService;
    }

    protected ActionService getActionService() {
        if (this.actionService == null) {
            this.actionService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getActionService();
        }
        return this.actionService;
    }
}

