/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.admin;

import java.io.File;
import java.text.MessageFormat;
import java.util.HashMap;
import javax.faces.context.FacesContext;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.DuplicateChildNodeNameException;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.FileUploadBean;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.ui.common.ReportedException;
import org.alfresco.web.ui.common.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class ImportDialog
extends BaseDialogBean {
    private static final long serialVersionUID = -8563911447832447065L;
    private static final Log logger = LogFactory.getLog(ImportDialog.class);
    private static final String DEFAULT_OUTCOME = "dialog:close";
    private static final String MSG_ERROR = "error_import";
    private static final String ERR_DUPLICATE_NAME = "system.err.duplicate_name";
    private static final String MSG_ERROR_NO_FILE = "error_import_no_file";
    private static final String MSG_ERROR_EMPTY_FILE = "error_import_empty_file";
    private static final String MSG_OK = "ok";
    private static final String MSG_IMPORT_TITLE = "import_title";
    private static final String MSG_LEFT_QUOTE = "left_qoute";
    private static final String MSG_RIGHT_QUOTE = "right_quote";
    private transient ActionService actionService;
    private transient ContentService contentService;
    private transient MimetypeService mimetypeService;
    private File file;
    private String fileName;
    private String encoding = "UTF-8";
    private boolean runInBackground = true;

    public String performImport(final FacesContext context, String outcome) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Called import for file: " + this.file));
        }
        if (this.file != null && this.file.exists()) {
            if (this.file.length() > 0L) {
                try {
                    RetryingTransactionHelper txnHelper = Repository.getRetryingTransactionHelper(context);
                    RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                        public Object execute() throws Throwable {
                            NodeRef acpNodeRef = ImportDialog.this.addFileToRepository(context);
                            HashMap<String, Object> params = new HashMap<String, Object>(2, 1.0f);
                            params.put("destination", ImportDialog.this.browseBean.getActionSpace().getNodeRef());
                            params.put("encoding", ImportDialog.this.encoding);
                            Action action = ImportDialog.this.getActionService().createAction("import", params);
                            action.setExecuteAsynchronously(ImportDialog.this.runInBackground);
                            ImportDialog.this.getActionService().executeAction(action, acpNodeRef);
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Executed import action with action params of " + params));
                            }
                            return null;
                        }
                    };
                    txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
                    this.reset();
                }
                catch (Throwable e) {
                    if (e instanceof DuplicateChildNodeNameException) {
                        String name = ((DuplicateChildNodeNameException)e).getName();
                        String err_mess = MessageFormat.format(I18NUtil.getMessage((String)ERR_DUPLICATE_NAME), name);
                        Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), MSG_ERROR), err_mess), e);
                    } else {
                        Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), MSG_ERROR), e.toString()), e);
                    }
                    outcome = null;
                    ReportedException.throwIfNecessary(e);
                }
            } else {
                Utils.addErrorMessage(Application.getMessage(FacesContext.getCurrentInstance(), MSG_ERROR_EMPTY_FILE));
                outcome = null;
            }
        } else {
            Utils.addErrorMessage(Application.getMessage(FacesContext.getCurrentInstance(), MSG_ERROR_NO_FILE));
            outcome = null;
        }
        return outcome;
    }

    @Override
    public String cancel() {
        this.reset();
        return DEFAULT_OUTCOME;
    }

    public void reset() {
        this.file = null;
        this.fileName = null;
        this.runInBackground = true;
        if (this.file != null) {
            this.file.delete();
        }
        FacesContext ctx = FacesContext.getCurrentInstance();
        ctx.getExternalContext().getSessionMap().remove("alfresco.UploadBean");
    }

    public String getFileUploadSuccessMsg() {
        String msg = Application.getMessage(FacesContext.getCurrentInstance(), "file_upload_success");
        return MessageFormat.format(msg, Utils.encode((String)this.getFileName()));
    }

    public String getFileName() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        FileUploadBean fileBean = (FileUploadBean)ctx.getExternalContext().getSessionMap().get("alfresco.UploadBean");
        if (fileBean != null) {
            this.fileName = fileBean.getFileName();
            this.file = fileBean.getFile();
        }
        return this.fileName;
    }

    public void setFileName(String fileName) {
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean getRunInBackground() {
        return this.runInBackground;
    }

    public void setRunInBackground(boolean runInBackground) {
        this.runInBackground = runInBackground;
    }

    public void setActionService(ActionService actionService) {
        this.actionService = actionService;
    }

    protected ActionService getActionService() {
        if (this.actionService == null) {
            this.actionService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getActionService();
        }
        return this.actionService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    protected ContentService getContentService() {
        if (this.contentService == null) {
            this.contentService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getContentService();
        }
        return this.contentService;
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    protected MimetypeService getMimetypeService() {
        if (this.mimetypeService == null) {
            this.mimetypeService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getMimetypeService();
        }
        return this.mimetypeService;
    }

    private NodeRef addFileToRepository(FacesContext context) {
        HashMap<QName, String> contentProps = new HashMap<QName, String>(1);
        contentProps.put(ContentModel.PROP_NAME, this.fileName);
        String assocName = QName.createValidLocalName((String)this.fileName);
        ChildAssociationRef assocRef = this.getNodeService().createNode(this.browseBean.getActionSpace().getNodeRef(), ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)assocName), ContentModel.TYPE_CONTENT, contentProps);
        NodeRef acpNodeRef = assocRef.getChildRef();
        String mimetype = this.getMimetypeService().guessMimetype(this.fileName);
        HashMap<QName, String> titledProps = new HashMap<QName, String>(2, 1.0f);
        titledProps.put(ContentModel.PROP_TITLE, this.fileName);
        titledProps.put(ContentModel.PROP_DESCRIPTION, "application/acp".equals(mimetype) ? Application.getMessage(context, "import_acp_description") : Application.getMessage(context, "import_zip_description"));
        this.getNodeService().addAspect(acpNodeRef, ContentModel.ASPECT_TITLED, titledProps);
        ContentWriter writer = this.getContentService().getWriter(acpNodeRef, ContentModel.PROP_CONTENT, true);
        writer.setEncoding(this.encoding);
        writer.setMimetype(mimetype);
        writer.putContent(this.file);
        return acpNodeRef;
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        return this.performImport(context, outcome);
    }

    @Override
    public boolean getFinishButtonDisabled() {
        return this.getFileName() == null;
    }

    @Override
    public String getFinishButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), MSG_OK);
    }

    @Override
    public String getContainerTitle() {
        FacesContext fc = FacesContext.getCurrentInstance();
        String name = Application.getMessage(fc, MSG_LEFT_QUOTE) + this.browseBean.getActionSpace().getName() + Application.getMessage(fc, MSG_RIGHT_QUOTE);
        return MessageFormat.format(Application.getMessage(fc, MSG_IMPORT_TITLE), name);
    }
}

