/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.ajax;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.http.HttpServletRequest;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.TempFileProvider;
import org.alfresco.util.XMLUtil;
import org.alfresco.web.app.servlet.BaseServlet;
import org.alfresco.web.app.servlet.ajax.InvokeCommand;
import org.alfresco.web.bean.repository.Repository;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.URLDecoder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class FileUploadBean
implements Serializable {
    private static final long serialVersionUID = 4555828718375916674L;
    private static Log logger = LogFactory.getLog(FileUploadBean.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InvokeCommand.ResponseMimetype(value="text/html")
    public void uploadFile() throws Exception {
        String returnPage;
        FacesContext fc;
        block26: {
            fc = FacesContext.getCurrentInstance();
            ExternalContext externalContext = fc.getExternalContext();
            HttpServletRequest request = (HttpServletRequest)externalContext.getRequest();
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
            upload.setHeaderEncoding("UTF-8");
            List fileItems = upload.parseRequest(request);
            FileUploadBean bean = new FileUploadBean();
            String currentPath = null;
            String filename = null;
            returnPage = null;
            File file = null;
            for (FileItem item : fileItems) {
                if (item.isFormField() && item.getFieldName().equals("return-page")) {
                    returnPage = item.getString();
                    continue;
                }
                if (item.isFormField() && item.getFieldName().equals("currentPath")) {
                    currentPath = URLDecoder.decode((String)item.getString());
                    continue;
                }
                filename = FilenameUtils.getName((String)item.getName());
                file = TempFileProvider.createTempFile((String)"alfresco", (String)".upload");
                item.write(file);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Ajax file upload request: " + filename + " to path: " + currentPath + " return page: " + returnPage));
            }
            try {
                NodeRef containerRef;
                if (file == null || currentPath == null || currentPath.length() == 0 || (containerRef = FileUploadBean.pathToNodeRef(fc, currentPath)) == null) break block26;
                String mimetype = Repository.getMimeTypeForFileName(fc, filename);
                String encoding = "UTF-8";
                InputStream is = null;
                try {
                    is = new BufferedInputStream(new FileInputStream(file));
                    encoding = Repository.guessEncoding(fc, is, mimetype);
                }
                catch (Throwable e) {
                    logger.error((Object)("Failed to guess character encoding of file: " + file), e);
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable e) {}
                    }
                }
                FileContentReader cr = new FileContentReader(file);
                cr.setMimetype(mimetype);
                String author = null;
                String title = null;
                String description = null;
                HashMap<QName, Serializable> contentProps = new HashMap<QName, Serializable>(5, 1.0f);
                if (Repository.extractMetadata(fc, (ContentReader)cr, contentProps)) {
                    author = (String)contentProps.get(ContentModel.PROP_AUTHOR);
                    title = (String)DefaultTypeConverter.INSTANCE.convert(String.class, contentProps.get(ContentModel.PROP_TITLE));
                    description = (String)DefaultTypeConverter.INSTANCE.convert(String.class, contentProps.get(ContentModel.PROP_DESCRIPTION));
                }
                if (title == null) {
                    title = filename;
                }
                ServiceRegistry services = Repository.getServiceRegistry(fc);
                FileInfo fileInfo = services.getFileFolderService().create(containerRef, filename, ContentModel.TYPE_CONTENT);
                NodeRef fileNodeRef = fileInfo.getNodeRef();
                if (author != null) {
                    HashMap<QName, String> authorProps = new HashMap<QName, String>(1, 1.0f);
                    authorProps.put(ContentModel.PROP_AUTHOR, author);
                    services.getNodeService().addAspect(fileNodeRef, ContentModel.ASPECT_AUTHOR, authorProps);
                }
                HashMap<QName, String> titledProps = new HashMap<QName, String>(2, 1.0f);
                titledProps.put(ContentModel.PROP_TITLE, title);
                titledProps.put(ContentModel.PROP_DESCRIPTION, description);
                services.getNodeService().addAspect(fileNodeRef, ContentModel.ASPECT_TITLED, titledProps);
                ContentWriter writer = services.getContentService().getWriter(fileNodeRef, ContentModel.PROP_CONTENT, true);
                writer.setMimetype(mimetype);
                writer.setEncoding(encoding);
                writer.putContent(file);
            }
            catch (Exception e) {
                returnPage = returnPage.replace("${UPLOAD_ERROR}", e.getMessage());
            }
            finally {
                if (file != null) {
                    logger.debug((Object)("delete temporary file:" + file.getPath()));
                    file.delete();
                }
            }
        }
        Document result = XMLUtil.newDocument();
        Element htmlEl = result.createElement("html");
        result.appendChild(htmlEl);
        Element bodyEl = result.createElement("body");
        htmlEl.appendChild(bodyEl);
        Element scriptEl = result.createElement("script");
        bodyEl.appendChild(scriptEl);
        scriptEl.setAttribute("type", "text/javascript");
        Text scriptText = result.createTextNode(returnPage);
        scriptEl.appendChild(scriptText);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"File upload request complete.");
        }
        ResponseWriter out = fc.getResponseWriter();
        XMLUtil.print((Node)result, (Writer)out);
    }

    static NodeRef pathToNodeRef(FacesContext fc, String path) {
        StringTokenizer t = new StringTokenizer(path, "/");
        int tokenCount = t.countTokens();
        String[] elements = new String[tokenCount];
        for (int i = 0; i < tokenCount; ++i) {
            elements[i] = t.nextToken();
        }
        return BaseServlet.resolveWebDAVPath(fc, elements, false);
    }
}

