/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.ajax;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.alfresco.repo.content.transform.TransformerInfoException;
import org.alfresco.repo.template.I18NMessageMethod;
import org.alfresco.repo.template.TemplateNode;
import org.alfresco.repo.web.scripts.FileTypeImageUtils;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.FileTypeImageSize;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.TemplateException;
import org.alfresco.service.cmr.repository.TemplateImageResolver;
import org.alfresco.web.app.servlet.BaseTemplateContentServlet;
import org.alfresco.web.bean.repository.Repository;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class NodeInfoBean
implements Serializable {
    private static final long serialVersionUID = 137294178658919187L;
    private transient NodeService nodeService;
    private static final Log logger = LogFactory.getLog(NodeInfoBean.class);
    private TemplateImageResolver imageResolver = new TemplateImageResolver(){

        public String resolveImagePathForName(String filename, FileTypeImageSize size) {
            return FileTypeImageUtils.getFileTypeImage((FacesContext)FacesContext.getCurrentInstance(), (String)filename, (FileTypeImageSize)size);
        }
    };

    public void sendNodeInfo() throws IOException {
        FacesContext context = FacesContext.getCurrentInstance();
        ResponseWriter out = context.getResponseWriter();
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String strNodeRef = (String)requestMap.get("noderef");
        String strTemplate = (String)requestMap.get("template");
        if (strTemplate == null || strTemplate.length() == 0) {
            strTemplate = "node_summary_panel.ftl";
        }
        NodeRef nodeRef = null;
        if (strNodeRef != null && strNodeRef.length() != 0) {
            nodeRef = new NodeRef(strNodeRef);
            if (!this.getNodeService().exists(nodeRef)) {
                out.write("<span class='errorMessage'>Node could not be found in the repository!</span>");
                return;
            }
        }
        try {
            Repository.getServiceRegistry(context).getTemplateService().processTemplate("/alfresco/templates/client/" + strTemplate, this.getModel(nodeRef, requestMap), (Writer)out);
        }
        catch (TemplateException ex) {
            Throwable cause = ex.getCause();
            while (cause != null) {
                if (!((cause = cause.getCause()) instanceof TransformerInfoException)) continue;
                out.write("<tr><td colspan=\"2\"><span class='errorMessage'>" + cause.getMessage() + "</span></td></tr>");
                return;
            }
            throw ex;
        }
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    private NodeService getNodeService() {
        if (this.nodeService == null) {
            this.nodeService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getNodeService();
        }
        return this.nodeService;
    }

    private Map<String, Object> getModel(NodeRef nodeRef, Map<String, String> requestMap) throws ContentIOException {
        FacesContext context = FacesContext.getCurrentInstance();
        HashMap<String, Object> model = new HashMap<String, Object>(8, 1.0f);
        I18NUtil.registerResourceBundle((String)"alfresco.messages.webclient");
        model.put("date", new Date());
        model.put("msg", new I18NMessageMethod());
        model.put("url", new BaseTemplateContentServlet.URLHelper(context));
        model.put("locale", I18NUtil.getLocale());
        if (nodeRef != null) {
            model.put("node", new TemplateNode(nodeRef, Repository.getServiceRegistry(context), this.imageResolver));
        }
        HashMap<String, String> args = new HashMap<String, String>(4, 1.0f);
        for (String name : requestMap.keySet()) {
            args.put(name, requestMap.get(name));
        }
        model.put("args", args);
        return model;
    }
}

