/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.ajax;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.version.VersionType;
import org.alfresco.web.app.servlet.ajax.InvokeCommand;
import org.alfresco.web.bean.repository.Repository;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PortletActionsBean
implements Serializable {
    private static final long serialVersionUID = -8230154592621310289L;
    private static Log logger = LogFactory.getLog(PortletActionsBean.class);

    @InvokeCommand.ResponseMimetype(value="text/html")
    public void deleteItem() throws Exception {
        FacesContext fc = FacesContext.getCurrentInstance();
        ResponseWriter out = fc.getResponseWriter();
        Map requestMap = fc.getExternalContext().getRequestParameterMap();
        String strNodeRef = (String)requestMap.get("noderef");
        if (strNodeRef != null && strNodeRef.length() != 0) {
            try {
                Repository.getServiceRegistry(fc).getFileFolderService().delete(new NodeRef(strNodeRef));
                out.write("OK: " + strNodeRef);
            }
            catch (Throwable err) {
                out.write("ERROR: " + err.getMessage());
            }
        }
    }

    @InvokeCommand.ResponseMimetype(value="text/html")
    public void checkoutItem() throws Exception {
        FacesContext fc = FacesContext.getCurrentInstance();
        ResponseWriter out = fc.getResponseWriter();
        Map requestMap = fc.getExternalContext().getRequestParameterMap();
        String strNodeRef = (String)requestMap.get("noderef");
        if (strNodeRef != null && strNodeRef.length() != 0) {
            try {
                Repository.getServiceRegistry(fc).getCheckOutCheckInService().checkout(new NodeRef(strNodeRef));
                out.write("OK: " + strNodeRef);
            }
            catch (Throwable err) {
                out.write("ERROR: " + err.getMessage());
            }
        }
    }

    @InvokeCommand.ResponseMimetype(value="text/html")
    public void checkinItem() throws Exception {
        FacesContext fc = FacesContext.getCurrentInstance();
        ResponseWriter out = fc.getResponseWriter();
        Map requestMap = fc.getExternalContext().getRequestParameterMap();
        String strNodeRef = (String)requestMap.get("noderef");
        if (strNodeRef != null && strNodeRef.length() != 0) {
            try {
                HashMap<String, String> props = new HashMap<String, String>(2, 1.0f);
                props.put("description", "");
                props.put("versionType", (String)VersionType.MINOR);
                Repository.getServiceRegistry(fc).getCheckOutCheckInService().checkin(new NodeRef(strNodeRef), props);
                out.write("OK: " + strNodeRef);
            }
            catch (Throwable err) {
                out.write("ERROR: " + err.getMessage());
            }
        }
    }
}

