/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.categories;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.Node;
import org.springframework.extensions.surf.util.ParameterCheck;

public class EditNodeCategoriesDialog
extends BaseDialogBean {
    private static final long serialVersionUID = -1879847736997772606L;
    protected Node node;
    protected NodeRef addedCategory;
    protected List categories;
    protected String description;
    private static final String MSG_ERROR_UPDATE_CATEGORY = "error_update_category";
    private static final String MSG_MODIFY_CATEGORIES_OF = "modify_categories_of";
    private static final String MSG_LEFT_QUOTE = "left_qoute";
    private static final String MSG_RIGHT_QUOTE = "right_quote";

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.categories = null;
        this.addedCategory = null;
        String nodeRef = parameters.get("nodeRef");
        ParameterCheck.mandatoryString((String)"nodeRef", (String)nodeRef);
        this.node = new Node(new NodeRef(nodeRef));
        FacesContext context = FacesContext.getCurrentInstance();
        this.description = this.getDictionaryService().isSubClass(this.node.getType(), ContentModel.TYPE_FOLDER) ? Application.getMessage(context, "editcategory_space_description") : Application.getMessage(context, "editcategory_description");
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        Map updateProps = this.getNodeService().getProperties(this.node.getNodeRef());
        updateProps.put(ContentModel.PROP_CATEGORIES, (Serializable)((Object)this.categories));
        this.getNodeService().setProperties(this.node.getNodeRef(), updateProps);
        return outcome;
    }

    @Override
    public boolean getFinishButtonDisabled() {
        return false;
    }

    @Override
    public String getContainerTitle() {
        FacesContext fc = FacesContext.getCurrentInstance();
        return Application.getMessage(fc, MSG_MODIFY_CATEGORIES_OF) + " " + Application.getMessage(fc, MSG_LEFT_QUOTE) + this.node.getName() + Application.getMessage(fc, MSG_RIGHT_QUOTE);
    }

    @Override
    public String getContainerDescription() {
        return this.description;
    }

    @Override
    protected String getErrorMessageId() {
        return MSG_ERROR_UPDATE_CATEGORY;
    }

    public List getCategories() {
        if (this.categories == null) {
            this.categories = (List)((Object)this.getNodeService().getProperty(this.node.getNodeRef(), ContentModel.PROP_CATEGORIES));
        }
        return this.categories;
    }

    public void setCategories(List categories) {
        this.categories = categories;
    }

    public NodeRef getAddedCategory() {
        return this.addedCategory;
    }

    public void setAddedCategory(NodeRef addedCategory) {
        this.addedCategory = addedCategory;
    }
}

