/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.clipboard;

import java.util.List;
import javax.faces.context.FacesContext;
import javax.transaction.UserTransaction;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.service.cmr.avm.AVMExistsException;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.repository.CrossRepositoryCopyService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.wcm.util.WCMUtil;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.NavigationBean;
import org.alfresco.web.bean.clipboard.AbstractClipboardItem;
import org.alfresco.web.bean.clipboard.ClipboardStatus;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.AVMBrowseBean;

public class AVMClipboardItem
extends AbstractClipboardItem {
    private static final long serialVersionUID = 2550867083821268131L;
    private static final String AVM_PASTE_VIEW_ID = "/jsp/wcm/browse-sandbox.jsp";
    private static final String WORKSPACE_PASTE_VIEW_ID = "/jsp/browse/browse.jsp";

    public AVMClipboardItem(NodeRef ref, ClipboardStatus mode, List<String> customPasteViewIds) {
        super(ref, mode, customPasteViewIds);
    }

    @Override
    public boolean supportsLink() {
        return false;
    }

    @Override
    public boolean canCopyToViewId(String viewId) {
        if (super.canCopyToViewId(viewId) || AVM_PASTE_VIEW_ID.equals(viewId)) {
            AVMBrowseBean avmBrowseBean = (AVMBrowseBean)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "AVMBrowseBean");
            String destPath = avmBrowseBean.getCurrentPath();
            return !WCMUtil.isStagingStore((String)WCMUtil.getStoreName((String)destPath));
        }
        return super.canCopyToViewId(viewId) || WORKSPACE_PASTE_VIEW_ID.equals(viewId);
    }

    @Override
    public boolean canMoveToViewId(String viewId) {
        return AVM_PASTE_VIEW_ID.equals(viewId);
    }

    @Override
    public boolean paste(FacesContext fc, String viewId, int action) throws Throwable {
        if (AVM_PASTE_VIEW_ID.equals(viewId)) {
            AVMBrowseBean avmBrowseBean = (AVMBrowseBean)FacesHelper.getManagedBean(fc, "AVMBrowseBean");
            String destPath = avmBrowseBean.getCurrentPath();
            NodeRef destRef = AVMNodeConverter.ToNodeRef((int)-1, (String)destPath);
            String sourcePath = (String)AVMNodeConverter.ToAVMVersionPath((NodeRef)this.getNodeRef()).getSecond();
            String name = this.getName();
            boolean operationComplete = false;
            while (!operationComplete) {
                String copyOf;
                UserTransaction tx = null;
                try {
                    tx = Repository.getUserTransaction(fc);
                    tx.begin();
                    if (this.getMode() == ClipboardStatus.COPY) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Attempting to copy node path: " + sourcePath + " into path: " + destPath));
                        }
                        if (AVMNodeConverter.ExtendAVMPath((String)destPath, (String)name).equals(sourcePath)) {
                            copyOf = Application.getMessage(fc, "copy_of");
                            name = copyOf + ' ' + name;
                        }
                        this.getAvmService().copy(-1, sourcePath, destPath, name);
                        AVMNodeDescriptor desc = this.getAvmService().lookup(-1, destPath + "/" + name);
                        this.recursiveFormCheck(desc);
                        operationComplete = true;
                        continue;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Attempting to move node path: " + sourcePath + " into path: " + destRef));
                    }
                    this.getAvmService().rename(AVMNodeConverter.SplitBase((String)sourcePath)[0], this.getName(), destPath, name);
                    operationComplete = true;
                }
                catch (FileExistsException fileExistsErr) {
                    if (this.getMode() == ClipboardStatus.COPY) continue;
                    throw fileExistsErr;
                }
                catch (AVMExistsException avmExistsErr) {
                    if (this.getMode() == ClipboardStatus.COPY) continue;
                    throw avmExistsErr;
                }
                catch (Throwable e) {
                    throw e;
                }
                finally {
                    if (!operationComplete) {
                        try {
                            if (tx != null) {
                                tx.rollback();
                            }
                        }
                        catch (Exception tex) {}
                        copyOf = Application.getMessage(fc, "copy_of");
                        name = copyOf + ' ' + name;
                        continue;
                    }
                    tx.commit();
                }
            }
            return operationComplete;
        }
        if (WORKSPACE_PASTE_VIEW_ID.equals(viewId)) {
            NavigationBean navigator = (NavigationBean)FacesHelper.getManagedBean(fc, "NavigationBean");
            NodeRef destRef = new NodeRef(Repository.getStoreRef(), navigator.getCurrentNodeId());
            CrossRepositoryCopyService crossRepoCopyService = this.getServiceRegistry().getCrossRepositoryCopyService();
            String name = this.getName();
            boolean operationComplete = false;
            while (!operationComplete) {
                UserTransaction tx = null;
                try {
                    tx = Repository.getUserTransaction(fc);
                    tx.begin();
                    if (this.getMode() == ClipboardStatus.COPY) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Attempting to copy node: " + this.getNodeRef() + " into node ID: " + destRef.toString()));
                        }
                        crossRepoCopyService.copy(this.getNodeRef(), destRef, name);
                        if (destRef.getStoreRef().getProtocol().equals("avm")) {
                            String destPath = (String)AVMNodeConverter.ToAVMVersionPath((NodeRef)destRef).getSecond();
                            AVMNodeDescriptor desc = this.getAvmService().lookup(-1, destPath + "/" + name);
                            this.recursiveFormCheck(desc);
                        }
                        operationComplete = true;
                        continue;
                    }
                    throw new Exception("Move operation not supported between stores.");
                }
                catch (FileExistsException fileExistsErr) {
                    if (this.getMode() == ClipboardStatus.COPY) continue;
                    throw fileExistsErr;
                }
                catch (Throwable e) {
                    throw e;
                }
                finally {
                    if (!operationComplete) {
                        try {
                            if (tx != null) {
                                tx.rollback();
                            }
                        }
                        catch (Exception tex) {}
                        String copyOf = Application.getMessage(fc, "copy_of");
                        name = copyOf + ' ' + name;
                        continue;
                    }
                    tx.commit();
                }
            }
            return operationComplete;
        }
        return false;
    }
}

