/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.clipboard;

import java.util.HashMap;
import java.util.List;
import javax.faces.context.FacesContext;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.ml.MultilingualContentService;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.CrossRepositoryCopyService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.wcm.util.WCMUtil;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.NavigationBean;
import org.alfresco.web.bean.clipboard.AbstractClipboardItem;
import org.alfresco.web.bean.clipboard.ClipboardStatus;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.AVMBrowseBean;

public class WorkspaceClipboardItem
extends AbstractClipboardItem {
    private static final long serialVersionUID = -1686557602737846009L;
    private static final String WORKSPACE_PASTE_VIEW_ID = "/jsp/browse/browse.jsp";
    private static final String AVM_PASTE_VIEW_ID = "/jsp/wcm/browse-sandbox.jsp";
    private static final String FORUMS_PASTE_VIEW_ID = "/jsp/forums/forums.jsp";
    private static final String FORUM_PASTE_VIEW_ID = "/jsp/forums/forum.jsp";
    private static final String MSG_LINK_TO = "link_to";
    private static final String LINK_NODE_EXTENSION = ".url";

    public WorkspaceClipboardItem(NodeRef ref, ClipboardStatus mode, List<String> customPasteViewIds) {
        super(ref, mode, customPasteViewIds);
    }

    public WorkspaceClipboardItem(NodeRef ref, NodeRef parent, ClipboardStatus mode, List<String> customPasteViewIds) {
        super(ref, parent, mode, customPasteViewIds);
    }

    @Override
    public boolean supportsLink() {
        return true;
    }

    @Override
    public boolean canCopyToViewId(String viewId) {
        if (AVM_PASTE_VIEW_ID.equals(viewId)) {
            AVMBrowseBean avmBrowseBean = (AVMBrowseBean)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "AVMBrowseBean");
            String destPath = avmBrowseBean.getCurrentPath();
            return !WCMUtil.isStagingStore((String)WCMUtil.getStoreName((String)destPath));
        }
        return super.canCopyToViewId(viewId) || WORKSPACE_PASTE_VIEW_ID.equals(viewId) || AVM_PASTE_VIEW_ID.equals(viewId) || FORUMS_PASTE_VIEW_ID.equals(viewId) || FORUM_PASTE_VIEW_ID.equals(viewId);
    }

    @Override
    public boolean canMoveToViewId(String viewId) {
        return super.canMoveToViewId(viewId) || WORKSPACE_PASTE_VIEW_ID.equals(viewId) || FORUMS_PASTE_VIEW_ID.equals(viewId) || FORUM_PASTE_VIEW_ID.equals(viewId);
    }

    @Override
    public boolean paste(FacesContext fc, String viewId, final int action) {
        ServiceRegistry serviceRegistry = this.getServiceRegistry();
        RetryingTransactionHelper retryingTransactionHelper = serviceRegistry.getRetryingTransactionHelper();
        if (super.canCopyToViewId(viewId) || WORKSPACE_PASTE_VIEW_ID.equals(viewId) || FORUMS_PASTE_VIEW_ID.equals(viewId) || FORUM_PASTE_VIEW_ID.equals(viewId)) {
            boolean isPrimaryParent;
            ChildAssociationRef assocRef;
            NavigationBean navigator = (NavigationBean)FacesHelper.getManagedBean(fc, "NavigationBean");
            final NodeRef destRef = new NodeRef(Repository.getStoreRef(), navigator.getCurrentNodeId());
            final DictionaryService dd = serviceRegistry.getDictionaryService();
            final NodeService nodeService = serviceRegistry.getNodeService();
            final FileFolderService fileFolderService = serviceRegistry.getFileFolderService();
            final CopyService copyService = serviceRegistry.getCopyService();
            final MultilingualContentService multilingualContentService = serviceRegistry.getMultilingualContentService();
            if (this.getParent() == null) {
                assocRef = nodeService.getPrimaryParent(this.getNodeRef());
                isPrimaryParent = true;
            } else {
                NodeRef parentNodeRef = this.getParent();
                List assocList = nodeService.getParentAssocs(this.getNodeRef());
                ChildAssociationRef foundRef = null;
                if (assocList != null) {
                    for (ChildAssociationRef assocListEntry : assocList) {
                        if (!parentNodeRef.equals((Object)assocListEntry.getParentRef())) continue;
                        foundRef = assocListEntry;
                        break;
                    }
                }
                assocRef = foundRef;
                isPrimaryParent = parentNodeRef.equals((Object)nodeService.getPrimaryParent(this.getNodeRef()).getParentRef());
            }
            String name = this.getName();
            String translationPrefix = "";
            if (action == 4) {
                String linkTo = Application.getMessage(fc, MSG_LINK_TO);
                name = linkTo + ' ' + name;
            }
            while (true) {
                try {
                    final String currentTranslationPrefix = translationPrefix;
                    final String currentName = name;
                    retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                        public Void execute() throws Throwable {
                            if (WorkspaceClipboardItem.this.getMode() == ClipboardStatus.COPY) {
                                if (action == 4) {
                                    if (AbstractClipboardItem.logger.isDebugEnabled()) {
                                        AbstractClipboardItem.logger.debug((Object)("Attempting to link node ID: " + WorkspaceClipboardItem.this.getNodeRef() + " into node: " + destRef.toString()));
                                    }
                                    if (!WorkspaceClipboardItem.this.checkExists(currentName + WorkspaceClipboardItem.LINK_NODE_EXTENSION, destRef)) {
                                        HashMap<QName, String> props = new HashMap<QName, String>(2, 1.0f);
                                        String newName = currentName + WorkspaceClipboardItem.LINK_NODE_EXTENSION;
                                        props.put(ContentModel.PROP_NAME, newName);
                                        props.put(ContentModel.PROP_LINK_DESTINATION, (String)WorkspaceClipboardItem.this.getNodeRef());
                                        if (dd.isSubClass(WorkspaceClipboardItem.this.getType(), ContentModel.TYPE_CONTENT)) {
                                            ChildAssociationRef childRef = nodeService.createNode(destRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)assocRef.getQName().getNamespaceURI(), (String)newName), ApplicationModel.TYPE_FILELINK, props);
                                            HashMap<QName, String> titledProps = new HashMap<QName, String>(2, 1.0f);
                                            titledProps.put(ContentModel.PROP_TITLE, currentName);
                                            titledProps.put(ContentModel.PROP_DESCRIPTION, currentName);
                                            nodeService.addAspect(childRef.getChildRef(), ContentModel.ASPECT_TITLED, titledProps);
                                        } else {
                                            ChildAssociationRef childRef = nodeService.createNode(destRef, ContentModel.ASSOC_CONTAINS, assocRef.getQName(), ApplicationModel.TYPE_FOLDERLINK, props);
                                            HashMap<QName, String> uiFacetsProps = new HashMap<QName, String>(4, 1.0f);
                                            uiFacetsProps.put(ApplicationModel.PROP_ICON, "space-icon-link");
                                            uiFacetsProps.put(ContentModel.PROP_TITLE, currentName);
                                            uiFacetsProps.put(ContentModel.PROP_DESCRIPTION, currentName);
                                            nodeService.addAspect(childRef.getChildRef(), ApplicationModel.ASPECT_UIFACETS, uiFacetsProps);
                                        }
                                    }
                                } else {
                                    if (AbstractClipboardItem.logger.isDebugEnabled()) {
                                        AbstractClipboardItem.logger.debug((Object)("Attempting to copy node: " + WorkspaceClipboardItem.this.getNodeRef() + " into node ID: " + destRef.toString()));
                                    }
                                    if (destRef.equals((Object)assocRef.getParentRef()) && currentName.equals(WorkspaceClipboardItem.this.getName())) {
                                        throw new FileExistsException(destRef, currentName);
                                    }
                                    if (dd.isSubClass(WorkspaceClipboardItem.this.getType(), ContentModel.TYPE_CONTENT) || dd.isSubClass(WorkspaceClipboardItem.this.getType(), ContentModel.TYPE_FOLDER)) {
                                        fileFolderService.copy(WorkspaceClipboardItem.this.getNodeRef(), destRef, currentName);
                                    } else if (dd.isSubClass(WorkspaceClipboardItem.this.getType(), ContentModel.TYPE_MULTILINGUAL_CONTAINER)) {
                                        multilingualContentService.copyTranslationContainer(WorkspaceClipboardItem.this.getNodeRef(), destRef, currentTranslationPrefix);
                                    } else if (!WorkspaceClipboardItem.this.checkExists(currentName, destRef)) {
                                        copyService.copyAndRename(WorkspaceClipboardItem.this.getNodeRef(), destRef, ContentModel.ASSOC_CONTAINS, assocRef.getQName(), true);
                                    }
                                }
                            } else {
                                if (AbstractClipboardItem.logger.isDebugEnabled()) {
                                    AbstractClipboardItem.logger.debug((Object)("Attempting to move node: " + WorkspaceClipboardItem.this.getNodeRef() + " into node ID: " + destRef.toString()));
                                }
                                if (dd.isSubClass(WorkspaceClipboardItem.this.getType(), ContentModel.TYPE_CONTENT) || dd.isSubClass(WorkspaceClipboardItem.this.getType(), ContentModel.TYPE_FOLDER)) {
                                    fileFolderService.moveFrom(WorkspaceClipboardItem.this.getNodeRef(), WorkspaceClipboardItem.this.getParent(), destRef, currentName);
                                } else if (dd.isSubClass(WorkspaceClipboardItem.this.getType(), ContentModel.TYPE_MULTILINGUAL_CONTAINER)) {
                                    multilingualContentService.moveTranslationContainer(WorkspaceClipboardItem.this.getNodeRef(), destRef);
                                } else if (isPrimaryParent) {
                                    nodeService.moveNode(WorkspaceClipboardItem.this.getNodeRef(), destRef, ContentModel.ASSOC_CONTAINS, assocRef.getQName());
                                } else {
                                    nodeService.removeChild(WorkspaceClipboardItem.this.getParent(), WorkspaceClipboardItem.this.getNodeRef());
                                    nodeService.addChild(destRef, WorkspaceClipboardItem.this.getNodeRef(), assocRef.getTypeQName(), assocRef.getQName());
                                }
                            }
                            return null;
                        }
                    });
                }
                catch (FileExistsException fileExistsErr) {
                    if (this.getMode() == ClipboardStatus.COPY) {
                        String copyOf = Application.getMessage(fc, "copy_of");
                        name = copyOf + ' ' + name;
                        translationPrefix = copyOf + ' ' + translationPrefix;
                        continue;
                    }
                    throw fileExistsErr;
                }
                break;
            }
            return true;
        }
        if (AVM_PASTE_VIEW_ID.equals(viewId)) {
            AVMBrowseBean avmBrowseBean = (AVMBrowseBean)FacesHelper.getManagedBean(fc, "AVMBrowseBean");
            final String destPath = avmBrowseBean.getCurrentPath();
            final NodeRef destRef = AVMNodeConverter.ToNodeRef((int)-1, (String)destPath);
            final CrossRepositoryCopyService crossRepoCopyService = this.getServiceRegistry().getCrossRepositoryCopyService();
            String name = this.getName();
            while (true) {
                try {
                    final String currentName = name;
                    retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                        public Void execute() throws Throwable {
                            if (WorkspaceClipboardItem.this.getMode() == ClipboardStatus.COPY) {
                                if (AbstractClipboardItem.logger.isDebugEnabled()) {
                                    AbstractClipboardItem.logger.debug((Object)("Attempting to copy node: " + WorkspaceClipboardItem.this.getNodeRef() + " into node ID: " + destRef.toString()));
                                }
                                crossRepoCopyService.copy(WorkspaceClipboardItem.this.getNodeRef(), destRef, currentName);
                                if (destRef.getStoreRef().getProtocol().equals("avm")) {
                                    AVMNodeDescriptor desc = WorkspaceClipboardItem.this.getAvmService().lookup(-1, destPath + "/" + currentName);
                                    WorkspaceClipboardItem.this.recursiveFormCheck(desc);
                                }
                            } else {
                                throw new Exception("Move operation not supported between stores.");
                            }
                            return null;
                        }
                    });
                }
                catch (FileExistsException fileExistsErr) {
                    if (this.getMode() == ClipboardStatus.COPY) {
                        String copyOf = Application.getMessage(fc, "copy_of");
                        name = copyOf + ' ' + name;
                        continue;
                    }
                    throw fileExistsErr;
                }
                break;
            }
            return true;
        }
        return false;
    }
}

