/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.coci;

import javax.faces.context.FacesContext;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.coci.CheckinCheckoutDialog;
import org.alfresco.web.bean.repository.Node;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CCCheckoutFileLinkDialog
extends CheckinCheckoutDialog {
    private static final long serialVersionUID = -4732775752517417543L;
    public static final String MSG_CHECKOUT_OF = "check_out_of";
    public static final String LBL_UNDO_CHECKOUT = "undo_checkout";
    private static final String MSG_LEFT_QUOTE = "left_qoute";
    private static final String MSG_RIGHT_QUOTE = "right_quote";
    private static Log logger = LogFactory.getLog(CCCheckoutFileLinkDialog.class);

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        return this.checkoutFileOK(context, outcome);
    }

    @Override
    public boolean getFinishButtonDisabled() {
        return false;
    }

    @Override
    public String getContainerTitle() {
        FacesContext fc = FacesContext.getCurrentInstance();
        return Application.getMessage(fc, MSG_CHECKOUT_OF) + " " + Application.getMessage(fc, MSG_LEFT_QUOTE) + this.property.getDocument().getName() + Application.getMessage(fc, MSG_RIGHT_QUOTE);
    }

    @Override
    public String getCancelButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), LBL_UNDO_CHECKOUT);
    }

    @Override
    public String getFinishButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), "ok");
    }

    @Override
    public String cancel() {
        this.undoCheckout();
        this.resetState();
        super.cancel();
        return "browse";
    }

    public String checkoutFileOK(FacesContext context, String outcome) {
        Node node = this.property.getWorkingDocument();
        if (node != null) {
            if (this.browseBean.getDocument() != null) {
                this.browseBean.getDocument().reset();
            }
            this.resetState();
            this.property.setDocument(null);
            this.property.setWorkingDocument(null);
            outcome = "dialog:close:browse";
        } else {
            logger.warn((Object)"WARNING: checkoutFileOK called without a current WorkingDocument!");
        }
        return outcome;
    }
}

