/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.coci;

import java.util.StringTokenizer;
import javax.faces.application.NavigationHandler;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.coci.CheckinCheckoutDialog;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.ui.common.Utils;

public class DoneEditingDialog
extends CheckinCheckoutDialog {
    private static final String MSG_OK = "ok";
    private static final String MSG_DONE_EDITING = "done_editing";
    private static final String MSG_MISSING_ORIGINAL_NODE = "missing_original_node";
    private static final String MSG_LEFT_QUOTE = "left_qoute";
    private static final String MSG_RIGHT_QUOTE = "right_quote";
    private static final String DIALOG_NAME = "dialog:doneEditingFile";
    private boolean sourceVersionable;
    private NodeRef sourceNodeRef;

    public String getMajorNewVersionLabel() {
        String label = this.getCurrentVersionLabel();
        StringTokenizer st = new StringTokenizer(label, ".");
        return Integer.valueOf(st.nextToken()) + 1 + ".0";
    }

    public String getMinorNewVersionLabel() {
        String label = this.getCurrentVersionLabel();
        StringTokenizer st = new StringTokenizer(label, ".");
        return st.nextToken() + "." + (Integer.valueOf(st.nextToken()) + 1);
    }

    public boolean isSourceVersionable() {
        return this.sourceVersionable;
    }

    public boolean isSourceFound() {
        return this.sourceNodeRef != null;
    }

    public void handle(ActionEvent event) {
        this.setupContentAction(event);
        FacesContext fc = FacesContext.getCurrentInstance();
        NavigationHandler nh = fc.getApplication().getNavigationHandler();
        if (this.isVersionable()) {
            nh.handleNavigation(fc, null, DIALOG_NAME);
        } else {
            this.checkinFileOK(fc, null);
            nh.handleNavigation(fc, null, "dialog:browse");
        }
    }

    @Override
    public void setupContentAction(ActionEvent event) {
        super.setupContentAction(event);
        Node node = this.property.getDocument();
        if (node != null) {
            this.sourceNodeRef = this.getSourceNodeRef(node.getNodeRef());
            if (this.sourceNodeRef != null) {
                this.sourceVersionable = this.getNodeService().hasAspect(this.sourceNodeRef, ContentModel.ASPECT_VERSIONABLE);
            }
        }
    }

    @Override
    public String getFinishButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), MSG_OK);
    }

    @Override
    public boolean getFinishButtonDisabled() {
        return !this.isSourceFound();
    }

    @Override
    public String getContainerTitle() {
        if (this.isSourceFound()) {
            FacesContext fc = FacesContext.getCurrentInstance();
            return Application.getMessage(fc, MSG_DONE_EDITING) + " " + Application.getMessage(fc, MSG_LEFT_QUOTE) + this.getNodeService().getProperty(this.sourceNodeRef, ContentModel.PROP_NAME) + Application.getMessage(fc, MSG_RIGHT_QUOTE);
        }
        String message = Application.getMessage(FacesContext.getCurrentInstance(), MSG_MISSING_ORIGINAL_NODE);
        Utils.addErrorMessage(message);
        return message;
    }

    @Override
    public void resetState() {
        super.resetState();
        this.sourceVersionable = false;
        this.sourceNodeRef = null;
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        return this.checkinFileOK(context, outcome);
    }

    private String getCurrentVersionLabel() {
        if (this.isSourceFound()) {
            Version curVersion = this.property.getVersionQueryService().getCurrentVersion(this.sourceNodeRef);
            return curVersion.getVersionLabel();
        }
        return null;
    }

    private NodeRef getSourceNodeRef(NodeRef workingCopyNodeRef) {
        return this.getCheckOutCheckInService().getCheckedOut(workingCopyNodeRef);
    }
}

