/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.coci;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.transaction.UserTransaction;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.web.scripts.FileTypeImageUtils;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.DownloadContentServlet;
import org.alfresco.web.bean.coci.CheckinCheckoutDialog;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.users.UserPreferencesBean;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.UIActionLink;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EditOfflineDialog
extends CheckinCheckoutDialog {
    private static final long serialVersionUID = -4848508258494238150L;
    public static final String OFFLINE_EDITING = "offlineEditing";
    public static final String CLOSE = "close";
    public static final String MSG_ERROR_CHECKOUT = "error_checkout";
    public static final String OFFLINE_TITLE = "offline_title";
    private static Log logger = LogFactory.getLog(EditOfflineDialog.class);
    private boolean continueCountdown;
    protected UserPreferencesBean userPreferencesBean;

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.continueCountdown = true;
    }

    @Override
    public void restored() {
        super.restored();
        this.continueCountdown = false;
    }

    @Override
    public String getContainerTitle() {
        FacesContext fc = FacesContext.getCurrentInstance();
        String pattern = Application.getMessage(fc, OFFLINE_TITLE);
        return MessageFormat.format(pattern, this.property.getDocument().getName());
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        return outcome;
    }

    @Override
    public String getCancelButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), CLOSE);
    }

    @Override
    public void setupContentAction(ActionEvent event) {
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String id = params.get("id");
        if (id != null && id.length() != 0) {
            super.setupContentDocument(id);
            this.checkoutFile(this.property.getDocument());
            if (this.userPreferencesBean.isDownloadAutomatically()) {
                FacesContext fc = FacesContext.getCurrentInstance();
                this.navigator.setupDispatchContext(this.property.getDocument());
                fc.getApplication().getNavigationHandler().handleNavigation(fc, null, "dialog:editOfflineDialog");
            } else {
                FacesContext fc = FacesContext.getCurrentInstance();
                fc.getApplication().getNavigationHandler().handleNavigation(fc, null, "dialog:close:browse");
            }
        } else {
            this.property.setDocument(null);
        }
        super.resetState();
    }

    private void checkoutFile(Node node) {
        UserTransaction tx = null;
        FacesContext context = FacesContext.getCurrentInstance();
        if (node != null) {
            try {
                tx = Repository.getUserTransaction(context, false);
                tx.begin();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Trying to checkout content node Id: " + node.getId()));
                }
                NodeRef workingCopyRef = null;
                workingCopyRef = this.property.getVersionOperationsService().checkout(node.getNodeRef());
                this.getNodeService().setProperty(workingCopyRef, ContentModel.PROP_WORKING_COPY_MODE, (Serializable)((Object)OFFLINE_EDITING));
                Node workingCopy = new Node(workingCopyRef);
                this.property.setWorkingDocument(workingCopy);
                String url = DownloadContentServlet.generateDownloadURL(workingCopyRef, workingCopy.getName());
                workingCopy.getProperties().put("url", url);
                workingCopy.getProperties().put("fileType32", FileTypeImageUtils.getFileTypeImage((String)workingCopy.getName(), (boolean)false));
                tx.commit();
            }
            catch (Throwable err) {
                try {
                    if (tx != null) {
                        tx.rollback();
                    }
                }
                catch (Exception tex) {
                    // empty catch block
                }
                Utils.addErrorMessage(Application.getMessage(FacesContext.getCurrentInstance(), MSG_ERROR_CHECKOUT) + err.getMessage(), err);
            }
        } else {
            logger.warn((Object)"WARNING: checkoutFile called without a current Document!");
        }
    }

    @Override
    public String cancel() {
        super.cancel();
        return "dialog:close:browse";
    }

    public UserPreferencesBean getUserPreferencesBean() {
        return this.userPreferencesBean;
    }

    public void setUserPreferencesBean(UserPreferencesBean userPreferencesBean) {
        this.userPreferencesBean = userPreferencesBean;
    }

    public boolean isContinueCountdown() {
        return this.continueCountdown;
    }

    public void setContinueCountdown(boolean continueCountdown) {
        this.continueCountdown = continueCountdown;
    }
}

