/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.coci;

import java.io.Serializable;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.transaction.UserTransaction;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.web.bean.coci.CCCheckoutFileDialog;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.ui.common.component.UIActionLink;
import org.springframework.extensions.webscripts.ui.common.StringUtils;

public class EditOnlineDialog
extends CCCheckoutFileDialog {
    public static final String ONLINE_EDITING = "onlineEditing";

    public void handleWebdavEditing(ActionEvent event) {
        this.handle(event);
        Node workingCopyNode = this.property.getDocument();
        if (workingCopyNode != null) {
            UIActionLink link = (UIActionLink)event.getComponent();
            Map<String, String> params = link.getParameterMap();
            String webdavUrl = params.get("webdavUrl");
            if (webdavUrl != null) {
                this.property.setWebdavUrl(webdavUrl.substring(0, webdavUrl.lastIndexOf(47) + 1) + workingCopyNode.getName());
            }
            FacesContext fc = FacesContext.getCurrentInstance();
            fc.getApplication().getNavigationHandler().handleNavigation(fc, null, "dialog:close:browse");
        }
    }

    public void handleCifsEditing(ActionEvent event) {
        this.handle(event);
        Node workingCopyNode = this.property.getDocument();
        if (workingCopyNode != null) {
            UIActionLink link = (UIActionLink)event.getComponent();
            Map<String, String> params = link.getParameterMap();
            String cifsPath = params.get("cifsPath");
            if (cifsPath != null) {
                this.property.setCifsPath(cifsPath.substring(0, cifsPath.lastIndexOf(92) + 1) + workingCopyNode.getName());
            }
            FacesContext fc = FacesContext.getCurrentInstance();
            fc.getApplication().getNavigationHandler().handleNavigation(fc, null, "dialog:close:browse");
        }
    }

    public void handleHttpEditing(ActionEvent event) {
        ContentReader reader;
        this.handle(event);
        Node workingCopyNode = this.property.getDocument();
        if (workingCopyNode != null && (reader = this.property.getContentService().getReader(workingCopyNode.getNodeRef(), ContentModel.PROP_CONTENT)) != null) {
            String mimetype = reader.getMimetype();
            if ("text/plain".equals(mimetype) || "text/xml".equals(mimetype) || "text/css".equals(mimetype) || "application/x-javascript".equals(mimetype)) {
                this.property.setEditorOutput(reader.getContentString());
                FacesContext fc = FacesContext.getCurrentInstance();
                fc.getApplication().getNavigationHandler().handleNavigation(fc, null, "dialog:close:browse");
                this.navigator.setupDispatchContext(workingCopyNode);
                fc.getApplication().getNavigationHandler().handleNavigation(fc, null, "dialog:editTextInline");
            } else {
                this.property.setDocumentContent(StringUtils.stripUnsafeHTMLTags((String)reader.getContentString(), (boolean)false));
                this.property.setEditorOutput(null);
                FacesContext fc = FacesContext.getCurrentInstance();
                fc.getApplication().getNavigationHandler().handleNavigation(fc, null, "dialog:close:browse");
                this.navigator.setupDispatchContext(workingCopyNode);
                fc.getApplication().getNavigationHandler().handleNavigation(fc, null, "dialog:editHtmlInline");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(ActionEvent event) {
        super.setupContentAction(event);
        Node node = this.property.getDocument();
        if (node != null) {
            UserTransaction tx = null;
            FacesContext context = FacesContext.getCurrentInstance();
            try {
                tx = Repository.getUserTransaction(context, false);
                tx.begin();
                if (!node.hasAspect(ContentModel.ASPECT_WORKING_COPY)) {
                    this.checkoutFile(FacesContext.getCurrentInstance(), null);
                    Node workingCopyNode = this.property.getWorkingDocument();
                    if (workingCopyNode != null) {
                        this.getRuleService().disableRules();
                        try {
                            this.property.setDocument(workingCopyNode);
                            this.getNodeService().setProperty(workingCopyNode.getNodeRef(), ContentModel.PROP_WORKING_COPY_MODE, (Serializable)((Object)ONLINE_EDITING));
                        }
                        finally {
                            this.getRuleService().enableRules();
                        }
                    }
                }
                tx.commit();
            }
            catch (Throwable err) {
                try {
                    if (tx != null) {
                        tx.rollback();
                    }
                }
                catch (Exception tex) {
                    // empty catch block
                }
                this.property.setDocument(null);
            }
        }
    }
}

