/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.content;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.FileUploadBean;
import org.alfresco.web.bean.content.BaseContentWizard;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.ui.common.Utils;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigService;

public class AddContentDialog
extends BaseContentWizard {
    private static final String MSG_OK = "ok";
    private static final long serialVersionUID = 3593557546118692687L;
    protected List<String> inlineEditableMimeTypes;
    protected File file;

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        List<String> mimeTypes;
        FileContentReader cr = new FileContentReader(this.file);
        cr.setMimetype(this.mimeType);
        cr.setEncoding(this.encoding);
        HashMap<QName, Serializable> contentProps = new HashMap<QName, Serializable>(5, 1.0f);
        if (Repository.extractMetadata(FacesContext.getCurrentInstance(), (ContentReader)cr, contentProps)) {
            this.author = (String)contentProps.get(ContentModel.PROP_AUTHOR);
            this.title = (String)DefaultTypeConverter.INSTANCE.convert(String.class, contentProps.get(ContentModel.PROP_TITLE));
            this.description = (String)DefaultTypeConverter.INSTANCE.convert(String.class, contentProps.get(ContentModel.PROP_DESCRIPTION));
        }
        if (this.title == null) {
            this.title = this.fileName;
        }
        if ((mimeTypes = this.getInlineEditableMimeTypes()).contains(this.mimeType)) {
            this.inlineEdit = true;
        }
        this.saveContent(this.file, null);
        return outcome;
    }

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.clearUpload();
    }

    @Override
    protected String doPostCommitProcessing(FacesContext context, String outcome) {
        this.clearUpload();
        if (this.showOtherProperties) {
            if (this.getNodeService().hasAspect(this.createdNode, ContentModel.ASPECT_LOCKABLE)) {
                Utils.addErrorMessage(Application.getMessage(FacesContext.getCurrentInstance(), "node_locked_dialog_closed"));
                return outcome;
            }
            this.browseBean.setDocument(new Node(this.createdNode));
            return "dialog:setContentProperties";
        }
        return outcome;
    }

    @Override
    protected String getDefaultFinishOutcome() {
        return "dialog:close:browse";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFileUploadSuccessMsg() {
        FacesContext fc = FacesContext.getCurrentInstance();
        this.mimeType = Repository.getMimeTypeForFile(fc, this.fileName, this.file);
        this.encoding = "UTF-8";
        InputStream is = null;
        try {
            if (this.file != null) {
                is = new BufferedInputStream(new FileInputStream(this.file));
                this.encoding = Repository.guessEncoding(fc, is, this.mimeType);
            }
        }
        catch (Throwable e) {
            logger.error((Object)("Failed to get encoding from file: " + this.fileName), e);
        }
        finally {
            try {
                is.close();
            }
            catch (Throwable e) {}
        }
        this.inlineEdit = this.mimeType.equals("text/html");
        String msg = Application.getMessage(FacesContext.getCurrentInstance(), "file_upload_success");
        return MessageFormat.format(msg, Utils.encode((String)this.getFileName()));
    }

    @Override
    public String getFileName() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        FileUploadBean fileBean = (FileUploadBean)ctx.getExternalContext().getSessionMap().get("alfresco.UploadBean");
        if (fileBean != null) {
            this.file = fileBean.getFile();
            this.fileName = fileBean.getFileName();
        }
        return this.fileName;
    }

    @Override
    public void setFileName(String fileName) {
        this.fileName = fileName;
        FacesContext ctx = FacesContext.getCurrentInstance();
        FileUploadBean fileBean = (FileUploadBean)ctx.getExternalContext().getSessionMap().get("alfresco.UploadBean");
        if (fileBean != null) {
            fileBean.setFileName(this.fileName);
        }
    }

    public void start(ActionEvent event) {
        this.init(null);
    }

    public String removeUploadedFile() {
        this.clearUpload();
        this.fileName = null;
        return null;
    }

    @Override
    public String cancel() {
        this.clearUpload();
        return "dialog:close";
    }

    protected void clearUpload() {
        if (this.file != null) {
            this.file.delete();
        }
        this.file = null;
        FacesContext ctx = FacesContext.getCurrentInstance();
        ctx.getExternalContext().getSessionMap().remove("alfresco.UploadBean");
    }

    protected List<String> getInlineEditableMimeTypes() {
        if (this.inlineEditableMimeTypes == null || Application.isDynamicConfig(FacesContext.getCurrentInstance())) {
            ConfigElement typesCfg;
            this.inlineEditableMimeTypes = new ArrayList<String>(8);
            ConfigService svc = Application.getConfigService(FacesContext.getCurrentInstance());
            Config wizardCfg = svc.getConfig((Object)"Content Wizards");
            if (wizardCfg != null && (typesCfg = wizardCfg.getConfigElement("create-mime-types")) != null) {
                for (ConfigElement child : typesCfg.getChildren()) {
                    String currentMimeType = child.getAttribute("name");
                    this.inlineEditableMimeTypes.add(currentMimeType);
                }
            }
        }
        return this.inlineEditableMimeTypes;
    }

    @Override
    public String getFinishButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), MSG_OK);
    }

    @Override
    protected String formatErrorMessage(Throwable exception) {
        if (exception instanceof FileExistsException) {
            return MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_exists"), ((FileExistsException)exception).getName());
        }
        return MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_content"), exception.getMessage());
    }
}

