/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.content;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wizard.BaseWizardBean;
import org.alfresco.web.data.QuickSort;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.repo.component.UICharsetSelector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigService;

public abstract class BaseContentWizard
extends BaseWizardBean {
    protected String fileName;
    protected String author;
    protected String title;
    protected String description;
    protected String mimeType;
    protected String encoding;
    protected String objectType;
    protected boolean inlineEdit;
    protected boolean otherPropertiesChoiceVisible = true;
    protected boolean showOtherProperties = true;
    protected NodeRef createdNode;
    protected List<SelectItem> objectTypes;
    private transient ContentService contentService;
    protected static final String MSG_NODE_LOCKED = "node_locked_dialog_closed";
    protected static Log logger = LogFactory.getLog(BaseContentWizard.class);

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.fileName = null;
        this.author = null;
        this.title = null;
        this.description = null;
        this.mimeType = null;
        this.inlineEdit = false;
        this.objectType = null;
        this.initOtherProperties();
    }

    @Override
    public boolean getFinishButtonDisabled() {
        return this.fileName == null || this.fileName.length() == 0 || this.mimeType == null;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getEncoding() {
        if (this.encoding == null) {
            String value;
            ConfigElement defaultEncCfg;
            ConfigService configSvc = Application.getConfigService(FacesContext.getCurrentInstance());
            Config config = configSvc.getConfig((Object)"Content Wizards");
            if (config != null && (defaultEncCfg = config.getConfigElement("default-encoding")) != null && (value = defaultEncCfg.getValue()) != null) {
                this.encoding = value.trim();
            }
            if (this.encoding == null || this.encoding.length() == 0) {
                this.encoding = "UTF-8";
            }
        }
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isInlineEdit() {
        return this.inlineEdit;
    }

    public void setInlineEdit(boolean inlineEdit) {
        this.inlineEdit = inlineEdit;
    }

    public boolean getOtherPropertiesChoiceVisible() {
        return this.otherPropertiesChoiceVisible;
    }

    public boolean getShowOtherProperties() {
        return this.showOtherProperties;
    }

    public void setShowOtherProperties(boolean showOthers) {
        this.showOtherProperties = showOthers;
    }

    public List<SelectItem> getEncodings() {
        return UICharsetSelector.getCharsetEncodingList();
    }

    public List<SelectItem> getObjectTypes() {
        if (this.objectTypes == null || Application.isDynamicConfig(FacesContext.getCurrentInstance())) {
            FacesContext context = FacesContext.getCurrentInstance();
            this.objectTypes = new ArrayList<SelectItem>(5);
            ConfigService svc = Application.getConfigService(FacesContext.getCurrentInstance());
            Config wizardCfg = svc.getConfig((Object)"Content Wizards");
            if (wizardCfg != null) {
                ConfigElement defaultTypesCfg = wizardCfg.getConfigElement("default-content-type");
                String parentLabel = "";
                if (defaultTypesCfg != null) {
                    ConfigElement typesCfg;
                    ConfigElement typeElement = (ConfigElement)defaultTypesCfg.getChildren().get(0);
                    QName parentQName = Repository.resolveToQName(typeElement.getAttribute("name"));
                    TypeDefinition parentType = null;
                    if (parentQName != null) {
                        parentType = this.getDictionaryService().getType(parentQName);
                        if (parentType == null) {
                            parentQName = ContentModel.TYPE_CONTENT;
                            parentType = this.getDictionaryService().getType(ContentModel.TYPE_CONTENT);
                            this.objectTypes.add(new SelectItem((Object)ContentModel.TYPE_CONTENT.toString(), Application.getMessage(context, "content")));
                            logger.warn((Object)("Configured default content type not found in dictionary: " + parentQName));
                        } else {
                            parentLabel = Utils.getDisplayLabel(context, typeElement);
                            if (parentLabel == null) {
                                parentLabel = parentType.getTitle();
                            }
                            if (parentLabel == null) {
                                parentLabel = parentQName.getLocalName();
                            }
                        }
                    }
                    if ((typesCfg = wizardCfg.getConfigElement("content-types")) != null) {
                        for (ConfigElement child : typesCfg.getChildren()) {
                            QName idQName = Repository.resolveToQName(child.getAttribute("name"));
                            if (idQName != null) {
                                TypeDefinition typeDef = this.getDictionaryService().getType(idQName);
                                if (typeDef == null) continue;
                                if (this.getDictionaryService().isSubClass(typeDef.getName(), parentType.getName())) {
                                    String label = Utils.getDisplayLabel(context, child);
                                    if (label == null) {
                                        label = typeDef.getTitle();
                                    }
                                    if (label == null) {
                                        label = idQName.getLocalName();
                                    }
                                    this.objectTypes.add(new SelectItem((Object)idQName.toString(), label));
                                    continue;
                                }
                                logger.warn((Object)("Failed to add '" + child.getAttribute("name") + "' to the list of content types - it is not a subtype of " + parentQName));
                                continue;
                            }
                            logger.warn((Object)("Failed to add '" + child.getAttribute("name") + "' to the list of content types as the type is not recognised"));
                        }
                    }
                    if (this.objectTypes.isEmpty()) {
                        this.objectTypes.add(new SelectItem((Object)parentQName.toString(), parentLabel));
                    }
                    QuickSort sorter = new QuickSort(this.objectTypes, "label", true, "case-insensitive");
                    sorter.sort();
                } else {
                    logger.warn((Object)"Could not find 'content-types' configuration element");
                }
            } else {
                logger.warn((Object)"Could not find 'Content Wizards' configuration section");
            }
        }
        return this.objectTypes;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    protected ContentService getContentService() {
        if (this.contentService == null) {
            this.contentService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getContentService();
        }
        return this.contentService;
    }

    protected void saveContent(File fileContent, String strContent) throws Exception {
        String nodeId = this.navigator.getCurrentNodeId();
        NodeRef containerNodeRef = nodeId == null ? this.getNodeService().getRootNode(Repository.getStoreRef()) : new NodeRef(Repository.getStoreRef(), nodeId);
        HashMap<QName, Object> editProps = new HashMap<QName, Object>(6);
        if (this.inlineEdit) {
            editProps.put(ApplicationModel.PROP_EDITINLINE, this.inlineEdit);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Added inlineeditable aspect with properties: " + editProps));
            }
        }
        editProps.put(ContentModel.PROP_NAME, this.fileName);
        editProps.put(ContentModel.PROP_AUTHOR, this.author);
        editProps.put(ContentModel.PROP_TITLE, this.title);
        editProps.put(ContentModel.PROP_DESCRIPTION, this.description);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Added titled aspect with properties: " + this.title + ", " + this.description));
        }
        NodeRef fileNodeRef = this.getNodeService().createNode(containerNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQNameWithValidLocalName((String)"http://www.alfresco.org/model/content/1.0", (String)this.fileName), Repository.resolveToQName(this.objectType), editProps).getChildRef();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Created file node for file: " + this.fileName));
        }
        ContentWriter writer = this.getContentService().getWriter(fileNodeRef, ContentModel.PROP_CONTENT, true);
        writer.setMimetype(this.mimeType);
        writer.setEncoding(this.getEncoding());
        if (fileContent != null) {
            writer.putContent(fileContent);
        } else {
            writer.putContent(strContent == null ? "" : strContent);
        }
        this.createdNode = fileNodeRef;
    }

    protected String getSummaryMimeType(String mimeType) {
        ServiceRegistry registry = Repository.getServiceRegistry(FacesContext.getCurrentInstance());
        MimetypeService mimetypeService = registry.getMimetypeService();
        Map mimeTypes = mimetypeService.getDisplaysByMimetype();
        return (String)mimeTypes.get(mimeType);
    }

    protected String getSummaryObjectType() {
        String objType = null;
        for (SelectItem item : this.getObjectTypes()) {
            if (!item.getValue().equals(this.objectType)) continue;
            objType = item.getLabel();
            break;
        }
        return objType;
    }

    protected void initOtherProperties() {
        ConfigElement otherPropsCfg;
        Config config;
        ConfigService configSvc = Application.getConfigService(FacesContext.getCurrentInstance());
        if (configSvc != null && (config = configSvc.getConfig((Object)"Content Wizards")) != null && (otherPropsCfg = config.getConfigElement("other-properties")) != null) {
            String userChoiceVisible = otherPropsCfg.getAttribute("user-choice-visible");
            String userChoiceDefault = otherPropsCfg.getAttribute("user-choice-default");
            if (userChoiceVisible != null) {
                this.otherPropertiesChoiceVisible = Boolean.parseBoolean(userChoiceVisible);
            }
            if (userChoiceDefault != null) {
                this.showOtherProperties = Boolean.parseBoolean(userChoiceDefault);
            }
        }
    }
}

