/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.content;

import java.text.MessageFormat;
import javax.faces.context.FacesContext;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.content.DeleteContentDialog;
import org.alfresco.web.bean.repository.Node;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeleteContentAssociationDialog
extends DeleteContentDialog {
    private static final Log logger = LogFactory.getLog(DeleteContentAssociationDialog.class);

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        Node node = this.browseBean.getDocument();
        if (node != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Trying to delete content node association: " + node.getId()));
            }
            NodeRef parentRef = this.navigator.getCurrentNode().getNodeRef();
            QName qname = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)node.getName()));
            ChildAssociationRef childAssocRef = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, parentRef, qname, node.getNodeRef());
            this.getNodeService().removeChildAssociation(childAssocRef);
        } else {
            logger.warn((Object)"WARNING: delete called without a current Document!");
        }
        return outcome;
    }

    @Override
    public String getConfirmMessage() {
        String fileConfirmMsg = null;
        Node document = this.browseBean.getDocument();
        fileConfirmMsg = Application.getMessage(FacesContext.getCurrentInstance(), "delete_file_assoc_confirm");
        return MessageFormat.format(fileConfirmMsg, document.getName());
    }
}

