/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.content;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.ml.ContentFilterLanguagesService;
import org.alfresco.service.cmr.ml.EditionService;
import org.alfresco.service.cmr.ml.MultilingualContentService;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.DownloadContentServlet;
import org.alfresco.web.bean.BaseDetailsBean;
import org.alfresco.web.bean.dialog.NavigationSupport;
import org.alfresco.web.bean.ml.SingleEditionBean;
import org.alfresco.web.bean.repository.MapNode;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.ui.common.ReportedException;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.UIActionLink;

public class DocumentDetailsDialog
extends BaseDetailsBean
implements NavigationSupport {
    private static final long serialVersionUID = -8579599071702546214L;
    private static final String OUTCOME_RETURN = null;
    private static final String MSG_HAS_FOLLOWING_CATEGORIES = "has_following_categories";
    private static final String MSG_NO_CATEGORIES_APPLIED = "no_categories_applied";
    private static final String MSG_SUCCESS_UNLOCK = "success_unlock";
    private static final String MSG_CURRENT = "current";
    private static final String MSG_ERROR_ASPECT_INLINEEDITABLE = "error_aspect_inlineeditable";
    private static final String MSG_ERROR_ASPECT_VERSIONING = "error_aspect_versioning";
    private static final String MSG_ERROR_ASPECT_CLASSIFY = "error_aspect_classify";
    private static final String MSG_DETAILS_OF = "details_of";
    private static final String MSG_LOCATION = "location";
    private static final String MSG_LEFT_QUOTE = "left_qoute";
    private static final String MSG_RIGHT_QUOTE = "right_quote";
    private static final String MSG_CLOSE = "close";
    private static final String ML_VERSION_PANEL_ID = "ml-versions-panel";
    private static final String DOC_DETAILS_STACK = "_alfDocDetailsStack";
    protected transient LockService lockService;
    protected transient VersionService versionService;
    protected transient CheckOutCheckInService cociService;
    protected transient MultilingualContentService multilingualContentService;
    protected transient ContentFilterLanguagesService contentFilterLanguagesService;
    protected transient EditionService editionService;
    private Node translationDocument;
    private List<SingleEditionBean> editionHistory = null;
    private int currentEditionCursorPosition;

    public DocumentDetailsDialog() {
        this.panels.put("version-history-panel", false);
        this.panels.put("ml-info-panel", false);
        this.panels.put("related-translation-panel", false);
    }

    public void reset() {
        this.workflowProperties = null;
    }

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        Stack stack = this.getRecentNodeRefsStack();
        stack.push(this.getNode().getNodeRef().getId());
    }

    @Override
    public void restored() {
        super.restored();
        Stack stack = this.getRecentNodeRefsStack();
        if (!stack.isEmpty()) {
            this.browseBean.setupContentAction((String)stack.peek(), true);
        }
    }

    @Override
    public String cancel() {
        Stack stack = this.getRecentNodeRefsStack();
        if (!stack.isEmpty()) {
            stack.pop();
        }
        return super.cancel();
    }

    private Stack getRecentNodeRefsStack() {
        FacesContext fc = FacesContext.getCurrentInstance();
        Stack stack = (Stack)fc.getExternalContext().getSessionMap().get(DOC_DETAILS_STACK);
        if (stack == null) {
            stack = new Stack();
            fc.getExternalContext().getSessionMap().put(DOC_DETAILS_STACK, stack);
        }
        return stack;
    }

    public String getUrl() {
        return (String)this.getDocument().getProperties().get("url");
    }

    public Node getTranslationDocument() {
        return this.translationDocument;
    }

    public void setTranslationDocument(Node node) {
        this.translationDocument = node;
    }

    public String getBrowserUrl() {
        Node doc = this.getLinkResolvedNode();
        return Utils.generateURL(FacesContext.getCurrentInstance(), doc, Utils.URLMode.HTTP_INLINE);
    }

    public String getDownloadUrl() {
        Node doc = this.getLinkResolvedNode();
        return Utils.generateURL(FacesContext.getCurrentInstance(), doc, Utils.URLMode.HTTP_DOWNLOAD);
    }

    @Override
    protected Node getLinkResolvedNode() {
        Node document = this.getDocument();
        if (ApplicationModel.TYPE_FILELINK.equals((Object)document.getType())) {
            NodeRef destRef = (NodeRef)document.getProperties().get(ContentModel.PROP_LINK_DESTINATION);
            if (this.getNodeService().exists(destRef)) {
                document = new Node(destRef);
            }
        }
        return document;
    }

    public boolean isVersionable() {
        return this.getDocument().hasAspect(ContentModel.ASPECT_VERSIONABLE);
    }

    public boolean isInlineEditable() {
        return this.getDocument().hasAspect(ApplicationModel.ASPECT_INLINEEDITABLE);
    }

    public boolean isMultilingual() {
        return this.getDocument().hasAspect(ContentModel.ASPECT_MULTILINGUAL_DOCUMENT);
    }

    public String editContentProperties() {
        NodeRef nodeRef = this.getDocument().getNodeRef();
        if (this.getNodeService().exists(nodeRef)) {
            this.navigator.setupDispatchContext(this.getDocument());
            return "dialog:editContentProperties";
        }
        Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_noderef"), nodeRef));
        return "browse";
    }

    @Override
    public void expandPanel(ActionEvent event) {
        super.expandPanel(event);
        String id = event.getComponent().getId();
        if (id.startsWith(ML_VERSION_PANEL_ID)) {
            this.currentEditionCursorPosition = Integer.parseInt(id.substring(ML_VERSION_PANEL_ID.length())) - 1;
        }
    }

    public List getVersionHistory() {
        VersionHistory history;
        ArrayList<MapNode> versions = new ArrayList<MapNode>();
        if (this.getDocument().hasAspect(ContentModel.ASPECT_VERSIONABLE) && (history = this.getVersionService().getVersionHistory(this.getDocument().getNodeRef())) != null) {
            for (Version version : history.getAllVersions()) {
                MapNode clientVersion = new MapNode(version.getFrozenStateNodeRef());
                clientVersion.put("versionLabel", (Object)version.getVersionLabel());
                clientVersion.put("notes", (Object)version.getDescription());
                clientVersion.put("author", (Object)version.getCreator());
                clientVersion.put("versionDate", (Object)version.getCreatedDate());
                if (this.getDocument().hasAspect(ContentModel.ASPECT_MULTILINGUAL_EMPTY_TRANSLATION)) {
                    clientVersion.put("url", (Object)null);
                } else {
                    clientVersion.put("url", (Object)DownloadContentServlet.generateBrowserURL(version.getFrozenStateNodeRef(), clientVersion.getName()));
                }
                versions.add(clientVersion);
            }
        }
        return versions;
    }

    public SingleEditionBean getNextSingleEditionBean() {
        ++this.currentEditionCursorPosition;
        return this.getCurrentSingleEditionBean();
    }

    public SingleEditionBean getCurrentSingleEditionBean() {
        return this.editionHistory.get(this.currentEditionCursorPosition);
    }

    private List<SingleEditionBean> initEditionHistory() {
        NodeRef mlContainer = this.getDocumentMlContainer().getNodeRef();
        ArrayList orderedEditionList = new ArrayList(this.getEditionService().getEditions(mlContainer).getAllVersions());
        this.editionHistory = new ArrayList<SingleEditionBean>(orderedEditionList.size());
        boolean firstEdition = true;
        for (Version edition : orderedEditionList) {
            SingleEditionBean editionBean = new SingleEditionBean();
            MapNode clientEdition = new MapNode(edition.getFrozenStateNodeRef());
            String editionLabel = edition.getVersionLabel();
            if (firstEdition) {
                editionLabel = editionLabel + " (" + Application.getMessage(FacesContext.getCurrentInstance(), MSG_CURRENT) + ")";
            }
            clientEdition.put("editionLabel", (Object)editionLabel);
            clientEdition.put("editionNotes", (Object)edition.getDescription());
            clientEdition.put("editionAuthor", (Object)edition.getCreator());
            clientEdition.put("editionDate", (Object)edition.getCreatedDate());
            editionBean.setEdition(clientEdition);
            ArrayList<VersionHistory> translationHistories = null;
            if (firstEdition) {
                Map translations = this.getMultilingualContentService().getTranslations(mlContainer);
                translationHistories = new ArrayList<VersionHistory>(translations.size());
                for (NodeRef translation : translations.values()) {
                    translationHistories.add(this.getVersionService().getVersionHistory(translation));
                }
            } else {
                translationHistories = this.getEditionService().getVersionedTranslations(edition);
            }
            for (VersionHistory versionHistory : translationHistories) {
                ArrayList orderedVersions = new ArrayList(versionHistory.getAllVersions());
                Version lastVersion = (Version)orderedVersions.get(0);
                Map lastVersionProperties = this.getEditionService().getVersionedMetadatas(lastVersion);
                Locale language = (Locale)lastVersionProperties.get(ContentModel.PROP_LOCALE);
                MapNode clientLastVersion = new MapNode(lastVersion.getFrozenStateNodeRef());
                clientLastVersion.put("versionName", lastVersionProperties.get(ContentModel.PROP_NAME));
                clientLastVersion.put("versionDescription", (Object)this.getNodeService().getProperty(lastVersion.getFrozenStateNodeRef(), ContentModel.PROP_DESCRIPTION));
                clientLastVersion.put("versionAuthor", lastVersionProperties.get(ContentModel.PROP_AUTHOR));
                clientLastVersion.put("versionCreatedDate", lastVersionProperties.get(ContentModel.PROP_CREATED));
                clientLastVersion.put("versionModifiedDate", lastVersionProperties.get(ContentModel.PROP_MODIFIED));
                clientLastVersion.put("versionLanguage", (Object)this.getContentFilterLanguagesService().convertToNewISOCode(language.getLanguage()).toUpperCase());
                if (this.getNodeService().hasAspect(lastVersion.getFrozenStateNodeRef(), ContentModel.ASPECT_MULTILINGUAL_EMPTY_TRANSLATION)) {
                    clientLastVersion.put("versionUrl", (Object)null);
                } else {
                    clientLastVersion.put("versionUrl", (Object)DownloadContentServlet.generateBrowserURL(lastVersion.getFrozenStateNodeRef(), clientLastVersion.getName()));
                }
                editionBean.addTranslations(clientLastVersion);
            }
            this.editionHistory.add(editionBean);
            firstEdition = false;
        }
        return this.editionHistory;
    }

    public boolean isCategorised() {
        return this.getDocument().hasAspect(ContentModel.ASPECT_GEN_CLASSIFIABLE);
    }

    public String getCategoriesOverviewHTML() {
        String html = null;
        if (this.isCategorised()) {
            Collection categories = (Collection)((Object)this.getNodeService().getProperty(this.getDocument().getNodeRef(), ContentModel.PROP_CATEGORIES));
            if (categories == null || categories.size() == 0) {
                html = Application.getMessage(FacesContext.getCurrentInstance(), MSG_NO_CATEGORIES_APPLIED);
            } else {
                StringBuilder builder = new StringBuilder(Application.getMessage(FacesContext.getCurrentInstance(), MSG_HAS_FOLLOWING_CATEGORIES));
                builder.append("<ul>");
                for (NodeRef ref : categories) {
                    if (!this.getNodeService().exists(ref)) continue;
                    builder.append("<li>");
                    builder.append(Utils.encode((String)Repository.getNameForCategoryNode(this.getNodeService(), ref)));
                    builder.append("</li>");
                }
                builder.append("</ul>");
                html = builder.toString();
            }
        }
        return html;
    }

    public void applyClassifiable() {
        try {
            RetryingTransactionHelper txnHelper = Repository.getRetryingTransactionHelper(FacesContext.getCurrentInstance());
            RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                public Object execute() throws Throwable {
                    DocumentDetailsDialog.this.getNodeService().addAspect(DocumentDetailsDialog.this.getDocument().getNodeRef(), ContentModel.ASPECT_GEN_CLASSIFIABLE, null);
                    return null;
                }
            };
            txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
            this.getDocument().reset();
        }
        catch (Throwable e) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), MSG_ERROR_ASPECT_CLASSIFY), e.getMessage()), e);
            ReportedException.throwIfNecessary(e);
        }
    }

    public void applyVersionable() {
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            RetryingTransactionHelper txnHelper = Repository.getRetryingTransactionHelper(context);
            RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                public Object execute() throws Throwable {
                    DocumentDetailsDialog.this.getNodeService().addAspect(DocumentDetailsDialog.this.getDocument().getNodeRef(), ContentModel.ASPECT_VERSIONABLE, null);
                    return null;
                }
            };
            txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
            this.getDocument().reset();
            UIComponent comp = context.getViewRoot().findComponent("dialog:dialog-body:document-props");
            if (comp != null) {
                comp.getChildren().clear();
            }
        }
        catch (Throwable e) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), MSG_ERROR_ASPECT_VERSIONING), e.getMessage()), e);
            ReportedException.throwIfNecessary(e);
        }
    }

    public void unlock(final ActionEvent event) {
        final FacesContext fc = FacesContext.getCurrentInstance();
        try {
            RetryingTransactionHelper txnHelper = Repository.getRetryingTransactionHelper(FacesContext.getCurrentInstance());
            RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                public Object execute() throws Throwable {
                    DocumentDetailsDialog.this.getLockService().unlock(DocumentDetailsDialog.this.getNode().getNodeRef());
                    String msg = Application.getMessage(fc, DocumentDetailsDialog.MSG_SUCCESS_UNLOCK);
                    FacesMessage facesMsg = new FacesMessage(FacesMessage.SEVERITY_INFO, msg, msg);
                    String formId = Utils.getParentForm(fc, event.getComponent()).getClientId(fc);
                    fc.addMessage(formId + ':' + DocumentDetailsDialog.this.getPropertiesPanelId(), facesMsg);
                    DocumentDetailsDialog.this.getNode().reset();
                    return null;
                }
            };
            txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        }
        catch (Throwable e) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(fc, "error_generic"), e.getMessage()), e);
            ReportedException.throwIfNecessary(e);
        }
    }

    public String applyInlineEditable() {
        try {
            RetryingTransactionHelper txnHelper = Repository.getRetryingTransactionHelper(FacesContext.getCurrentInstance());
            RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                public Object execute() throws Throwable {
                    HashMap<QName, Boolean> props = new HashMap<QName, Boolean>(1, 1.0f);
                    String contentType = null;
                    ContentData contentData = (ContentData)DocumentDetailsDialog.this.getDocument().getProperties().get(ContentModel.PROP_CONTENT);
                    if (contentData != null) {
                        contentType = contentData.getMimetype();
                    }
                    if (contentType != null && ("text/html".equals(contentType) || "text/plain".equals(contentType) || "text/xml".equals(contentType) || "text/css".equals(contentType) || "application/x-javascript".equals(contentType))) {
                        props.put(ApplicationModel.PROP_EDITINLINE, true);
                    }
                    DocumentDetailsDialog.this.getNodeService().addAspect(DocumentDetailsDialog.this.getDocument().getNodeRef(), ApplicationModel.ASPECT_INLINEEDITABLE, props);
                    return null;
                }
            };
            txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
            this.getDocument().reset();
        }
        catch (Throwable e) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), MSG_ERROR_ASPECT_INLINEEDITABLE), e.getMessage()), e);
            ReportedException.throwIfNecessary(e);
        }
        return OUTCOME_RETURN;
    }

    @Override
    public void nextItem(ActionEvent event) {
        List<Node> nodes;
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String id = params.get("id");
        if (id != null && id.length() != 0 && (nodes = this.browseBean.getContent()).size() > 1) {
            for (int i = 0; i < nodes.size(); ++i) {
                if (!id.equals(nodes.get(i).getId())) continue;
                Node next = i != nodes.size() - 1 ? nodes.get(i + 1) : nodes.get(0);
                this.getRecentNodeRefsStack().clear();
                this.browseBean.setupContentAction(next.getId(), false);
                break;
            }
        }
    }

    @Override
    public void previousItem(ActionEvent event) {
        List<Node> nodes;
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String id = params.get("id");
        if (id != null && id.length() != 0 && (nodes = this.browseBean.getContent()).size() > 1) {
            for (int i = 0; i < nodes.size(); ++i) {
                if (!id.equals(nodes.get(i).getId())) continue;
                Node previous = i != 0 ? nodes.get(i - 1) : nodes.get(nodes.size() - 1);
                this.getRecentNodeRefsStack().clear();
                this.browseBean.setupContentAction(previous.getId(), false);
                break;
            }
        }
    }

    @Override
    protected String getPropertiesPanelId() {
        return "document-props";
    }

    @Override
    public Map getTemplateModel() {
        HashMap<String, Object> model = new HashMap<String, Object>(2, 1.0f);
        model.put("document", this.getDocument().getNodeRef());
        model.put("space", this.navigator.getCurrentNode().getNodeRef());
        model.put("imageresolver", this.imageResolver);
        return model;
    }

    public boolean isLocked() {
        return this.getDocument().isLocked();
    }

    public boolean isWorkingCopy() {
        return this.getDocument().hasAspect(ContentModel.ASPECT_WORKING_COPY);
    }

    public Node getWorkingCopyDocument() {
        NodeRef workingCopyRef;
        Node workingCopyNode = null;
        if (this.isLocked() && (workingCopyRef = this.getCheckOutCheckInService().getWorkingCopy(this.getDocument().getNodeRef())) != null && !(workingCopyNode = new Node(workingCopyRef)).hasPermission("Read")) {
            workingCopyNode = null;
        }
        return workingCopyNode;
    }

    public boolean isOwner() {
        return this.getDocument().isWorkingCopyOwner();
    }

    @Override
    public Node getNode() {
        return this.browseBean.getDocument();
    }

    public Node getDocument() {
        return this.getNode();
    }

    public Node getDocumentMlContainer() {
        Node currentNode = this.getNode();
        if (ContentModel.TYPE_MULTILINGUAL_CONTAINER.equals((Object)currentNode.getType())) {
            return currentNode;
        }
        NodeRef nodeRef = this.getNode().getNodeRef();
        return new Node(this.getMultilingualContentService().getTranslationContainer(nodeRef));
    }

    public void setLockService(LockService lockService) {
        this.lockService = lockService;
    }

    protected LockService getLockService() {
        if (this.lockService == null) {
            this.lockService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getLockService();
        }
        return this.lockService;
    }

    public void setVersionService(VersionService versionService) {
        this.versionService = versionService;
    }

    protected VersionService getVersionService() {
        if (this.versionService == null) {
            this.versionService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getVersionService();
        }
        return this.versionService;
    }

    public void setCheckOutCheckInService(CheckOutCheckInService cociService) {
        this.cociService = cociService;
    }

    @Override
    protected CheckOutCheckInService getCheckOutCheckInService() {
        if (this.cociService == null) {
            this.cociService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getCheckOutCheckInService();
        }
        return this.cociService;
    }

    public void setMultilingualContentService(MultilingualContentService multilingualContentService) {
        this.multilingualContentService = multilingualContentService;
    }

    protected MultilingualContentService getMultilingualContentService() {
        if (this.multilingualContentService == null) {
            this.multilingualContentService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getMultilingualContentService();
        }
        return this.multilingualContentService;
    }

    public void setContentFilterLanguagesService(ContentFilterLanguagesService contentFilterLanguagesService) {
        this.contentFilterLanguagesService = contentFilterLanguagesService;
    }

    protected ContentFilterLanguagesService getContentFilterLanguagesService() {
        if (this.contentFilterLanguagesService == null) {
            this.contentFilterLanguagesService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getContentFilterLanguagesService();
        }
        return this.contentFilterLanguagesService;
    }

    public void setEditionService(EditionService editionService) {
        this.editionService = editionService;
    }

    protected EditionService getEditionService() {
        if (this.editionService == null) {
            this.editionService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getEditionService();
        }
        return this.editionService;
    }

    @Override
    public String getCancelButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), MSG_CLOSE);
    }

    @Override
    public String getContainerSubTitle() {
        return Application.getMessage(FacesContext.getCurrentInstance(), MSG_LOCATION) + ": " + this.getDocument().getNodePath().toDisplayPath(this.getNodeService(), this.getPermissionService());
    }

    @Override
    public String getContainerTitle() {
        FacesContext fc = FacesContext.getCurrentInstance();
        return Application.getMessage(fc, MSG_DETAILS_OF) + " " + Application.getMessage(fc, MSG_LEFT_QUOTE) + this.getName() + Application.getMessage(fc, MSG_RIGHT_QUOTE);
    }

    @Override
    public String getCurrentItemId() {
        return this.getId();
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        return null;
    }

    @Override
    public String getOutcome() {
        return "dialog:close:dialog:showDocDetails";
    }
}

