/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.content;

import java.io.File;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.model.ContentModel;
import org.alfresco.model.WCMAppModel;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.web.bean.content.CreateContentWizard;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.forms.Form;
import org.alfresco.web.forms.FormNotFoundException;
import org.alfresco.web.ui.common.Utils;

public class EditContentWizard
extends CreateContentWizard {
    private static final long serialVersionUID = 1640754719164511019L;
    private NodeRef nodeRef;
    private Form form;

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        Node node = this.navigator.getDispatchContextNode();
        if (node == null) {
            throw new IllegalArgumentException("Edit Form wizard requires action node context.");
        }
        this.nodeRef = node.getNodeRef();
        try {
            this.formName = (String)((Object)this.getNodeService().getProperty(this.nodeRef, WCMAppModel.PROP_PARENT_FORM_NAME));
            this.form = this.formsService.getForm(this.formName);
        }
        catch (FormNotFoundException fnfe) {
            Utils.addErrorMessage(fnfe.getMessage(), fnfe);
            throw new IllegalArgumentException(fnfe);
        }
        this.content = this.getContentService().getReader(this.nodeRef, ContentModel.PROP_CONTENT).getContentString();
        this.fileName = (String)((Object)this.getNodeService().getProperty(this.nodeRef, ContentModel.PROP_NAME));
        this.mimeType = "text/xml";
    }

    @Override
    public String back() {
        return super.back();
    }

    @Override
    protected void saveContent(File fileContent, String strContent) throws Exception {
        ContentWriter writer = this.getContentService().getWriter(this.nodeRef, ContentModel.PROP_CONTENT, true);
        writer.putContent(strContent);
    }

    @Override
    protected String doPostCommitProcessing(FacesContext context, String outcome) {
        return outcome;
    }

    @Override
    public Form getForm() {
        return this.form;
    }
}

