/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.content;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.model.ApplicationModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.ui.common.ReportedException;
import org.alfresco.web.ui.common.Utils;

public class EditSimpleWorkflowDialog
extends BaseDialogBean {
    private static final long serialVersionUID = 7203447561571625990L;
    private static final String MSG_ERROR_UPDATE_SIMPLEWORKFLOW = "error_update_simpleworkflow";
    protected Map<String, Serializable> workflowProperties;

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        this.saveWorkflow();
        return outcome;
    }

    @Override
    public boolean getFinishButtonDisabled() {
        return false;
    }

    public Node getNode() {
        return this.browseBean.getDocument();
    }

    public Node getDocument() {
        return this.getNode();
    }

    public String saveWorkflow() {
        String outcome = "cancel";
        try {
            Map updateProps = this.getNodeService().getProperties(this.getNode().getNodeRef());
            updateProps.put(ApplicationModel.PROP_APPROVE_STEP, this.workflowProperties.get("approveStepName"));
            boolean approveMove = true;
            String approveAction = (String)((Object)this.workflowProperties.get("approveAction"));
            if (approveAction != null && approveAction.equals("copy")) {
                approveMove = false;
            }
            updateProps.put(ApplicationModel.PROP_APPROVE_MOVE, approveMove);
            updateProps.put(ApplicationModel.PROP_APPROVE_FOLDER, this.workflowProperties.get("approveFolder"));
            boolean requireReject = true;
            String rejectStepPresent = (String)((Object)this.workflowProperties.get("rejectStepPresent"));
            if (rejectStepPresent != null && rejectStepPresent.equals("no")) {
                requireReject = false;
            }
            if (requireReject) {
                updateProps.put(ApplicationModel.PROP_REJECT_STEP, this.workflowProperties.get("rejectStepName"));
                boolean rejectMove = true;
                String rejectAction = (String)((Object)this.workflowProperties.get("rejectAction"));
                if (rejectAction != null && rejectAction.equals("copy")) {
                    rejectMove = false;
                }
                updateProps.put(ApplicationModel.PROP_REJECT_MOVE, rejectMove);
                updateProps.put(ApplicationModel.PROP_REJECT_FOLDER, this.workflowProperties.get("rejectFolder"));
            } else {
                updateProps.put(ApplicationModel.PROP_REJECT_STEP, null);
                updateProps.put(ApplicationModel.PROP_REJECT_MOVE, null);
                updateProps.put(ApplicationModel.PROP_REJECT_FOLDER, null);
            }
            this.getNodeService().setProperties(this.getNode().getNodeRef(), updateProps);
            this.getNode().reset();
        }
        catch (Throwable e) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), MSG_ERROR_UPDATE_SIMPLEWORKFLOW), e.getMessage()), e);
            ReportedException.throwIfNecessary(e);
        }
        return outcome;
    }

    public Map<String, Serializable> getWorkflowProperties() {
        if (this.workflowProperties == null && this.getNode().hasAspect(ApplicationModel.ASPECT_SIMPLE_WORKFLOW)) {
            Map<String, Object> props = this.getNode().getProperties();
            String approveStepName = (String)props.get(ApplicationModel.PROP_APPROVE_STEP.toString());
            String rejectStepName = (String)props.get(ApplicationModel.PROP_REJECT_STEP.toString());
            Boolean approveMove = (Boolean)props.get(ApplicationModel.PROP_APPROVE_MOVE.toString());
            Boolean rejectMove = (Boolean)props.get(ApplicationModel.PROP_REJECT_MOVE.toString());
            NodeRef approveFolder = (NodeRef)props.get(ApplicationModel.PROP_APPROVE_FOLDER.toString());
            NodeRef rejectFolder = (NodeRef)props.get(ApplicationModel.PROP_REJECT_FOLDER.toString());
            this.workflowProperties = new HashMap<String, Serializable>(7);
            this.workflowProperties.put("approveStepName", (Serializable)((Object)approveStepName));
            this.workflowProperties.put("approveAction", (Serializable)((Object)(approveMove != false ? "move" : "copy")));
            this.workflowProperties.put("approveFolder", (Serializable)approveFolder);
            if (rejectStepName == null || rejectMove == null || rejectFolder == null) {
                this.workflowProperties.put("rejectStepPresent", (Serializable)((Object)"no"));
            } else {
                this.workflowProperties.put("rejectStepPresent", (Serializable)((Object)"yes"));
                this.workflowProperties.put("rejectStepName", (Serializable)((Object)rejectStepName));
                this.workflowProperties.put("rejectAction", (Serializable)((Object)(rejectMove != false ? "move" : "copy")));
                this.workflowProperties.put("rejectFolder", (Serializable)rejectFolder);
            }
        }
        return this.workflowProperties;
    }
}

