/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.content;

import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.Node;

public class ViewContentPropertiesDialog
extends BaseDialogBean {
    private static final long serialVersionUID = -867609607881256449L;
    protected static final String TEMP_PROP_MIMETYPE = "mimetype";
    protected static final String TEMP_PROP_ENCODING = "encoding";
    protected Node viewingNode;

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        Node document = this.browseBean.getDocument();
        if (document != null) {
            this.viewingNode = new Node(document.getNodeRef());
            ContentData content = (ContentData)this.viewingNode.getProperties().get(ContentModel.PROP_CONTENT);
            if (content != null) {
                this.viewingNode.getProperties().put(TEMP_PROP_MIMETYPE, content.getMimetype());
                this.viewingNode.getProperties().put(TEMP_PROP_ENCODING, content.getEncoding());
            }
            this.viewingNode.addPropertyResolver("size", this.browseBean.resolverSize);
        }
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        return outcome;
    }

    @Override
    public String getCancelButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), "close");
    }

    public Node getViewingNode() {
        return this.viewingNode;
    }
}

