/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.dashboard;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.web.bean.dashboard.Column;
import org.alfresco.web.config.DashboardsConfigElement;

final class Page
implements Serializable {
    private static final long serialVersionUID = 8023042580316126423L;
    private String id;
    private DashboardsConfigElement.LayoutDefinition layoutDef;
    private List<Column> columns = new ArrayList<Column>(4);

    public Page(String id, DashboardsConfigElement.LayoutDefinition layout) {
        if (id == null || id.length() == 0) {
            throw new IllegalArgumentException("ID for a Dashboard Page is mandatory.");
        }
        if (layout == null) {
            throw new IllegalArgumentException("Layout for a Dashboard Page is mandatory.");
        }
        this.id = id;
        this.layoutDef = layout;
    }

    public Page(Page copy) {
        this.id = copy.id;
        this.layoutDef = copy.layoutDef;
        for (Column column : copy.columns) {
            Column cloneColumn = new Column(column);
            this.addColumn(cloneColumn);
        }
    }

    public String getId() {
        return this.id;
    }

    public DashboardsConfigElement.LayoutDefinition getLayoutDefinition() {
        return this.layoutDef;
    }

    public void setLayoutDefinition(DashboardsConfigElement.LayoutDefinition layout) {
        if (layout == null) {
            throw new IllegalArgumentException("Layout for a Dashboard Page is mandatory.");
        }
        while (this.columns.size() < layout.Columns) {
            this.addColumn(new Column());
        }
        if (this.columns.size() > layout.Columns) {
            this.columns = this.columns.subList(0, layout.Columns);
        }
        this.layoutDef = layout;
    }

    public void addColumn(Column column) {
        this.columns.add(column);
    }

    public List<Column> getColumns() {
        return this.columns;
    }
}

