/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.dialog;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.dialog.ChangeViewSupport;
import org.alfresco.web.bean.dialog.DialogState;
import org.alfresco.web.bean.dialog.FilterViewSupport;
import org.alfresco.web.bean.dialog.IDialogBean;
import org.alfresco.web.bean.dialog.NavigationSupport;
import org.alfresco.web.config.DialogsConfigElement;
import org.alfresco.web.ui.common.component.UIActionLink;

public final class DialogManager
implements Serializable {
    private static final long serialVersionUID = -8690844273074627353L;
    public static final String BEAN_NAME = "DialogManager";
    private DialogState currentDialogState;
    private Map<String, String> paramsToApply;

    public void setupParameters(Map<String, String> params) {
        this.paramsToApply = params;
    }

    public void setupParameters(ActionEvent event) {
        UIComponent component = event.getComponent();
        if (component instanceof UIActionLink) {
            this.paramsToApply = ((UIActionLink)component).getParameterMap();
            for (String name : this.paramsToApply.keySet()) {
                String value = this.paramsToApply.get(name);
                if (value == null || !value.equalsIgnoreCase("null")) continue;
                this.paramsToApply.put(name, null);
            }
        }
    }

    public void setCurrentDialog(DialogsConfigElement.DialogConfig config) {
        String beanName = config.getManagedBean();
        Object bean = FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), beanName);
        if (bean == null) {
            throw new AlfrescoRuntimeException("Failed to start dialog as managed bean '" + beanName + "' has not been defined");
        }
        IDialogBean dialog = null;
        if (!(bean instanceof IDialogBean)) {
            throw new AlfrescoRuntimeException("Failed to start dialog as managed bean '" + beanName + "' does not implement the required IDialogBean interface");
        }
        dialog = (IDialogBean)bean;
        this.currentDialogState = new DialogState(config, dialog);
        dialog.init(this.paramsToApply);
        this.paramsToApply = null;
    }

    public DialogState getState() {
        return this.currentDialogState;
    }

    public void restoreState(DialogState state) {
        this.currentDialogState = state;
        this.currentDialogState.getDialog().restored();
    }

    public DialogsConfigElement.DialogConfig getCurrentDialog() {
        return this.currentDialogState.getConfig();
    }

    public IDialogBean getBean() {
        return this.currentDialogState.getDialog();
    }

    public String getIcon() {
        return this.currentDialogState.getConfig().getIcon();
    }

    public String getErrorMessage() {
        return Application.getMessage(FacesContext.getCurrentInstance(), this.currentDialogState.getConfig().getErrorMessageId());
    }

    public String getTitle() {
        String title = this.currentDialogState.getDialog().getContainerTitle();
        if (title == null) {
            title = this.currentDialogState.getConfig().getTitleId();
            title = title != null ? Application.getMessage(FacesContext.getCurrentInstance(), title) : this.currentDialogState.getConfig().getTitle();
        }
        return title;
    }

    public String getSubTitle() {
        String subTitle = this.currentDialogState.getDialog().getContainerSubTitle();
        if (subTitle == null) {
            subTitle = this.currentDialogState.getConfig().getSubTitleId();
            subTitle = subTitle != null ? Application.getMessage(FacesContext.getCurrentInstance(), subTitle) : this.currentDialogState.getConfig().getSubTitle();
        }
        return subTitle;
    }

    public String getDescription() {
        String desc = this.currentDialogState.getDialog().getContainerDescription();
        if (desc == null) {
            desc = this.currentDialogState.getConfig().getDescriptionId();
            desc = desc != null ? Application.getMessage(FacesContext.getCurrentInstance(), desc) : this.currentDialogState.getConfig().getDescription();
        }
        return desc;
    }

    public String getPage() {
        return this.currentDialogState.getConfig().getPage();
    }

    public String getActionsId() {
        String configId = this.currentDialogState.getDialog().getActionsConfigId();
        if (configId == null) {
            configId = this.currentDialogState.getConfig().getActionsConfigId();
        }
        return configId;
    }

    public String getMoreActionsId() {
        String configId = this.currentDialogState.getDialog().getMoreActionsConfigId();
        if (configId == null) {
            configId = this.currentDialogState.getConfig().getMoreActionsConfigId();
        }
        return configId;
    }

    public Object getActionsContext() {
        return this.currentDialogState.getDialog().getActionsContext();
    }

    public String getActionsMenuLabel() {
        String label = this.currentDialogState.getConfig().getActionsMenuLabelId();
        label = label != null ? Application.getMessage(FacesContext.getCurrentInstance(), label) : this.currentDialogState.getConfig().getActionsMenuLabel();
        if (label == null) {
            label = Application.getMessage(FacesContext.getCurrentInstance(), "create_options");
        }
        return label;
    }

    public String getMoreActionsMenuLabel() {
        String label = this.currentDialogState.getConfig().getMoreActionsMenuLabelId();
        label = label != null ? Application.getMessage(FacesContext.getCurrentInstance(), label) : this.currentDialogState.getConfig().getMoreActionsMenuLabel();
        if (label == null) {
            label = Application.getMessage(FacesContext.getCurrentInstance(), "more_actions");
        }
        return label;
    }

    public boolean getActionsAsMenu() {
        return this.currentDialogState.getConfig().getActionsAsMenu();
    }

    public boolean isOKButtonVisible() {
        return this.currentDialogState.getConfig().isOKButtonVisible();
    }

    public boolean isNavigationVisible() {
        return this.getBean() instanceof NavigationSupport;
    }

    public boolean isViewListVisible() {
        return this.getBean() instanceof ChangeViewSupport;
    }

    public boolean isFilterListVisible() {
        return this.getBean() instanceof FilterViewSupport;
    }

    public List<DialogsConfigElement.DialogButtonConfig> getAdditionalButtons() {
        List<DialogsConfigElement.DialogButtonConfig> buttons = null;
        List<DialogsConfigElement.DialogButtonConfig> cfgButtons = this.currentDialogState.getConfig().getButtons();
        List<DialogsConfigElement.DialogButtonConfig> dynButtons = this.currentDialogState.getDialog().getAdditionalButtons();
        if (cfgButtons != null && dynButtons != null) {
            buttons = new ArrayList<DialogsConfigElement.DialogButtonConfig>(cfgButtons.size() + dynButtons.size());
            buttons.addAll(cfgButtons);
            buttons.addAll(dynButtons);
        } else if (cfgButtons != null && dynButtons == null) {
            buttons = cfgButtons;
        } else if (cfgButtons == null && dynButtons != null) {
            buttons = dynButtons;
        }
        return buttons;
    }

    public String getCancelButtonLabel() {
        return this.currentDialogState.getDialog().getCancelButtonLabel();
    }

    public String getFinishButtonLabel() {
        return this.currentDialogState.getDialog().getFinishButtonLabel();
    }

    public boolean getFinishButtonDisabled() {
        return this.currentDialogState.getDialog().getFinishButtonDisabled();
    }

    public String finish() {
        return this.currentDialogState.getDialog().finish();
    }

    public String cancel() {
        return this.currentDialogState.getDialog().cancel();
    }
}

