/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.forums;

import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.model.ForumModel;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.forums.ForumsBean;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.spaces.CreateSpaceDialog;
import org.alfresco.web.ui.common.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CreateTopicDialog
extends CreateSpaceDialog {
    private static final long serialVersionUID = -8672220556613430308L;
    protected String message;
    private transient ContentService contentService;
    private static final Log logger = LogFactory.getLog(CreateTopicDialog.class);

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.spaceType = ForumModel.TYPE_TOPIC.toString();
        this.message = null;
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        super.finishImpl(context, outcome);
        NodeRef containerNodeRef = this.createdNode;
        String fileName = ForumsBean.createPostFileName();
        FileInfo fileInfo = this.getFileFolderService().create(containerNodeRef, fileName, ForumModel.TYPE_POST);
        NodeRef postNodeRef = fileInfo.getNodeRef();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Created post node with filename: " + fileName));
        }
        HashMap<QName, String> titledProps = new HashMap<QName, String>(3, 1.0f);
        titledProps.put(ContentModel.PROP_TITLE, fileName);
        this.getNodeService().addAspect(postNodeRef, ContentModel.ASPECT_TITLED, titledProps);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Added titled aspect with properties: " + titledProps));
        }
        HashMap<QName, Boolean> editProps = new HashMap<QName, Boolean>(1, 1.0f);
        editProps.put(ApplicationModel.PROP_EDITINLINE, true);
        this.getNodeService().addAspect(postNodeRef, ApplicationModel.ASPECT_INLINEEDITABLE, editProps);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Added inlineeditable aspect with properties: " + editProps));
        }
        ContentWriter writer = this.getContentService().getWriter(postNodeRef, ContentModel.PROP_CONTENT, true);
        writer.setMimetype(Repository.getMimeTypeForFileName(context, fileName));
        writer.setEncoding("UTF-8");
        writer.putContent(Utils.replaceLineBreaks((String)this.message, (boolean)false));
        return outcome;
    }

    @Override
    protected String doPostCommitProcessing(FacesContext context, String outcome) {
        this.browseBean.clickSpace(this.createdNode);
        return outcome + ":" + "showTopic";
    }

    @Override
    public String getFinishButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), "create_topic");
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    protected ContentService getContentService() {
        if (this.contentService == null) {
            this.contentService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getContentService();
        }
        return this.contentService;
    }
}

