/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.forums;

import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.forums.CreatePostDialog;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.ui.common.Utils;
import org.springframework.util.StringUtils;

public class EditPostDialog
extends CreatePostDialog {
    private static final long serialVersionUID = 7925794441178897699L;

    @Override
    public void init(Map<String, String> parameters) {
        String htmlContent;
        super.init(parameters);
        Node currentDocument = this.browseBean.getDocument();
        ContentReader reader = this.getContentService().getReader(currentDocument.getNodeRef(), ContentModel.PROP_CONTENT);
        if (reader != null && (htmlContent = reader.getContentString()) != null) {
            htmlContent = StringUtils.replace((String)htmlContent, (String)"<br/>", (String)"\r\n");
            this.content = StringUtils.replace((String)htmlContent, (String)"<br>", (String)"\r\n");
        }
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        ContentWriter writer;
        this.content = Utils.replaceLineBreaks((String)this.content, (boolean)false);
        NodeRef postNode = this.browseBean.getDocument().getNodeRef();
        String name = (String)((Object)this.getNodeService().getProperty(postNode, ContentModel.PROP_NAME));
        if (name.indexOf(":") != -1) {
            String newName = name.replace(':', '-');
            this.getFileFolderService().rename(postNode, newName);
        }
        if ((writer = this.getContentService().getWriter(postNode, ContentModel.PROP_CONTENT, true)) != null) {
            writer.putContent(this.content);
        }
        return outcome;
    }

    @Override
    public String getFinishButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), "ok");
    }
}

