/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.forums;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.transaction.UserTransaction;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.model.ForumModel;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.QueryParameterDefinition;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.context.IContextListener;
import org.alfresco.web.app.context.UIContextService;
import org.alfresco.web.bean.BrowseBean;
import org.alfresco.web.bean.NavigationBean;
import org.alfresco.web.bean.repository.MapNode;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.NodePropertyResolver;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.config.ViewsConfigElement;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.UIActionLink;
import org.alfresco.web.ui.common.component.UIModeList;
import org.alfresco.web.ui.common.component.data.UIColumn;
import org.alfresco.web.ui.common.component.data.UIRichList;
import org.alfresco.web.ui.common.renderer.data.IRichListRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ForumsBean
implements IContextListener {
    private static final long serialVersionUID = 7066410060288061436L;
    private static Log logger = LogFactory.getLog(ForumsBean.class);
    private static final String PAGE_NAME_FORUMS = "forums";
    private static final String PAGE_NAME_FORUM = "forum";
    private static final String PAGE_NAME_TOPIC = "topic";
    private transient NodeService nodeService;
    private transient ContentService contentService;
    private transient DictionaryService dictionaryService;
    private transient SearchService searchService;
    private transient NamespaceService namespaceService;
    protected BrowseBean browseBean;
    protected NavigationBean navigator;
    protected ViewsConfigElement viewsConfig = null;
    protected UIRichList forumsRichList;
    protected UIRichList forumRichList;
    protected UIRichList topicRichList;
    private List<Node> forums;
    private List<Node> topics;
    private List<Node> posts;
    private String forumsViewMode;
    private int forumsPageSize;
    private String forumViewMode;
    private int forumPageSize;
    private String topicViewMode;
    private int topicPageSize;
    public NodePropertyResolver resolverReplies = new NodePropertyResolver(){
        private static final long serialVersionUID = -4800772273246202885L;

        @Override
        public Object get(Node node) {
            String repliesXPath = "./*[(subtypeOf('" + ForumModel.TYPE_POST + "'))]";
            List replies = ForumsBean.this.getSearchService().selectNodes(node.getNodeRef(), repliesXPath, new QueryParameterDefinition[0], (NamespacePrefixResolver)ForumsBean.this.getNamespaceService(), false);
            int noReplies = replies.size() - 1;
            if (noReplies < 0) {
                noReplies = 0;
            }
            return new Integer(noReplies);
        }
    };
    public NodePropertyResolver resolverContent = new NodePropertyResolver(){
        private static final long serialVersionUID = -2575377410105460440L;

        @Override
        public Object get(Node node) {
            String content = null;
            ContentReader reader = ForumsBean.this.getContentService().getReader(node.getNodeRef(), ContentModel.PROP_CONTENT);
            if (reader != null) {
                content = Utils.stripUnsafeHTMLTags((String)reader.getContentString());
            }
            return content;
        }
    };
    public NodePropertyResolver resolverReplyTo = new NodePropertyResolver(){
        private static final long serialVersionUID = 2614901755220899360L;

        @Override
        public Object get(Node node) {
            String replyTo = null;
            List assocs = ForumsBean.this.getNodeService().getTargetAssocs(node.getNodeRef(), (QNamePattern)ContentModel.ASSOC_REFERENCES);
            if (assocs.size() > 0) {
                AssociationRef assoc = (AssociationRef)assocs.get(0);
                NodeRef target = assoc.getTargetRef();
                Node targetNode = new Node(target);
                replyTo = (String)targetNode.getProperties().get("creator");
            }
            return replyTo;
        }
    };

    public ForumsBean() {
        UIContextService.getInstance(FacesContext.getCurrentInstance()).registerBean(this);
        this.initFromClientConfig();
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    protected NodeService getNodeService() {
        if (this.nodeService == null) {
            this.nodeService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getNodeService();
        }
        return this.nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    protected ContentService getContentService() {
        if (this.contentService == null) {
            this.contentService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getContentService();
        }
        return this.contentService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    protected DictionaryService getDictionaryService() {
        if (this.dictionaryService == null) {
            this.dictionaryService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getDictionaryService();
        }
        return this.dictionaryService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    protected SearchService getSearchService() {
        if (this.searchService == null) {
            this.searchService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getSearchService();
        }
        return this.searchService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    protected NamespaceService getNamespaceService() {
        if (this.namespaceService == null) {
            this.namespaceService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getNamespaceService();
        }
        return this.namespaceService;
    }

    public void setBrowseBean(BrowseBean browseBean) {
        this.browseBean = browseBean;
    }

    public void setNavigator(NavigationBean navigator) {
        this.navigator = navigator;
    }

    public void setForumsRichList(UIRichList forumsRichList) {
        this.forumsRichList = forumsRichList;
        if (this.forumsRichList != null) {
            this.forumsRichList.setInitialSortColumn(this.viewsConfig.getDefaultSortColumn(PAGE_NAME_FORUMS));
            this.forumsRichList.setInitialSortDescending(this.viewsConfig.hasDescendingSort(PAGE_NAME_FORUMS));
            this.forumsRichList.setRefreshOnBind(true);
        }
    }

    public UIRichList getForumsRichList() {
        return this.forumsRichList;
    }

    public String getForumsViewMode() {
        return this.forumsViewMode;
    }

    public void setForumsViewMode(String forumsViewMode) {
        this.forumsViewMode = forumsViewMode;
    }

    public int getForumsPageSize() {
        return this.forumsPageSize;
    }

    public void setForumsPageSize(int forumsPageSize) {
        this.forumsPageSize = forumsPageSize;
    }

    public void setTopicRichList(UIRichList topicRichList) {
        this.topicRichList = topicRichList;
        if (this.topicRichList != null) {
            this.topicRichList.setInitialSortColumn(this.viewsConfig.getDefaultSortColumn(PAGE_NAME_TOPIC));
            this.topicRichList.setInitialSortDescending(this.viewsConfig.hasDescendingSort(PAGE_NAME_TOPIC));
            this.topicRichList.setRefreshOnBind(true);
        }
    }

    public UIRichList getTopicRichList() {
        return this.topicRichList;
    }

    public String getTopicViewMode() {
        return this.topicViewMode;
    }

    public void setTopicViewMode(String topicViewMode) {
        this.topicViewMode = topicViewMode;
    }

    public int getTopicPageSize() {
        return this.topicPageSize;
    }

    public void setTopicPageSize(int topicPageSize) {
        this.topicPageSize = topicPageSize;
    }

    public void setForumRichList(UIRichList forumRichList) {
        this.forumRichList = forumRichList;
        if (this.forumRichList != null) {
            this.forumRichList.setInitialSortColumn(this.viewsConfig.getDefaultSortColumn(PAGE_NAME_FORUM));
            this.forumRichList.setInitialSortDescending(this.viewsConfig.hasDescendingSort(PAGE_NAME_FORUM));
            this.forumRichList.setRefreshOnBind(true);
        }
    }

    public UIRichList getForumRichList() {
        return this.forumRichList;
    }

    public String getForumViewMode() {
        return this.forumViewMode;
    }

    public void setForumViewMode(String forumViewMode) {
        this.forumViewMode = forumViewMode;
    }

    public int getForumPageSize() {
        return this.forumPageSize;
    }

    public void setForumPageSize(int forumPageSize) {
        this.forumPageSize = forumPageSize;
    }

    public List<Node> getForums() {
        if (this.forums == null) {
            this.getNodes();
        }
        return this.forums;
    }

    public List<Node> getTopics() {
        if (this.topics == null) {
            this.getNodes();
        }
        return this.topics;
    }

    public List<Node> getPosts() {
        if (this.posts == null) {
            this.getNodes();
        }
        return this.posts;
    }

    private void getNodes() {
        long startTime = 0L;
        if (logger.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
        }
        UserTransaction tx = null;
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            tx = Repository.getUserTransaction(context, true);
            tx.begin();
            String parentNodeId = this.navigator.getCurrentNodeId();
            NodeRef parentRef = parentNodeId == null ? this.getNodeService().getRootNode(Repository.getStoreRef()) : new NodeRef(Repository.getStoreRef(), parentNodeId);
            List childRefs = this.getNodeService().getChildAssocs(parentRef, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
            this.forums = new ArrayList<Node>(childRefs.size());
            this.topics = new ArrayList<Node>(childRefs.size());
            this.posts = new ArrayList<Node>(childRefs.size());
            for (ChildAssociationRef ref : childRefs) {
                NodeRef nodeRef = ref.getChildRef();
                if (!this.getNodeService().exists(nodeRef)) continue;
                QName type = this.getNodeService().getType(nodeRef);
                TypeDefinition typeDef = this.getDictionaryService().getType(type);
                if (typeDef != null) {
                    MapNode node;
                    if (this.getDictionaryService().isSubClass(type, ContentModel.TYPE_SYSTEM_FOLDER)) continue;
                    if (this.getDictionaryService().isSubClass(type, ForumModel.TYPE_FORUMS) || this.getDictionaryService().isSubClass(type, ForumModel.TYPE_FORUM)) {
                        node = new MapNode(nodeRef, this.getNodeService(), true);
                        node.addPropertyResolver("icon", this.browseBean.resolverSpaceIcon);
                        node.addPropertyResolver("smallIcon", this.browseBean.resolverSmallIcon);
                        this.forums.add(node);
                    }
                    if (this.getDictionaryService().isSubClass(type, ForumModel.TYPE_TOPIC)) {
                        node = new MapNode(nodeRef, this.getNodeService(), true);
                        node.addPropertyResolver("icon", this.browseBean.resolverSpaceIcon);
                        node.addPropertyResolver("smallIcon", this.browseBean.resolverSmallIcon);
                        node.addPropertyResolver("replies", this.resolverReplies);
                        this.topics.add(node);
                        continue;
                    }
                    if (!this.getDictionaryService().isSubClass(type, ForumModel.TYPE_POST)) continue;
                    node = new MapNode(nodeRef, this.getNodeService(), true);
                    this.browseBean.setupCommonBindingProperties(node);
                    node.addPropertyResolver("smallIcon", this.browseBean.resolverSmallIcon);
                    node.addPropertyResolver("message", this.resolverContent);
                    node.addPropertyResolver("replyTo", this.resolverReplyTo);
                    this.posts.add(node);
                    continue;
                }
                if (!logger.isWarnEnabled()) continue;
                logger.warn((Object)("Found invalid object in database: id = " + nodeRef + ", type = " + type));
            }
            tx.commit();
        }
        catch (InvalidNodeRefException refErr) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_noderef"), refErr.getNodeRef()));
            this.forums = Collections.emptyList();
            this.topics = Collections.emptyList();
            this.posts = Collections.emptyList();
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception tex) {}
        }
        catch (Throwable err) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_generic"), err.getMessage()), err);
            this.forums = Collections.emptyList();
            this.topics = Collections.emptyList();
            this.posts = Collections.emptyList();
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception tex) {
                // empty catch block
            }
        }
        if (logger.isDebugEnabled()) {
            long endTime = System.currentTimeMillis();
            logger.debug((Object)("Time to query and build forums nodes: " + (endTime - startTime) + "ms"));
        }
    }

    public String getReplyBubbleHTML() {
        try {
            StringWriter writer = new StringWriter();
            FacesContext context = FacesContext.getCurrentInstance();
            Node replyToNode = this.browseBean.getDocument();
            boolean isReplyPost = this.getNodeService().hasAspect(replyToNode.getNodeRef(), ContentModel.ASPECT_REFERENCING);
            String contextPath = context.getExternalContext().getRequestContextPath();
            String colour = isReplyPost ? "yellow" : "orange";
            String bgColour = isReplyPost ? "#FFF5A3" : "#FCC75E";
            StringBuilder replyPosterHTML = new StringBuilder("<td valign='top'>");
            replyPosterHTML.append("<img src='");
            replyPosterHTML.append(contextPath);
            replyPosterHTML.append("/images/icons/user_large.gif' /><br>");
            replyPosterHTML.append((String)replyToNode.getProperties().get("creator"));
            replyPosterHTML.append("</td>");
            writer.write("<table border='0' cellpadding='0' cellspacing='0' width='100%'><tr>");
            if (isReplyPost) {
                this.renderReplyContentHTML(context, replyToNode, writer, contextPath, colour, bgColour);
                writer.write(replyPosterHTML.toString());
            } else {
                writer.write(replyPosterHTML.toString());
                this.renderReplyContentHTML(context, replyToNode, writer, contextPath, colour, bgColour);
            }
            writer.write("</tr></table>");
            return writer.toString();
        }
        catch (IOException ioe) {
            throw new AlfrescoRuntimeException("Failed to render reply bubble HTML", (Throwable)ioe);
        }
    }

    @Override
    public void contextUpdated() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Invalidating forums components...");
        }
        if (this.forumsRichList != null) {
            this.forumsRichList.setValue(null);
            if (this.forumsRichList.getInitialSortColumn() == null) {
                this.forumsRichList.setInitialSortColumn(this.viewsConfig.getDefaultSortColumn(PAGE_NAME_FORUMS));
                this.forumsRichList.setInitialSortDescending(this.viewsConfig.hasDescendingSort(PAGE_NAME_FORUMS));
            }
        }
        if (this.forumRichList != null) {
            this.forumRichList.setValue(null);
            if (this.forumRichList.getInitialSortColumn() == null) {
                this.forumRichList.setInitialSortColumn(this.viewsConfig.getDefaultSortColumn(PAGE_NAME_FORUM));
                this.forumRichList.setInitialSortDescending(this.viewsConfig.hasDescendingSort(PAGE_NAME_FORUM));
            }
        }
        if (this.topicRichList != null) {
            this.topicRichList.setValue(null);
            if (this.topicRichList.getInitialSortColumn() == null) {
                this.topicRichList.setInitialSortColumn(this.viewsConfig.getDefaultSortColumn(PAGE_NAME_TOPIC));
                this.topicRichList.setInitialSortDescending(this.viewsConfig.hasDescendingSort(PAGE_NAME_TOPIC));
            }
        }
        this.forums = null;
        this.topics = null;
        this.posts = null;
    }

    @Override
    public void areaChanged() {
    }

    @Override
    public void spaceChanged() {
    }

    public void forumsViewModeChanged(ActionEvent event) {
        UIModeList viewList = (UIModeList)event.getComponent();
        String viewMode = viewList.getValue().toString();
        this.setForumsViewMode(viewMode);
        this.forumsPageSize = this.viewsConfig.getDefaultPageSize(PAGE_NAME_FORUMS, this.forumsViewMode);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Set default forums page size to: " + this.forumsPageSize));
        }
    }

    public void forumViewModeChanged(ActionEvent event) {
        UIModeList viewList = (UIModeList)event.getComponent();
        String viewMode = viewList.getValue().toString();
        this.setForumViewMode(viewMode);
        this.forumPageSize = this.viewsConfig.getDefaultPageSize(PAGE_NAME_FORUM, this.forumViewMode);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Set default forum page size to: " + this.forumPageSize));
        }
    }

    public void topicViewModeChanged(ActionEvent event) {
        UIModeList viewList = (UIModeList)event.getComponent();
        String viewMode = viewList.getValue().toString();
        this.setTopicViewMode(viewMode);
        this.topicPageSize = this.viewsConfig.getDefaultPageSize(PAGE_NAME_TOPIC, this.topicViewMode);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Set default topic page size to: " + this.topicPageSize));
        }
    }

    public void discuss(ActionEvent event) {
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String id = params.get("id");
        if (id == null || id.length() == 0) {
            throw new AlfrescoRuntimeException("discuss called without an id");
        }
        FacesContext context = FacesContext.getCurrentInstance();
        NodeRef nodeRef = new NodeRef(Repository.getStoreRef(), id);
        if (!this.getNodeService().hasAspect(nodeRef, ForumModel.ASPECT_DISCUSSABLE)) {
            throw new AlfrescoRuntimeException("discuss called for an object that does not have a discussion!");
        }
        List children = this.getNodeService().getChildAssocs(nodeRef, (QNamePattern)ForumModel.ASSOC_DISCUSSION, RegexQNamePattern.MATCH_ALL);
        if (children.size() == 1) {
            NodeRef forumNodeRef = ((ChildAssociationRef)children.get(0)).getChildRef();
            this.browseBean.clickSpace(forumNodeRef);
            context.getApplication().getNavigationHandler().handleNavigation(context, null, "showForum");
        } else {
            logger.warn((Object)("Node has the discussable aspect but does not have 1 child, it has " + children.size() + " children!"));
        }
    }

    public static String createPostFileName() {
        StringBuilder name = new StringBuilder("posted-");
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy-HH-mm-ss");
        name.append(dateFormat.format(new Date()));
        name.append("-" + UUID.randomUUID());
        name.append(".html");
        return name.toString();
    }

    private void initFromClientConfig() {
        this.viewsConfig = (ViewsConfigElement)Application.getConfigService(FacesContext.getCurrentInstance()).getConfig((Object)"Views").getConfigElement("views");
        this.forumsViewMode = this.viewsConfig.getDefaultView(PAGE_NAME_FORUMS);
        this.forumsPageSize = this.viewsConfig.getDefaultPageSize(PAGE_NAME_FORUMS, this.forumsViewMode);
        this.forumViewMode = this.viewsConfig.getDefaultView(PAGE_NAME_FORUM);
        this.forumPageSize = this.viewsConfig.getDefaultPageSize(PAGE_NAME_FORUM, this.forumViewMode);
        this.topicViewMode = this.viewsConfig.getDefaultView(PAGE_NAME_TOPIC);
        this.topicPageSize = this.viewsConfig.getDefaultPageSize(PAGE_NAME_TOPIC, this.topicViewMode);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Set default forums view mode to: " + this.forumsViewMode));
            logger.debug((Object)("Set default forums page size to: " + this.forumsPageSize));
            logger.debug((Object)("Set default forum view mode to: " + this.forumViewMode));
            logger.debug((Object)("Set default forum page size to: " + this.forumPageSize));
            logger.debug((Object)("Set default topic view mode to: " + this.topicViewMode));
            logger.debug((Object)("Set default topic page size to: " + this.topicPageSize));
        }
    }

    protected void renderReplyContentHTML(FacesContext context, Node replyToNode, StringWriter writer, String contextPath, String colour, String bgColour) throws IOException {
        String replyContent = "";
        ContentReader reader = this.getContentService().getReader(replyToNode.getNodeRef(), ContentModel.PROP_CONTENT);
        if (reader != null) {
            replyContent = Utils.stripUnsafeHTMLTags((String)reader.getContentString());
        }
        String postedDate = Utils.getDateTimeFormat(context).format(replyToNode.getProperties().get("created"));
        writer.write("<td width='100%'>");
        TopicBubbleViewRenderer.renderBubbleTop(writer, contextPath, colour, bgColour);
        writer.write("<span class='mainSubTitle'>");
        writer.write(Application.getMessage(context, "posted"));
        writer.write(":&nbsp</span>");
        writer.write(postedDate);
        TopicBubbleViewRenderer.renderBubbleMiddle(writer, contextPath, colour);
        writer.write(replyContent);
        TopicBubbleViewRenderer.renderBubbleBottom(writer, contextPath, colour);
        writer.write("</td>");
    }

    public static class TopicBubbleViewRenderer
    implements IRichListRenderer {
        private static final long serialVersionUID = -6641033880549363822L;
        public static final String VIEWMODEID = "bubble";

        @Override
        public String getViewModeID() {
            return VIEWMODEID;
        }

        @Override
        public void renderListBefore(FacesContext context, UIRichList richList, UIColumn[] columns) throws IOException {
        }

        @Override
        public void renderListRow(FacesContext context, UIRichList richList, UIColumn[] columns, Object row) throws IOException {
            ResponseWriter out = context.getResponseWriter();
            UIColumn primaryColumn = null;
            UIColumn actionsColumn = null;
            for (int i = 0; i < columns.length; ++i) {
                if (!columns[i].isRendered()) continue;
                if (columns[i].getPrimary()) {
                    primaryColumn = columns[i];
                    continue;
                }
                if (!columns[i].getActions()) continue;
                actionsColumn = columns[i];
            }
            if (primaryColumn == null && logger.isWarnEnabled()) {
                logger.warn((Object)("No primary column found for RichList definition: " + richList.getId()));
            }
            out.write("<tr>");
            Node node = (Node)row;
            if (node.getProperties().get("replyTo") == null) {
                this.renderNewPostBubble(context, out, node, primaryColumn, actionsColumn, columns);
            } else {
                this.renderReplyToBubble(context, out, node, primaryColumn, actionsColumn, columns);
            }
            out.write("</tr>");
            out.write("<tr><td><div style='padding:3px'></div></td></tr>");
        }

        @Override
        public void renderListAfter(FacesContext context, UIRichList richList, UIColumn[] columns) throws IOException {
            ResponseWriter out = context.getResponseWriter();
            out.write("<tr><td colspan='99' align='center'>");
            for (UIComponent child : richList.getChildren()) {
                if (child instanceof UIColumn) continue;
                Utils.encodeRecursive(context, child);
            }
            out.write("</td></tr>");
        }

        public static void renderBubbleTop(Writer out, String contextPath, String colour, String titleBgColour) throws IOException {
            out.write("<table border='0' cellpadding='0' cellspacing='0' width='100%'><tr>");
            out.write("<td style='background: url(");
            out.write(contextPath);
            out.write("/images/parts/");
            out.write(colour);
            out.write("header_1.gif) no-repeat #FFFFFF;' width='24' height='24'></td>");
            out.write("<td style='background: url(");
            out.write(contextPath);
            out.write("/images/parts/");
            out.write(colour);
            out.write("header_2.gif) repeat-x ");
            out.write(titleBgColour);
            out.write("'>");
        }

        public static void renderBubbleMiddle(Writer out, String contextPath, String colour) throws IOException {
            out.write("</td>");
            out.write("<td style='background: url(");
            out.write(contextPath);
            out.write("/images/parts/");
            out.write(colour);
            out.write("header_3.gif) no-repeat #FFFFFF;' width='24' height='24'></td>");
            out.write("</tr><tr>");
            out.write("<td width='24' height='13'><img width='24' height='13' alt='' src='");
            out.write(contextPath);
            out.write("/images/parts/");
            out.write(colour);
            out.write("body_1.gif' /></td>");
            out.write("<td background='");
            out.write(contextPath);
            out.write("/images/parts/");
            out.write(colour);
            out.write("body_2.gif'><img width='21' height='13' alt='' src='");
            out.write(contextPath);
            out.write("/images/parts/");
            out.write(colour);
            out.write("body_2.gif' /></td>");
            out.write("<td width='24' height='13'><img width='24' height='13' alt='' src='");
            out.write(contextPath);
            out.write("/images/parts/");
            out.write(colour);
            out.write("body_3.gif' /></td>");
            out.write("</tr><tr>");
            out.write("<td width='24' height='13' background='");
            out.write(contextPath);
            out.write("/images/parts/");
            out.write(colour);
            out.write("body_4.gif'><img width='24' height='4' alt='' src='");
            out.write(contextPath);
            out.write("/images/parts/");
            out.write(colour);
            out.write("body_4.gif' /></td>");
            out.write("<td>");
        }

        public static void renderBubbleBottom(Writer out, String contextPath, String colour) throws IOException {
            out.write("</td>");
            out.write("<td width='24' height='13' background='");
            out.write(contextPath);
            out.write("/images/parts/");
            out.write(colour);
            out.write("body_6.gif'><img width='24' height='3' alt='' src='");
            out.write(contextPath);
            out.write("/images/parts/");
            out.write(colour);
            out.write("body_6.gif' /></td>");
            out.write("</tr><tr>");
            out.write("<td width='24' height='13'><img width='24' height='13' alt='' src='");
            out.write(contextPath);
            out.write("/images/parts/");
            out.write(colour);
            out.write("body_7.gif' /></td>");
            out.write("<td background='");
            out.write(contextPath);
            out.write("/images/parts/");
            out.write(colour);
            out.write("body_8.gif'><img width='20' height='13' alt='' src='");
            out.write(contextPath);
            out.write("/images/parts/");
            out.write(colour);
            out.write("body_8.gif' /></td>");
            out.write("<td width='24' height='13'><img width='24' height='13' alt='' src='");
            out.write(contextPath);
            out.write("/images/parts/");
            out.write(colour);
            out.write("body_9.gif' /></td>");
            out.write("</tr></table>");
        }

        private void renderNewPostBubble(FacesContext context, ResponseWriter out, Node node, UIColumn primaryColumn, UIColumn actionsColumn, UIColumn[] columns) throws IOException {
            String contextPath = context.getExternalContext().getRequestContextPath();
            String colour = "orange";
            out.write("<td><table border='0' cellpadding='0' cellspacing='0' width='100%'><tr>");
            out.write("<td valign='top'><img src='");
            out.write(contextPath);
            out.write("/images/icons/user_large.gif'/><br>");
            out.write((String)node.getProperties().get("creator"));
            out.write("</td><td width='100%'>");
            TopicBubbleViewRenderer.renderBubbleTop((Writer)out, contextPath, colour, "#FCC75E");
            this.renderHeaderContents(context, out, primaryColumn, actionsColumn, columns);
            TopicBubbleViewRenderer.renderBubbleMiddle((Writer)out, contextPath, colour);
            this.renderBodyContents(context, primaryColumn);
            TopicBubbleViewRenderer.renderBubbleBottom((Writer)out, contextPath, colour);
            out.write("</td><td><div style='width:32px;'></div></td></tr></table></td>");
        }

        private void renderReplyToBubble(FacesContext context, ResponseWriter out, Node node, UIColumn primaryColumn, UIColumn actionsColumn, UIColumn[] columns) throws IOException {
            String contextPath = context.getExternalContext().getRequestContextPath();
            String colour = "yellow";
            out.write("<td width='100%'><table border='0' cellpadding='0' cellspacing='0' width='100%'><tr>");
            out.write("<td><div style='width:32px;'></div></td><td width='100%'>");
            TopicBubbleViewRenderer.renderBubbleTop((Writer)out, contextPath, colour, "#FFF5A3");
            this.renderHeaderContents(context, out, primaryColumn, actionsColumn, columns);
            TopicBubbleViewRenderer.renderBubbleMiddle((Writer)out, contextPath, colour);
            this.renderBodyContents(context, primaryColumn);
            TopicBubbleViewRenderer.renderBubbleBottom((Writer)out, contextPath, colour);
            out.write("</td><td valign='top'><img src='");
            out.write(contextPath);
            out.write("/images/icons/user_large.gif'/><br>");
            out.write((String)node.getProperties().get("creator"));
            out.write("</td></tr></table></td>");
        }

        private void renderHeaderContents(FacesContext context, ResponseWriter out, UIColumn primaryColumn, UIColumn actionsColumn, UIColumn[] columns) throws IOException {
            out.write("<table width='100%' cellpadding='2' cellspacing='2' border='0'><tr>");
            for (int i = 0; i < columns.length; ++i) {
                UIColumn column = columns[i];
                if (!column.isRendered() || column.getPrimary() || column.getActions()) continue;
                UIComponent header = column.getFacet("header");
                if (header != null) {
                    out.write("<td><nobr><b>");
                    Utils.encodeRecursive(context, header);
                    out.write("</b></nobr></td>");
                }
                if (column.getChildCount() == 0) continue;
                out.write("<td><nobr>");
                Utils.encodeRecursive(context, (UIComponent)column);
                out.write("</nobr></td>");
            }
            out.write("<td align='right' width='100%'><nobr>");
            if (actionsColumn != null && actionsColumn.getChildCount() != 0) {
                Utils.encodeRecursive(context, (UIComponent)actionsColumn);
            }
            out.write("</nobr></td></tr></table>");
        }

        private void renderBodyContents(FacesContext context, UIColumn primaryColumn) throws IOException {
            if (primaryColumn != null && primaryColumn.getChildCount() != 0) {
                Utils.encodeRecursive(context, (UIComponent)primaryColumn);
            }
        }
    }
}

