/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.generator;

import java.util.Calendar;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.generator.BaseComponentGenerator;
import org.alfresco.web.ui.common.converter.XMLDateConverter;
import org.alfresco.web.ui.repo.component.UIMultiValueEditor;
import org.alfresco.web.ui.repo.component.property.PropertySheetItem;
import org.alfresco.web.ui.repo.component.property.UIPropertySheet;

public class DatePickerGenerator
extends BaseComponentGenerator {
    private boolean initialiseIfNull = false;
    private int yearCount = 30;
    private int startYear = Calendar.getInstance().get(1) + 2;
    private String noneLabel = null;
    private static final String MSG_DATE = "date_pattern";

    public int getStartYear() {
        return this.startYear;
    }

    public void setStartYear(int startYear) {
        this.startYear = startYear;
    }

    public int getYearCount() {
        return this.yearCount;
    }

    public void setYearCount(int yearCount) {
        this.yearCount = yearCount;
    }

    public boolean isInitialiseIfNull() {
        return this.initialiseIfNull;
    }

    public void setInitialiseIfNull(boolean initialiseIfNull) {
        this.initialiseIfNull = initialiseIfNull;
    }

    public String getNoneLabel() {
        return this.noneLabel;
    }

    public void setNoneLabel(String noneLabel) {
        this.noneLabel = noneLabel;
    }

    @Override
    public UIComponent generate(FacesContext context, String id) {
        UIComponent component = context.getApplication().createComponent("javax.faces.Input");
        component.setRendererType("org.alfresco.faces.DatePickerRenderer");
        FacesHelper.setupComponentId(context, component, id);
        component.getAttributes().put("startYear", this.startYear);
        component.getAttributes().put("yearCount", this.yearCount);
        component.getAttributes().put("initialiseIfNull", new Boolean(this.initialiseIfNull));
        component.getAttributes().put("style", "margin-right: 7px;");
        if (this.noneLabel != null) {
            component.getAttributes().put("noneLabel", this.noneLabel);
        }
        return component;
    }

    @Override
    protected void setupConverter(FacesContext context, UIPropertySheet propertySheet, PropertySheetItem property, PropertyDefinition propertyDef, UIComponent component) {
        if (property.getConverter() != null) {
            this.createAndSetConverter(context, property.getConverter(), component);
        } else {
            ((UIOutput)component).setConverter(this.getDefaultConverter(context));
        }
    }

    @Override
    protected void setupMandatoryValidation(FacesContext context, UIPropertySheet propertySheet, PropertySheetItem item, UIComponent component, boolean realTimeChecking, String idSuffix) {
        if (component instanceof UIMultiValueEditor) {
            super.setupMandatoryValidation(context, propertySheet, item, component, true, "_current_value");
        } else {
            super.setupMandatoryValidation(context, propertySheet, item, component, true, idSuffix);
        }
    }

    protected Converter getDefaultConverter(FacesContext context) {
        XMLDateConverter converter = (XMLDateConverter)context.getApplication().createConverter("org.alfresco.faces.XMLDateConverter");
        converter.setType("date");
        converter.setPattern(Application.getMessage(context, MSG_DATE));
        return converter;
    }
}

