/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.generator;

import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import javax.faces.model.SelectItem;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.ml.ContentFilterLanguagesService;
import org.alfresco.service.cmr.ml.MultilingualContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.web.bean.generator.LanguageSelectorGenerator;

public class MlContainerLanguageSelectorGenerator
extends LanguageSelectorGenerator {
    protected MultilingualContentService multilingualContentService;
    protected ContentFilterLanguagesService contentFilterLanguagesService;
    protected NodeService nodeService;

    @Override
    protected SelectItem[] getLanguageItems() {
        Map translations = this.multilingualContentService.getTranslations(this.node.getNodeRef());
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (Map.Entry entry : translations.entrySet()) {
            if (this.nodeService.hasAspect((NodeRef)entry.getValue(), ContentModel.ASPECT_MULTILINGUAL_EMPTY_TRANSLATION)) continue;
            Locale loc = (Locale)entry.getKey();
            items.add(new SelectItem((Object)loc.getLanguage(), this.contentFilterLanguagesService.getLabelByCode(loc.toString())));
        }
        SelectItem[] itemsArray = new SelectItem[items.size()];
        items.toArray(itemsArray);
        return itemsArray;
    }

    public void setContentFilterLanguagesService(ContentFilterLanguagesService contentFilterLanguagesService) {
        this.contentFilterLanguagesService = contentFilterLanguagesService;
    }

    public void setMultilingualContentService(MultilingualContentService multilingualContentService) {
        this.multilingualContentService = multilingualContentService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }
}

