/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.generator;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UISelectItems;
import javax.faces.component.UISelectOne;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import org.alfresco.repo.dictionary.constraint.ListOfValuesConstraint;
import org.alfresco.service.cmr.dictionary.Constraint;
import org.alfresco.service.cmr.dictionary.ConstraintDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.generator.BaseComponentGenerator;
import org.alfresco.web.ui.repo.component.UIMultiValueEditor;
import org.alfresco.web.ui.repo.component.property.PropertySheetItem;
import org.alfresco.web.ui.repo.component.property.UIPropertySheet;

public class TextFieldGenerator
extends BaseComponentGenerator {
    private int size = 35;
    private int maxLength = 1024;

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    public UIComponent generate(FacesContext context, String id) {
        UIComponent component = context.getApplication().createComponent("javax.faces.Input");
        component.setRendererType("javax.faces.Text");
        FacesHelper.setupComponentId(context, component, id);
        component.getAttributes().put("size", this.size);
        component.getAttributes().put("maxlength", this.maxLength);
        return component;
    }

    @Override
    protected UIComponent createComponent(FacesContext context, UIPropertySheet propertySheet, PropertySheetItem item) {
        UIOutput component = null;
        if (propertySheet.inEditMode()) {
            ListOfValuesConstraint constraint = this.getListOfValuesConstraint(context, propertySheet, item);
            PropertyDefinition propDef = this.getPropertyDefinition(context, propertySheet.getNode(), item.getName());
            if (constraint != null && !item.isReadOnly() && propDef != null && !propDef.isProtected()) {
                component = context.getApplication().createComponent("javax.faces.SelectOne");
                FacesHelper.setupComponentId(context, (UIComponent)component, item.getName());
                UISelectItems itemsComponent = (UISelectItems)context.getApplication().createComponent("javax.faces.SelectItems");
                List values = constraint.getAllowedValues();
                ArrayList<SelectItem> items = new ArrayList<SelectItem>(values.size());
                for (String value : values) {
                    Object obj = null;
                    obj = propDef.getDataType().getName().equals((Object)DataTypeDefinition.INT) ? Integer.valueOf(value) : (propDef.getDataType().getName().equals((Object)DataTypeDefinition.LONG) ? Long.valueOf(value) : (propDef.getDataType().getName().equals((Object)DataTypeDefinition.DOUBLE) ? Double.valueOf(value) : (propDef.getDataType().getName().equals((Object)DataTypeDefinition.FLOAT) ? Float.valueOf(value) : value)));
                    String label = constraint.getDisplayLabel(value);
                    if (label == null) {
                        label = value;
                    }
                    items.add(new SelectItem(obj, label));
                }
                itemsComponent.setValue(items);
                component.getChildren().add(itemsComponent);
            } else {
                component = this.generate(context, item.getName());
            }
        } else {
            component = this.createOutputTextComponent(context, item.getName());
        }
        return component;
    }

    @Override
    protected void setupMandatoryValidation(FacesContext context, UIPropertySheet propertySheet, PropertySheetItem item, UIComponent component, boolean realTimeChecking, String idSuffix) {
        if (component instanceof UIMultiValueEditor) {
            super.setupMandatoryValidation(context, propertySheet, item, component, true, "_current_value");
        } else if (!(component instanceof UISelectOne)) {
            super.setupMandatoryValidation(context, propertySheet, item, component, true, idSuffix);
            component.getAttributes().put("onkeyup", "processButtonState();");
        }
    }

    @Override
    protected void setupConstraints(FacesContext context, UIPropertySheet propertySheet, PropertySheetItem property, PropertyDefinition propertyDef, UIComponent component) {
        super.setupConstraints(context, propertySheet, property, propertyDef, component);
        if (propertySheet.inEditMode() && propertySheet.isValidationEnabled() && propertyDef != null && (propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.DOUBLE) || propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.FLOAT) || propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.INT) || propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.LONG))) {
            ArrayList<String> params = new ArrayList<String>(3);
            String value = "document.getElementById('" + component.getClientId(context) + "')";
            params.add(value);
            String msg = Application.getMessage(context, "validation_is_number");
            this.addStringConstraintParam(params, MessageFormat.format(msg, property.getResolvedDisplayLabel()));
            propertySheet.addClientValidation(new UIPropertySheet.ClientValidation("validateIsNumber", params, false));
        }
    }

    protected ListOfValuesConstraint getListOfValuesConstraint(FacesContext context, UIPropertySheet propertySheet, PropertySheetItem item) {
        ListOfValuesConstraint lovConstraint = null;
        PropertyDefinition propertyDef = this.getPropertyDefinition(context, propertySheet.getNode(), item.getName());
        if (propertyDef != null) {
            List constraints = propertyDef.getConstraints();
            for (ConstraintDefinition constraintDef : constraints) {
                Constraint constraint = constraintDef.getConstraint();
                if (!(constraint instanceof ListOfValuesConstraint)) continue;
                lovConstraint = (ListOfValuesConstraint)constraint;
                break;
            }
        }
        return lovConstraint;
    }

    @Override
    protected void setupConverter(FacesContext context, UIPropertySheet propertySheet, PropertySheetItem property, PropertyDefinition propertyDef, UIComponent component) {
        ListOfValuesConstraint constraint;
        Converter converter;
        super.setupConverter(context, propertySheet, property, propertyDef, component);
        if (propertySheet.inEditMode() && propertyDef != null && component instanceof UIOutput && (converter = ((UIOutput)component).getConverter()) == null && (constraint = this.getListOfValuesConstraint(context, propertySheet, property)) != null) {
            String converterId = null;
            if (propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.INT)) {
                converterId = "javax.faces.Integer";
            } else if (propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.LONG)) {
                converterId = "javax.faces.Long";
            } else if (propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.DOUBLE)) {
                converterId = "javax.faces.Double";
            } else if (propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.FLOAT)) {
                converterId = "javax.faces.Float";
            }
            if (converterId != null) {
                this.createAndSetConverter(context, converterId, component);
            }
        }
    }
}

