/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.groups;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;
import javax.faces.model.SelectItem;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.groups.GroupsDialog;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.ui.common.SortableSelectItem;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.UIGenericPicker;
import org.apache.lucene.search.BooleanQuery;

public class AddUsersDialog
extends BaseDialogBean {
    private static final long serialVersionUID = 4893334797091942357L;
    protected String group;
    protected String groupName;
    private transient AuthorityService authService;
    private transient PersonService personService;
    protected List<GroupsDialog.UserAuthorityDetails> usersForGroup;
    protected transient DataModel usersDataModel = null;

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.group = parameters.get("group");
        this.groupName = parameters.get("groupName");
        this.usersDataModel = null;
        this.usersForGroup = new ArrayList<GroupsDialog.UserAuthorityDetails>();
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        Set containedAuthorities = this.getAuthService().getContainedAuthorities(null, this.group, true);
        for (GroupsDialog.UserAuthorityDetails wrapper : this.usersForGroup) {
            String user = wrapper.getAuthority();
            if (containedAuthorities.contains(user)) continue;
            this.getAuthService().addAuthority(this.group, user);
        }
        return outcome;
    }

    @Override
    public String getContainerSubTitle() {
        return this.groupName;
    }

    @Override
    public boolean getFinishButtonDisabled() {
        return false;
    }

    public void setAuthService(AuthorityService authService) {
        this.authService = authService;
    }

    protected AuthorityService getAuthService() {
        if (this.authService == null) {
            this.authService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAuthorityService();
        }
        return this.authService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    protected PersonService getPersonService() {
        if (this.personService == null) {
            this.personService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getPersonService();
        }
        return this.personService;
    }

    public DataModel getUsersDataModel() {
        if (this.usersDataModel == null) {
            this.usersDataModel = new ListDataModel();
        }
        if (this.usersDataModel.getWrappedData() == null) {
            this.usersDataModel.setWrappedData(this.usersForGroup);
        }
        return this.usersDataModel;
    }

    public SelectItem[] pickerCallback(int filterIndex, final String contains) {
        FacesContext context = FacesContext.getCurrentInstance();
        Object tx = null;
        try {
            RetryingTransactionHelper txHelper = Repository.getRetryingTransactionHelper(context);
            return (SelectItem[])txHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<SelectItem[]>(){

                public SelectItem[] execute() throws Exception {
                    SelectItem[] items = new SelectItem[]{};
                    String term = contains.trim();
                    if (term.length() != 0) {
                        List persons = AddUsersDialog.this.getPersonService().getPeople(Utils.generatePersonFilter(contains.trim()), true, Utils.generatePersonSort(), new PagingRequest(Utils.getPersonMaxResults(), null)).getPage();
                        ArrayList<SortableSelectItem> itemList = new ArrayList<SortableSelectItem>(persons.size());
                        for (PersonService.PersonInfo person : persons) {
                            String username = person.getUserName();
                            if (AuthenticationUtil.getGuestUserName().equals(username)) continue;
                            String firstName = person.getFirstName();
                            String lastName = person.getLastName();
                            String name = (firstName != null ? firstName : "") + ' ' + (lastName != null ? lastName : "");
                            SortableSelectItem item = new SortableSelectItem(username, name + " [" + username + "]", lastName != null ? lastName : username);
                            itemList.add(item);
                        }
                        items = new SelectItem[itemList.size()];
                        itemList.toArray(items);
                    }
                    return items;
                }
            });
        }
        catch (BooleanQuery.TooManyClauses clauses) {
            Utils.addErrorMessage(Application.getMessage(FacesContext.getCurrentInstance(), "too_many_users"));
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception tex) {
                // empty catch block
            }
            return new SelectItem[0];
        }
        catch (Exception err) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_generic"), err.getMessage()), err);
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception tex) {
                // empty catch block
            }
            return new SelectItem[0];
        }
    }

    public void addSelectedUsers(ActionEvent event) {
        UIGenericPicker picker = (UIGenericPicker)event.getComponent().findComponent("picker");
        String[] results = picker.getSelectedResults();
        if (results != null) {
            for (int i = 0; i < results.length; ++i) {
                String authority = results[i];
                boolean foundExisting = false;
                for (int n = 0; n < this.usersForGroup.size(); ++n) {
                    GroupsDialog.UserAuthorityDetails wrapper = this.usersForGroup.get(n);
                    if (!authority.equals(wrapper.getAuthority())) continue;
                    foundExisting = true;
                    break;
                }
                if (foundExisting) continue;
                StringBuilder label = new StringBuilder(48);
                if (!this.getPersonService().personExists(authority)) continue;
                NodeRef ref = this.getPersonService().getPerson(authority);
                String firstName = (String)((Object)this.getNodeService().getProperty(ref, ContentModel.PROP_FIRSTNAME));
                String lastName = (String)((Object)this.getNodeService().getProperty(ref, ContentModel.PROP_LASTNAME));
                label.append(firstName != null ? firstName : "").append(' ').append(lastName != null ? lastName : "");
                GroupsDialog.UserAuthorityDetails userDetails = new GroupsDialog.UserAuthorityDetails(label.toString(), authority);
                this.usersForGroup.add(userDetails);
            }
        }
    }

    public void removeUserSelection(ActionEvent event) {
        GroupsDialog.UserAuthorityDetails wrapper = (GroupsDialog.UserAuthorityDetails)this.usersDataModel.getRowData();
        if (wrapper != null) {
            this.usersForGroup.remove(wrapper);
        }
    }
}

