/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.groups;

import java.text.MessageFormat;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.ui.common.Utils;

public class CreateGroupDialog
extends BaseDialogBean {
    private static final long serialVersionUID = -8074475974375860695L;
    protected String parentGroup;
    protected String parentGroupName;
    protected String name;
    private transient AuthorityService authService;
    private static final String MSG_ERR_EXISTS = "groups_err_exists";
    private static final String MSG_GROUPNAME_LENGTH = "groups_err_group_name_length";
    private static final String MSG_ERR_NAME = "groups_err_group_name";
    private static final String MSG_ROOT_GROUPS = "root_groups";
    private static final String MSG_BUTTON_NEW_GROUP = "new_group";

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.parentGroup = parameters.get("group");
        this.parentGroupName = parameters.get("groupName");
        this.name = null;
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        String groupName = this.getAuthService().getName(AuthorityType.GROUP, this.name);
        if (!this.getAuthService().authorityExists(groupName)) {
            this.getAuthService().createAuthority(AuthorityType.GROUP, this.name);
            if (this.parentGroup != null) {
                this.getAuthService().addAuthority(this.parentGroup, groupName);
            }
        } else {
            Utils.addErrorMessage(Application.getMessage(context, MSG_ERR_EXISTS));
            outcome = null;
            this.isFinished = false;
        }
        return outcome;
    }

    @Override
    public String getFinishButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), MSG_BUTTON_NEW_GROUP);
    }

    @Override
    public String getContainerSubTitle() {
        String subtitle = null;
        subtitle = this.parentGroupName != null ? this.parentGroupName : Application.getMessage(FacesContext.getCurrentInstance(), MSG_ROOT_GROUPS);
        return subtitle;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAuthService(AuthorityService authService) {
        this.authService = authService;
    }

    protected AuthorityService getAuthService() {
        if (this.authService == null) {
            this.authService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAuthorityService();
        }
        return this.authService;
    }

    public void validateGroupName(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        int minGroupNameLength = Application.getClientConfig(context).getMinGroupNameLength();
        String name = ((String)value).trim();
        if (name.length() < minGroupNameLength || name.length() > 100) {
            String err = MessageFormat.format(Application.getMessage(context, MSG_GROUPNAME_LENGTH), minGroupNameLength, 100);
            throw new ValidatorException(new FacesMessage(err));
        }
        if (name.indexOf(34) != -1 || name.indexOf(92) != -1) {
            String err = MessageFormat.format(Application.getMessage(context, MSG_ERR_NAME), "\", \\");
            throw new ValidatorException(new FacesMessage(err));
        }
    }
}

