/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.groups;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.transaction.UserTransaction;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.context.IContextListener;
import org.alfresco.web.app.context.UIContextService;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.dialog.ChangeViewSupport;
import org.alfresco.web.bean.dialog.FilterViewSupport;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.data.DynamicResolver;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.IBreadcrumbHandler;
import org.alfresco.web.ui.common.component.UIActionLink;
import org.alfresco.web.ui.common.component.UIBreadcrumb;
import org.alfresco.web.ui.common.component.UIListItem;
import org.alfresco.web.ui.common.component.UIModeList;
import org.alfresco.web.ui.common.component.data.UIRichList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GroupsDialog
extends BaseDialogBean
implements IContextListener,
FilterViewSupport,
ChangeViewSupport {
    private static final long serialVersionUID = -624617545796275734L;
    public static final String KEY_GROUP = "group";
    public static final String PARAM_GROUP = "group";
    public static final String PARAM_GROUP_NAME = "groupName";
    private transient AuthorityService authService;
    private transient PersonService personService;
    protected UIRichList groupsRichList;
    protected UIRichList usersRichList;
    protected List<Map<String, String>> groups = Collections.emptyList();
    protected String group = null;
    protected String groupName = null;
    protected String viewMode = "icons";
    protected String filterMode = "children";
    protected List<IBreadcrumbHandler> location = null;
    private static final String VIEW_ICONS = "icons";
    private static final String VIEW_DETAILS = "details";
    private static final String FILTER_CHILDREN = "children";
    private static final String FILTER_ALL = "all";
    private static final String LABEL_VIEW_ICONS = "group_icons";
    private static final String LABEL_VIEW_DETAILS = "group_details";
    private static final String LABEL_FILTER_CHILDREN = "group_filter_children";
    private static final String LABEL_FILTER_ALL = "group_filter_all";
    private static final String MSG_ROOT_GROUPS = "root_groups";
    private static final String MSG_CLOSE = "close";
    private static Log logger = LogFactory.getLog(GroupsDialog.class);
    private String groupsSearchCriteria = null;
    private boolean searchAll = false;

    public GroupsDialog() {
        UIContextService.getInstance(FacesContext.getCurrentInstance()).registerBean(this);
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        return null;
    }

    @Override
    public String cancel() {
        this.location = null;
        this.setCurrentGroup(null, null);
        return super.cancel();
    }

    @Override
    public String getContainerSubTitle() {
        String subtitle = null;
        subtitle = this.group != null ? this.groupName : Application.getMessage(FacesContext.getCurrentInstance(), MSG_ROOT_GROUPS);
        return subtitle;
    }

    @Override
    public String getCancelButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), MSG_CLOSE);
    }

    @Override
    public void restored() {
        Object groupToRemove = FacesContext.getCurrentInstance().getExternalContext().getRequestMap().get("group");
        if (groupToRemove != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Removing group '" + groupToRemove + "' from breadcrumb"));
            }
            this.removeFromBreadcrumb((String)groupToRemove);
        }
    }

    @Override
    public Object getActionsContext() {
        return this;
    }

    @Override
    public List<UIListItem> getFilterItems() {
        FacesContext context = FacesContext.getCurrentInstance();
        ArrayList<UIListItem> items = new ArrayList<UIListItem>(2);
        UIListItem item1 = new UIListItem();
        item1.setValue(FILTER_CHILDREN);
        item1.setLabel(Application.getMessage(context, LABEL_FILTER_CHILDREN));
        items.add(item1);
        UIListItem item2 = new UIListItem();
        item2.setValue(FILTER_ALL);
        item2.setLabel(Application.getMessage(context, LABEL_FILTER_ALL));
        items.add(item2);
        return items;
    }

    @Override
    public void filterModeChanged(ActionEvent event) {
        UIModeList filterList = (UIModeList)event.getComponent();
        this.setFilterMode(filterList.getValue().toString());
    }

    @Override
    public String getFilterMode() {
        return this.filterMode;
    }

    @Override
    public void setFilterMode(String filterMode) {
        this.filterMode = filterMode;
        this.contextUpdated();
    }

    @Override
    public List<UIListItem> getViewItems() {
        FacesContext context = FacesContext.getCurrentInstance();
        ArrayList<UIListItem> items = new ArrayList<UIListItem>(2);
        UIListItem item1 = new UIListItem();
        item1.setValue(VIEW_ICONS);
        item1.setLabel(Application.getMessage(context, LABEL_VIEW_ICONS));
        items.add(item1);
        UIListItem item2 = new UIListItem();
        item2.setValue(VIEW_DETAILS);
        item2.setLabel(Application.getMessage(context, LABEL_VIEW_DETAILS));
        items.add(item2);
        return items;
    }

    @Override
    public void viewModeChanged(ActionEvent event) {
        UIModeList viewList = (UIModeList)event.getComponent();
        this.setViewMode(viewList.getValue().toString());
    }

    @Override
    public String getViewMode() {
        return this.viewMode;
    }

    @Override
    public void setViewMode(String viewMode) {
        this.viewMode = viewMode;
    }

    public String getGroup() {
        return this.group;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setAuthService(AuthorityService authService) {
        this.authService = authService;
    }

    private AuthorityService getAuthorityService() {
        if (this.authService == null) {
            this.authService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAuthorityService();
        }
        return this.authService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    private PersonService getPersonService() {
        if (this.personService == null) {
            this.personService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getPersonService();
        }
        return this.personService;
    }

    public UIRichList getGroupsRichList() {
        return this.groupsRichList;
    }

    public void setGroupsRichList(UIRichList groupsRichList) {
        this.groupsRichList = groupsRichList;
    }

    public UIRichList getUsersRichList() {
        return this.usersRichList;
    }

    public void setUsersRichList(UIRichList usersRichList) {
        this.usersRichList = usersRichList;
    }

    public List<IBreadcrumbHandler> getLocation() {
        if (this.location == null) {
            ArrayList<IBreadcrumbHandler> loc = new ArrayList<IBreadcrumbHandler>(8);
            loc.add(new GroupBreadcrumbHandler(null, Application.getMessage(FacesContext.getCurrentInstance(), MSG_ROOT_GROUPS)));
            this.location = loc;
        }
        return this.location;
    }

    public boolean isAllowSearchGroups() {
        return this.group == null;
    }

    public List<Map<String, String>> getGroups() {
        this.displayGroups();
        return this.groups;
    }

    public String getGroupsSearchCriteria() {
        return this.groupsSearchCriteria;
    }

    public String searchGroups() {
        this.group = null;
        this.searchAll = false;
        this.displayGroups();
        return null;
    }

    public String showAllGroups() {
        this.group = null;
        this.searchAll = true;
        this.displayGroups();
        return null;
    }

    private void displayGroups() {
        List authorities;
        this.groupsRichList.setValue(null);
        if (this.group == null) {
            Object search = null;
            if (!this.searchAll) {
                search = this.groupsSearchCriteria == null ? null : (((String)(search = this.groupsSearchCriteria.trim())).length() == 0 ? null : (String)search + "*");
            }
            if (!this.searchAll && search == null) {
                this.groups = Collections.emptyList();
                return;
            }
            if (search != null && ((String)search).startsWith("*")) {
                boolean immediate = this.filterMode.equals(FILTER_CHILDREN);
                Set results = this.authService.findAuthorities(AuthorityType.GROUP, this.group, immediate, (String)search, "APP.DEFAULT");
                authorities = new ArrayList(results);
            } else {
                PagingResults pagedResults = this.authService.getAuthorities(AuthorityType.GROUP, "APP.DEFAULT", (String)search, true, true, new PagingRequest(10000));
                authorities = pagedResults.getPage();
            }
        } else {
            Set results = this.getAuthorityService().getContainedAuthorities(AuthorityType.GROUP, this.group, true);
            authorities = new ArrayList(results);
        }
        this.groups = new ArrayList<Map<String, String>>(authorities.size());
        for (String authority : authorities) {
            HashMap<String, String> authMap = new HashMap<String, String>(8);
            String name = this.authService.getAuthorityDisplayName(authority);
            if (name == null) {
                name = this.authService.getShortName(name);
            }
            authMap.put("name", name);
            authMap.put("id", authority);
            authMap.put("group", authority);
            authMap.put(PARAM_GROUP_NAME, name);
            this.groups.add(authMap);
        }
    }

    public List<Map<String, Object>> getUsers() {
        List<Map<String, Object>> users;
        UserTransaction tx = null;
        try {
            Set authorities;
            FacesContext context = FacesContext.getCurrentInstance();
            tx = Repository.getUserTransaction(context, true);
            tx.begin();
            if (this.group == null) {
                authorities = Collections.emptySet();
            } else {
                boolean immediate = this.filterMode.equals(FILTER_CHILDREN);
                authorities = this.getAuthorityService().getContainedAuthorities(AuthorityType.USER, this.group, immediate);
            }
            users = new ArrayList(authorities.size());
            for (String authority : authorities) {
                HashMap<String, Object> authMap = new HashMap<String, Object>(8);
                String userName = this.getAuthorityService().getShortName(authority);
                authMap.put("userName", userName);
                authMap.put("id", Utils.encode((String)authority));
                authMap.put("name", new AuthorityNamePropertyResolver(userName));
                authMap.put("firstName", new AuthorityPropertyResolver(userName, ContentModel.PROP_FIRSTNAME));
                authMap.put("lastName", new AuthorityPropertyResolver(userName, ContentModel.PROP_LASTNAME));
                users.add(authMap);
            }
            tx.commit();
        }
        catch (Throwable err) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_generic"), err.getMessage()), err);
            users = Collections.emptyList();
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception tex) {
                // empty catch block
            }
        }
        return users;
    }

    protected void setCurrentGroup(String group, String groupName) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Setting current group: " + group));
        }
        this.group = group;
        this.groupName = groupName;
        this.searchAll = false;
        this.contextUpdated();
    }

    public void clickGroup(ActionEvent event) {
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String group = params.get("id");
        if (group != null && group.length() != 0) {
            this.updateUILocation(group);
            this.setGroupsSearchCriteria(null);
        }
    }

    public void setGroupsSearchCriteria(String groupsSearchCriteria) {
        this.groupsSearchCriteria = groupsSearchCriteria;
    }

    public void removeUser(ActionEvent event) {
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String authority = params.get("id");
        if (authority != null && authority.length() != 0) {
            UserTransaction tx = null;
            try {
                FacesContext context = FacesContext.getCurrentInstance();
                tx = Repository.getUserTransaction(context);
                tx.begin();
                this.getAuthorityService().removeAuthority(this.group, authority);
                tx.commit();
                this.contextUpdated();
            }
            catch (Throwable err) {
                Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_generic"), err.getMessage()), err);
                try {
                    if (tx != null) {
                        tx.rollback();
                    }
                }
                catch (Exception tex) {
                    // empty catch block
                }
            }
        }
    }

    protected void updateUILocation(String group) {
        String groupName = this.getAuthorityService().getShortName(group);
        this.location.add(new GroupBreadcrumbHandler(group, groupName));
        this.setCurrentGroup(group, groupName);
    }

    protected void removeFromBreadcrumb(String group) {
        List<IBreadcrumbHandler> location = this.getLocation();
        GroupBreadcrumbHandler handler = (GroupBreadcrumbHandler)location.get(location.size() - 1);
        if (group.equals(handler.Group)) {
            location.remove(location.size() - 1);
            if (location.size() != 0) {
                handler = (GroupBreadcrumbHandler)location.get(location.size() - 1);
                this.setCurrentGroup(handler.Group, handler.Label);
            }
        }
    }

    @Override
    public void contextUpdated() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Invalidating Group Management Components...");
        }
        if (this.groupsRichList != null) {
            this.groupsRichList.setValue(null);
            this.groups = null;
        }
        if (this.usersRichList != null) {
            this.usersRichList.setValue(null);
        }
    }

    @Override
    public void areaChanged() {
    }

    @Override
    public void spaceChanged() {
    }

    public class AuthorityNamePropertyResolver
    implements DynamicResolver {
        private final String authority;
        private String value = null;

        AuthorityNamePropertyResolver(String authority) {
            this.authority = authority;
        }

        public String toString() {
            if (this.value == null) {
                NodeRef ref = GroupsDialog.this.getPersonService().getPerson(this.authority);
                String firstName = (String)((Object)GroupsDialog.this.getNodeService().getProperty(ref, ContentModel.PROP_FIRSTNAME));
                String lastName = (String)((Object)GroupsDialog.this.getNodeService().getProperty(ref, ContentModel.PROP_LASTNAME));
                StringBuilder label = new StringBuilder(48);
                label.append(firstName != null ? firstName : "").append(' ').append(lastName != null ? lastName : "");
                this.value = label.toString();
            }
            return this.value;
        }
    }

    public class AuthorityPropertyResolver
    implements DynamicResolver {
        private final String authority;
        private final QName property;
        private String value = null;

        AuthorityPropertyResolver(String authority, QName property) {
            this.authority = authority;
            this.property = property;
        }

        public String toString() {
            if (this.value == null) {
                NodeRef ref = GroupsDialog.this.getPersonService().getPerson(this.authority);
                this.value = (String)((Object)GroupsDialog.this.getNodeService().getProperty(ref, this.property));
            }
            return this.value;
        }
    }

    public static class UserAuthorityDetails
    implements Serializable {
        private static final long serialVersionUID = 1056255933962068348L;
        private String name;
        private String authority;

        public UserAuthorityDetails(String name, String authority) {
            this.name = name;
            this.authority = authority;
        }

        public String getName() {
            return this.name;
        }

        public String getAuthority() {
            return this.authority;
        }
    }

    private class GroupBreadcrumbHandler
    implements IBreadcrumbHandler {
        private static final long serialVersionUID = 1871876653151036630L;
        public String Group;
        public String Label;

        public GroupBreadcrumbHandler(String group, String label) {
            this.Group = group;
            this.Label = label;
        }

        @Override
        public String toString() {
            return this.Label;
        }

        @Override
        public String navigationOutcome(UIBreadcrumb breadcrumb) {
            GroupsDialog.this.setCurrentGroup(this.Group, this.Label);
            GroupsDialog.this.location = (List)breadcrumb.getValue();
            return null;
        }
    }
}

