/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.ml;

import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.alfresco.service.cmr.ml.MultilingualContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.content.AddContentDialog;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.users.UserPreferencesBean;
import org.springframework.extensions.surf.util.I18NUtil;

public class AddTranslationDialog
extends AddContentDialog {
    private static final long serialVersionUID = 5588241907778464543L;
    private static final String MSG_OK = "ok";
    private transient MultilingualContentService multilingualContentService;
    private UserPreferencesBean userPreferencesBean;
    protected NodeRef mlTranslation;
    private String language;
    private SelectItem[] unusedLanguages;

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.language = null;
        this.mlTranslation = this.browseBean.getDocument().getNodeRef();
        this.setFileName(null);
        this.unusedLanguages = null;
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        outcome = super.finishImpl(context, outcome);
        this.getMultilingualContentService().addTranslation(this.createdNode, this.mlTranslation, I18NUtil.parseLocale((String)this.language));
        return "dialog:close:browse";
    }

    @Override
    public String cancel() {
        super.cancel();
        return this.getDefaultFinishOutcome();
    }

    @Override
    public boolean getFinishButtonDisabled() {
        return this.author == null || this.author.length() < 1 || this.language == null;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setUnusedLanguages(SelectItem[] unusedLanguages) {
        this.unusedLanguages = unusedLanguages;
    }

    public SelectItem[] getUnusedLanguages() {
        if (this.unusedLanguages == null) {
            this.unusedLanguages = this.userPreferencesBean.getAvailablesContentFilterLanguages(this.mlTranslation, false);
        }
        return this.unusedLanguages;
    }

    public MultilingualContentService getMultilingualContentService() {
        if (this.multilingualContentService == null) {
            this.multilingualContentService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getMultilingualContentService();
        }
        return this.multilingualContentService;
    }

    public void setMultilingualContentService(MultilingualContentService multilingualContentService) {
        this.multilingualContentService = multilingualContentService;
    }

    public UserPreferencesBean getUserPreferencesBean() {
        return this.userPreferencesBean;
    }

    public void setUserPreferencesBean(UserPreferencesBean userPreferencesBean) {
        this.userPreferencesBean = userPreferencesBean;
    }

    @Override
    public String getFinishButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), MSG_OK);
    }
}

