/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.ml;

import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.ml.MultilingualContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.users.UserPreferencesBean;
import org.springframework.extensions.surf.util.I18NUtil;

public class AddTranslationWithoutContentDialog
extends BaseDialogBean {
    private static final long serialVersionUID = -1252453783397533792L;
    private transient MultilingualContentService multilingualContentService;
    private UserPreferencesBean userPreferencesBean;
    protected NodeRef newTranslation;
    private String title;
    private String description;
    private String author;
    private String language;
    private boolean showOtherProperties;

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.title = null;
        this.description = null;
        this.author = null;
        this.language = null;
        this.showOtherProperties = true;
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        NodeRef refNode = this.browseBean.getDocument().getNodeRef();
        Locale locale = I18NUtil.parseLocale((String)this.language);
        this.newTranslation = this.getMultilingualContentService().addEmptyTranslation(refNode, null, locale);
        this.getNodeService().setProperty(this.newTranslation, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)this.description));
        this.getNodeService().setProperty(this.newTranslation, ContentModel.PROP_AUTHOR, (Serializable)((Object)this.author));
        this.getNodeService().setProperty(this.newTranslation, ContentModel.PROP_TITLE, (Serializable)((Object)this.title));
        if (this.showOtherProperties) {
            this.browseBean.setDocument(new Node(this.newTranslation));
            return "dialog:setContentProperties";
        }
        return "browse";
    }

    public void setUserPreferencesBean(UserPreferencesBean userPreferencesBean) {
        this.userPreferencesBean = userPreferencesBean;
    }

    public void setMultilingualContentService(MultilingualContentService multilingualContentService) {
        this.multilingualContentService = multilingualContentService;
    }

    private MultilingualContentService getMultilingualContentService() {
        if (this.multilingualContentService == null) {
            this.multilingualContentService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getMultilingualContentService();
        }
        return this.multilingualContentService;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public SelectItem[] getUnusedLanguages() {
        return this.userPreferencesBean.getAvailablesContentFilterLanguages(this.browseBean.getDocument().getNodeRef(), false);
    }

    public boolean isShowOtherProperties() {
        return this.showOtherProperties;
    }

    public void setShowOtherProperties(boolean showOtherProperties) {
        this.showOtherProperties = showOtherProperties;
    }
}

