/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.ml;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.ml.ContentFilterLanguagesService;
import org.alfresco.service.cmr.ml.EditionService;
import org.alfresco.service.cmr.ml.MultilingualContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.DownloadContentServlet;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.ml.MultilingualUtils;
import org.alfresco.web.bean.ml.SingleEditionBean;
import org.alfresco.web.bean.repository.MapNode;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.UIPanel;

public class MultilingualManageDialog
extends BaseDialogBean {
    private static final long serialVersionUID = 4168804472130450812L;
    private final String MSG_MANAGE_DETAILS_FOR = "manage_multilingual_details_for";
    private static final String MSG_CURRENT = "current";
    private static final String ML_VERSION_PANEL_ID = "ml-versions-panel";
    private static final String MSG_CLOSE = "close";
    private static final String MSG_LEFT_QUOTE = "left_qoute";
    private static final String MSG_RIGHT_QUOTE = "right_quote";
    protected Map<String, Boolean> panels = new HashMap<String, Boolean>(4, 1.0f);
    private transient MultilingualContentService multilingualContentService;
    private transient ContentFilterLanguagesService contentFilterLanguagesService;
    private transient EditionService editionService;
    private transient VersionService versionService;
    private Node translationDocument;
    private int currentEditionCursorPosition;
    private List<SingleEditionBean> editionHistory = null;

    public Node getDocument() {
        return this.getNode();
    }

    public Node getNode() {
        return this.browseBean.getDocument();
    }

    public void setMultilingualContentService(MultilingualContentService multilingualContentService) {
        this.multilingualContentService = multilingualContentService;
    }

    protected MultilingualContentService getMultilingualContentService() {
        if (this.multilingualContentService == null) {
            this.multilingualContentService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getMultilingualContentService();
        }
        return this.multilingualContentService;
    }

    public void setContentFilterLanguagesService(ContentFilterLanguagesService contentFilterLanguagesService) {
        this.contentFilterLanguagesService = contentFilterLanguagesService;
    }

    protected ContentFilterLanguagesService getContentFilterLanguagesService() {
        if (this.contentFilterLanguagesService == null) {
            this.contentFilterLanguagesService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getContentFilterLanguagesService();
        }
        return this.contentFilterLanguagesService;
    }

    public void setEditionService(EditionService editionService) {
        this.editionService = editionService;
    }

    protected EditionService getEditionService() {
        if (this.editionService == null) {
            this.editionService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getEditionService();
        }
        return this.editionService;
    }

    public void setVersionService(VersionService versionService) {
        this.versionService = versionService;
    }

    protected VersionService getVersionService() {
        if (this.versionService == null) {
            this.versionService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getVersionService();
        }
        return this.versionService;
    }

    public void setTranslationDocument(Node node) {
        this.translationDocument = node;
    }

    public Map<String, Boolean> getPanels() {
        return this.panels;
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        return null;
    }

    @Override
    public String getContainerTitle() {
        FacesContext fc = FacesContext.getCurrentInstance();
        return Application.getMessage(fc, "manage_multilingual_details_for") + " " + Application.getMessage(fc, MSG_LEFT_QUOTE) + this.getDocument().getName() + Application.getMessage(fc, MSG_RIGHT_QUOTE);
    }

    @Override
    public String getCancelButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), MSG_CLOSE);
    }

    public List getTranslations() {
        Map translationsMap;
        ArrayList<MapNode> translations = new ArrayList<MapNode>();
        Node document = this.getDocument();
        boolean canNewEdtion = MultilingualUtils.canStartNewEditon(document, FacesContext.getCurrentInstance());
        if ((document.hasAspect(ContentModel.ASPECT_MULTILINGUAL_DOCUMENT) || ContentModel.TYPE_MULTILINGUAL_CONTAINER.equals((Object)document.getType())) && (translationsMap = this.getMultilingualContentService().getTranslations(this.getDocument().getNodeRef())) != null && translationsMap.size() > 0) {
            for (Map.Entry entry : translationsMap.entrySet()) {
                NodeRef nodeRef = (NodeRef)entry.getValue();
                MapNode mapNode = new MapNode(nodeRef);
                Locale locale = (Locale)this.getNodeService().getProperty(nodeRef, ContentModel.PROP_LOCALE);
                String lgge = locale != null ? this.getContentFilterLanguagesService().convertToNewISOCode(locale.getLanguage()).toUpperCase() : null;
                mapNode.put("name", (Object)this.getNodeService().getProperty(nodeRef, ContentModel.PROP_NAME));
                mapNode.put("language", (Object)lgge);
                mapNode.put("url", (Object)DownloadContentServlet.generateBrowserURL(nodeRef, mapNode.getName()));
                boolean isEmpty = new Boolean(this.getNodeService().hasAspect(nodeRef, ContentModel.ASPECT_MULTILINGUAL_EMPTY_TRANSLATION));
                mapNode.put("notEmpty", (Object)(!isEmpty ? 1 : 0));
                mapNode.put("userHasRight", (Object)new Boolean(canNewEdtion && !isEmpty));
                translations.add(mapNode);
            }
        }
        return translations;
    }

    public List getEmptyListAndInitEditions() {
        ArrayList<String> panelsToRemove = new ArrayList<String>();
        for (Map.Entry<String, Boolean> panel : this.panels.entrySet()) {
            if (!panel.getKey().startsWith(ML_VERSION_PANEL_ID)) continue;
            panelsToRemove.add(panel.getKey());
        }
        for (String panelId : panelsToRemove) {
            this.panels.remove(panelId);
        }
        this.initEditionHistory();
        this.currentEditionCursorPosition = -1;
        return new ArrayList(0);
    }

    public int getEditionSize() {
        return this.editionHistory.size();
    }

    public SingleEditionBean getNextSingleEditionBean() {
        ++this.currentEditionCursorPosition;
        return this.getCurrentSingleEditionBean();
    }

    public SingleEditionBean getCurrentSingleEditionBean() {
        if (this.currentEditionCursorPosition < this.getEditionSize()) {
            return this.editionHistory.get(this.currentEditionCursorPosition);
        }
        return null;
    }

    public void resetMLDocument(ActionEvent event) {
        this.browseBean.setupCommonBindingProperties(this.translationDocument);
        this.browseBean.setDocument(this.translationDocument);
    }

    public void removeTemplate(ActionEvent event) {
        try {
            this.getNodeService().setProperty(this.getNode().getNodeRef(), ContentModel.PROP_TEMPLATE, null);
            this.getNodeService().removeAspect(this.getNode().getNodeRef(), ContentModel.ASPECT_TEMPLATABLE);
            this.getNode().reset();
        }
        catch (Exception e) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_generic"), e.getMessage()), e);
        }
    }

    public void expandPanel(ActionEvent event) {
        String id;
        if (event instanceof UIPanel.ExpandedEvent) {
            id = event.getComponent().getId();
            if (id.startsWith("no-")) {
                id = id.substring(3);
            }
            this.panels.put(id, ((UIPanel.ExpandedEvent)event).State);
        }
        if ((id = event.getComponent().getId()).startsWith(ML_VERSION_PANEL_ID)) {
            this.currentEditionCursorPosition = Integer.parseInt(id.substring(ML_VERSION_PANEL_ID.length())) - 1;
        }
    }

    public Node getDocumentMlContainer() {
        Node currentNode = this.getNode();
        if (ContentModel.TYPE_MULTILINGUAL_CONTAINER.equals((Object)currentNode.getType())) {
            return currentNode;
        }
        NodeRef nodeRef = this.getNode().getNodeRef();
        return new Node(this.getMultilingualContentService().getTranslationContainer(nodeRef));
    }

    private List<SingleEditionBean> initEditionHistory() {
        NodeRef mlContainer = this.getDocumentMlContainer().getNodeRef();
        ArrayList orderedEditionList = new ArrayList(this.getEditionService().getEditions(mlContainer).getAllVersions());
        this.editionHistory = new ArrayList<SingleEditionBean>(orderedEditionList.size());
        boolean firstEdition = true;
        for (Version edition : orderedEditionList) {
            SingleEditionBean editionBean = new SingleEditionBean();
            MapNode clientEdition = new MapNode(edition.getFrozenStateNodeRef());
            String editionLabel = edition.getVersionLabel();
            if (firstEdition) {
                editionLabel = editionLabel + " (" + Application.getMessage(FacesContext.getCurrentInstance(), MSG_CURRENT) + ")";
            }
            clientEdition.put("editionLabel", (Object)editionLabel);
            clientEdition.put("editionNotes", (Object)edition.getDescription());
            clientEdition.put("editionAuthor", (Object)edition.getCreator());
            clientEdition.put("editionDate", (Object)edition.getCreatedDate());
            editionBean.setEdition(clientEdition);
            ArrayList<VersionHistory> translationHistories = null;
            if (firstEdition) {
                Map translations = this.getMultilingualContentService().getTranslations(mlContainer);
                translationHistories = new ArrayList<VersionHistory>(translations.size());
                for (NodeRef translation : translations.values()) {
                    translationHistories.add(this.getVersionService().getVersionHistory(translation));
                }
            } else {
                translationHistories = this.getEditionService().getVersionedTranslations(edition);
            }
            for (VersionHistory versionHistory : translationHistories) {
                for (Version checkVersion : versionHistory.getAllVersions()) {
                    NodeRef frozenStateNodeRef = checkVersion.getFrozenStateNodeRef();
                    if (!frozenStateNodeRef.getStoreRef().getIdentifier().equals("lightWeightVersionStore")) continue;
                    NodeRef versionedNodeRef = checkVersion.getVersionedNodeRef();
                    versionHistory = this.versionService.getVersionHistory(versionedNodeRef);
                    break;
                }
                ArrayList orderedVersions = new ArrayList(versionHistory.getAllVersions());
                Version lastVersion = (Version)orderedVersions.get(0);
                Map lastVersionProperties = this.getEditionService().getVersionedMetadatas(lastVersion);
                Locale language = (Locale)lastVersionProperties.get(ContentModel.PROP_LOCALE);
                MapNode clientLastVersion = new MapNode(lastVersion.getFrozenStateNodeRef());
                clientLastVersion.put("versionName", lastVersionProperties.get(ContentModel.PROP_NAME));
                clientLastVersion.put("versionDescription", (Object)this.getNodeService().getProperty(lastVersion.getFrozenStateNodeRef(), ContentModel.PROP_DESCRIPTION));
                clientLastVersion.put("versionAuthor", lastVersionProperties.get(ContentModel.PROP_AUTHOR));
                clientLastVersion.put("versionCreatedDate", lastVersionProperties.get(ContentModel.PROP_CREATED));
                clientLastVersion.put("versionModifiedDate", lastVersionProperties.get(ContentModel.PROP_MODIFIED));
                clientLastVersion.put("versionLanguage", (Object)this.getContentFilterLanguagesService().convertToNewISOCode(language.getLanguage()).toUpperCase());
                if (this.getNodeService().hasAspect(lastVersion.getFrozenStateNodeRef(), ContentModel.ASPECT_MULTILINGUAL_EMPTY_TRANSLATION)) {
                    clientLastVersion.put("versionUrl", (Object)null);
                } else {
                    clientLastVersion.put("versionUrl", (Object)DownloadContentServlet.generateBrowserURL(lastVersion.getFrozenStateNodeRef(), clientLastVersion.getName()));
                }
                editionBean.addTranslations(clientLastVersion);
            }
            this.editionHistory.add(editionBean);
            firstEdition = false;
        }
        return this.editionHistory;
    }

    @Override
    protected String getDefaultCancelOutcome() {
        this.resetMLDocument(null);
        return "dialog:close";
    }
}

