/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.preview;

import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.web.scripts.FileTypeImageUtils;
import org.alfresco.service.cmr.repository.FileTypeImageSize;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.TemplateImageResolver;
import org.alfresco.web.bean.BrowseBean;
import org.alfresco.web.bean.NavigationBean;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;

public abstract class BasePreviewBean
extends BaseDialogBean {
    protected BrowseBean browseBean;
    protected NavigationBean navigator;
    protected NodeRef template;
    protected TemplateImageResolver imageResolver = new TemplateImageResolver(){

        public String resolveImagePathForName(String filename, FileTypeImageSize size) {
            return FileTypeImageUtils.getFileTypeImage((FacesContext)FacesContext.getCurrentInstance(), (String)filename, (FileTypeImageSize)size);
        }
    };

    @Override
    public void setBrowseBean(BrowseBean browseBean) {
        this.browseBean = browseBean;
    }

    @Override
    public void setNavigator(NavigationBean navigator) {
        this.navigator = navigator;
    }

    public abstract Node getNode();

    public String getId() {
        return this.getNode().getId();
    }

    public String getName() {
        return this.getNode().getName();
    }

    public abstract Map getTemplateModel();

    public NodeRef getTemplateRef() {
        return this.template;
    }

    public String getTemplate() {
        return this.template != null ? this.template.getId() : null;
    }

    public void setTemplate(String template) {
        if (template != null && !template.equals("none")) {
            this.template = new NodeRef(Repository.getStoreRef(), template);
        }
    }

    private int findNextPreviewNode(List<Node> nodes, int start) {
        Node next;
        int i;
        for (i = start; i < nodes.size(); ++i) {
            next = nodes.get(i);
            if (!next.hasAspect(ContentModel.ASPECT_TEMPLATABLE)) continue;
            return i;
        }
        for (i = 0; i < start - 1; ++i) {
            next = nodes.get(i);
            if (!next.hasAspect(ContentModel.ASPECT_TEMPLATABLE)) continue;
            return i;
        }
        return -1;
    }

    private int findPrevPreviewNode(List<Node> nodes, int start) {
        Node next;
        int i;
        for (i = start; i >= 0; --i) {
            next = nodes.get(i);
            if (!next.hasAspect(ContentModel.ASPECT_TEMPLATABLE)) continue;
            return i;
        }
        for (i = nodes.size() - 1; i > start; --i) {
            next = nodes.get(i);
            if (!next.hasAspect(ContentModel.ASPECT_TEMPLATABLE)) continue;
            return i;
        }
        return -1;
    }
}

