/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.preview;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.dialog.NavigationSupport;
import org.alfresco.web.bean.preview.BasePreviewBean;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.ui.common.component.UIActionLink;

public class DocumentPreviewBean
extends BasePreviewBean
implements NavigationSupport {
    private static final long serialVersionUID = 2476545866710371333L;
    private static final String MSG_PREVIEW_OF = "preview_of";
    private static final String MSG_CLOSE = "close";
    private static final String MSG_LEFT_QUOTE = "left_qoute";
    private static final String MSG_RIGHT_QUOTE = "right_quote";

    @Override
    public Node getNode() {
        return this.browseBean.getDocument();
    }

    @Override
    public Map getTemplateModel() {
        HashMap<String, Object> model = new HashMap<String, Object>(3, 1.0f);
        model.put("document", this.getNode().getNodeRef());
        model.put("space", this.navigator.getCurrentNode().getNodeRef());
        model.put("imageresolver", this.imageResolver);
        return model;
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        return null;
    }

    @Override
    public String getCurrentItemId() {
        return this.getId();
    }

    @Override
    public String getOutcome() {
        return "dialog:close:dialog:previewContent";
    }

    @Override
    public void nextItem(ActionEvent event) {
        List<Node> nodes;
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String id = params.get("id");
        if (id != null && id.length() != 0 && (nodes = this.browseBean.getContent()).size() > 1) {
            for (int i = 0; i < nodes.size(); ++i) {
                if (!id.equals(nodes.get(i).getId())) continue;
                Node next = i != nodes.size() - 1 ? nodes.get(i + 1) : nodes.get(0);
                this.browseBean.setupContentAction(next.getId(), false);
                break;
            }
        }
    }

    @Override
    public void previousItem(ActionEvent event) {
        List<Node> nodes;
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String id = params.get("id");
        if (id != null && id.length() != 0 && (nodes = this.browseBean.getContent()).size() > 1) {
            for (int i = 0; i < nodes.size(); ++i) {
                if (!id.equals(nodes.get(i).getId())) continue;
                Node previous = i != 0 ? nodes.get(i - 1) : nodes.get(nodes.size() - 1);
                this.browseBean.setupContentAction(previous.getId(), false);
                break;
            }
        }
    }

    @Override
    public String getContainerTitle() {
        FacesContext fc = FacesContext.getCurrentInstance();
        return Application.getMessage(fc, MSG_PREVIEW_OF) + " " + Application.getMessage(fc, MSG_LEFT_QUOTE) + this.getName() + Application.getMessage(fc, MSG_RIGHT_QUOTE);
    }

    @Override
    public String getCancelButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), MSG_CLOSE);
    }
}

