/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.repository;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;

public final class DataDictionary
implements Serializable {
    private static final long serialVersionUID = -4922351610793587592L;
    private transient DictionaryService dictionaryService;
    private Map<QName, TypeDefinition> types = new HashMap<QName, TypeDefinition>(11, 1.0f);

    public DataDictionary(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    private DictionaryService getDictionaryService() {
        if (this.dictionaryService == null) {
            this.dictionaryService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getDictionaryService();
        }
        return this.dictionaryService;
    }

    public TypeDefinition getTypeDef(QName type) {
        TypeDefinition typeDef = this.types.get(type);
        if (typeDef == null && (typeDef = this.getDictionaryService().getType(type)) != null) {
            this.types.put(type, typeDef);
        }
        return typeDef;
    }

    public TypeDefinition getTypeDef(QName type, Collection<QName> optionalAspects) {
        return this.getDictionaryService().getAnonymousType(type, optionalAspects);
    }

    public PropertyDefinition getPropertyDefinition(Node node, String property) {
        PropertyDefinition propDef = null;
        TypeDefinition typeDef = this.getTypeDef(node.getType(), node.getAspects());
        if (typeDef != null) {
            Map properties = typeDef.getProperties();
            propDef = (PropertyDefinition)properties.get(Repository.resolveToQName(property));
        }
        return propDef;
    }

    public AssociationDefinition getAssociationDefinition(Node node, String association) {
        AssociationDefinition assocDef = null;
        TypeDefinition typeDef = this.getTypeDef(node.getType(), node.getAspects());
        if (typeDef != null) {
            Map assocs = typeDef.getAssociations();
            assocDef = (AssociationDefinition)assocs.get(Repository.resolveToQName(association));
        }
        return assocDef;
    }
}

