/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.repository;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.bean.repository.Node;

public class MapNode
extends Node
implements Map<String, Object> {
    private static final long serialVersionUID = 4051322327734433079L;
    private boolean propsInitialised = false;

    public MapNode(NodeRef nodeRef) {
        super(nodeRef);
    }

    public MapNode(NodeRef nodeRef, NodeService nodeService, boolean initProps) {
        super(nodeRef);
        if (initProps) {
            this.getProperties();
        }
    }

    public MapNode(NodeRef nodeRef, NodeService nodeService, Map<QName, Serializable> props) {
        super(nodeRef);
        for (QName qname : props.keySet()) {
            Serializable propValue = props.get(qname);
            this.properties.put(qname.toString(), propValue);
        }
        this.propsRetrieved = true;
    }

    @Override
    public void clear() {
        this.getProperties().clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getProperties().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getProperties().containsKey(value);
    }

    @Override
    public Set entrySet() {
        return this.getProperties().entrySet();
    }

    @Override
    public Object get(Object key) {
        Object obj = null;
        Map<String, Object> props = this.getProperties();
        if (!this.propsInitialised) {
            props.put("id", this.getId());
            props.put("name", this.getName());
            props.put("nodeRef", this.getNodeRef());
            props.put("nodeRefAsString", this.getNodeRefAsString());
            this.propsInitialised = true;
        }
        if (key.equals("properties")) {
            return props;
        }
        return props.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.getProperties().isEmpty();
    }

    @Override
    public Set keySet() {
        return this.getProperties().keySet();
    }

    @Override
    public Object put(String key, Object value) {
        return this.getProperties().put(key, value);
    }

    @Override
    public void putAll(Map t) {
        this.getProperties().putAll(t);
    }

    @Override
    public Object remove(Object key) {
        return this.getProperties().remove(key);
    }

    @Override
    public int size() {
        return this.getProperties().size();
    }

    @Override
    public void reset() {
        super.reset();
        this.propsInitialised = false;
    }

    @Override
    public Collection values() {
        return this.getProperties().values();
    }
}

