/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.repository;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.transaction.UserTransaction;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.configuration.ConfigurableService;
import org.alfresco.repo.content.encoding.ContentCharsetFinder;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.repo.content.metadata.MetadataExtracter;
import org.alfresco.repo.content.metadata.MetadataExtracterRegistry;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockStatus;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.PathUtil;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.NavigationBean;
import org.alfresco.web.bean.repository.MapNode;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.IBreadcrumbHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.jsf.FacesContextUtils;

public final class Repository {
    public static final String ERROR_NODEREF = "error_noderef";
    public static final String ERROR_GENERIC = "error_generic";
    public static final String ERROR_NOHOME = "error_homespace";
    public static final String ERROR_SEARCH = "error_search";
    public static final String ERROR_QUERY = "error_search_query";
    public static final String ERROR_EXISTS = "error_exists";
    private static final String METADATA_EXTACTER_REGISTRY = "metadataExtracterRegistry";
    private static Log logger = LogFactory.getLog(Repository.class);
    private static StoreRef storeRef = null;
    private static NamespaceService namespaceService = null;
    private static ServiceRegistry serviceRegistry = null;

    private Repository() {
    }

    public static StoreRef getStoreRef() {
        return storeRef;
    }

    public static StoreRef getStoreRef(ServletContext context) {
        storeRef = Application.getRepositoryStoreRef(context);
        return storeRef;
    }

    public static NodeRef getCompanyRoot(final FacesContext context) {
        final String currentUserName = Application.getCurrentUser(context).getUserName();
        return (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                ServiceRegistry sr = Repository.getServiceRegistry(context);
                TenantService tenantService = (TenantService)FacesContextUtils.getRequiredWebApplicationContext((FacesContext)context).getBean("tenantService");
                StoreRef storeRef = tenantService.getName(currentUserName, Repository.getStoreRef());
                String rootPath = Application.getRootPath(context);
                return Repository.getCompanyRoot(sr.getNodeService(), sr.getSearchService(), sr.getNamespaceService(), storeRef, rootPath);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    public static NodeRef getCompanyRoot(NodeService nodeService, SearchService searchService, NamespaceService namespaceService, StoreRef storeRef, String rootPath) {
        if (!nodeService.exists(storeRef)) {
            throw new AlfrescoRuntimeException("Store not created prior to application startup: " + storeRef);
        }
        NodeRef rootNodeRef = nodeService.getRootNode(storeRef);
        if (rootPath == null) {
            throw new AlfrescoRuntimeException("Root path has not been configured");
        }
        List nodes = searchService.selectNodes(rootNodeRef, rootPath, null, (NamespacePrefixResolver)namespaceService, false);
        if (nodes.size() == 0) {
            throw new AlfrescoRuntimeException("Root path not created prior to application startup: " + rootPath);
        }
        return (NodeRef)nodes.get(0);
    }

    public static String getNameForNode(NodeService nodeService, NodeRef ref) {
        String name = null;
        if (nodeService.exists(ref)) {
            Serializable nameProp = nodeService.getProperty(ref, ContentModel.PROP_NAME);
            if (nameProp != null) {
                name = nameProp.toString();
            } else {
                QName qname = nodeService.getPrimaryParent(ref).getQName();
                if (qname != null) {
                    name = qname.getLocalName();
                }
            }
        }
        return name;
    }

    public static String getNameForCategoryNode(NodeService nodeService, NodeRef ref) {
        String name = null;
        if (nodeService.exists(ref)) {
            Path path = nodeService.getPath(ref);
            name = Repository.getNamePath(nodeService, path, null, "/", null);
        }
        return name;
    }

    public static String escapeQName(QName qName) {
        String string = qName.toString();
        StringBuilder buf = new StringBuilder(string.length() + 4);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '{' || c == '}' || c == ':' || c == '-') {
                buf.append('\\');
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static Boolean isNodeLocked(Node node, LockService lockService) {
        LockStatus lockStatus;
        Boolean locked = Boolean.FALSE;
        if (node.hasAspect(ContentModel.ASPECT_LOCKABLE) && ((lockStatus = lockService.getLockStatus(node.getNodeRef())) == LockStatus.LOCKED || lockStatus == LockStatus.LOCK_OWNER)) {
            locked = Boolean.TRUE;
        }
        return locked;
    }

    public static Boolean isNodeOwnerLocked(Node node, LockService lockService) {
        Boolean locked = Boolean.FALSE;
        if (node.hasAspect(ContentModel.ASPECT_LOCKABLE) && lockService.getLockStatus(node.getNodeRef()) == LockStatus.LOCK_OWNER) {
            locked = Boolean.TRUE;
        }
        return locked;
    }

    public static String getDisplayPath(Path path) {
        return Repository.getDisplayPath(path, false);
    }

    public static String getDisplayPath(Path path, boolean showLeaf) {
        return PathUtil.getDisplayPath((Path)path, (boolean)showLeaf);
    }

    public static String getNamePath(NodeService nodeService, Path path, NodeRef rootNode, String separator, String prefix) {
        boolean foundRoot;
        StringBuilder buf = new StringBuilder(128);
        boolean bl = foundRoot = rootNode == null;
        if (prefix != null) {
            buf.append(prefix);
        }
        for (int i = 1; i < path.size(); ++i) {
            Path.Element element = path.get(i);
            String elementString = null;
            if (element instanceof Path.ChildAssocElement) {
                ChildAssociationRef elementRef = ((Path.ChildAssocElement)element).getRef();
                if (elementRef.getParentRef() != null) {
                    if (foundRoot) {
                        Serializable nameProp = nodeService.getProperty(elementRef.getChildRef(), ContentModel.PROP_NAME);
                        elementString = nameProp != null ? nameProp.toString() : element.getElementString();
                    }
                    foundRoot = foundRoot || elementRef.getChildRef().equals((Object)rootNode);
                }
            } else {
                elementString = element.getElementString();
            }
            if (elementString == null) continue;
            buf.append(separator);
            buf.append(elementString);
        }
        return buf.toString();
    }

    public static void setupBreadcrumbLocation(FacesContext context, NavigationBean navBean, List<IBreadcrumbHandler> location, NodeRef node) {
        location.clear();
        NodeService nodeService = Repository.getServiceRegistry(context).getNodeService();
        DictionaryService dictionaryService = Repository.getServiceRegistry(context).getDictionaryService();
        PermissionService permsService = Repository.getServiceRegistry(context).getPermissionService();
        String nodeName = Repository.getNameForNode(nodeService, node);
        NavigationBean navigationBean = navBean;
        navigationBean.getClass();
        location.add(navigationBean.new NavigationBean.NavigationBreadcrumbHandler(node, nodeName));
        NodeRef parent = nodeService.getPrimaryParent(node).getParentRef();
        while (parent != null && permsService.hasPermission(parent, "Read") == AccessStatus.ALLOWED) {
            QName parentType;
            NodeRef grandParent = nodeService.getPrimaryParent(parent).getParentRef();
            if (grandParent != null && dictionaryService.isSubClass(parentType = nodeService.getType(parent), ContentModel.TYPE_FOLDER)) {
                String parentName = Repository.getNameForNode(nodeService, parent);
                NavigationBean navigationBean2 = navBean;
                navigationBean2.getClass();
                location.add(0, navigationBean2.new NavigationBean.NavigationBreadcrumbHandler(parent, parentName));
            }
            parent = grandParent;
        }
    }

    public static String getNamePathEx(FacesContext context, final Path path, final NodeRef rootNode, final String separator, final String prefix) {
        String result = null;
        RetryingTransactionHelper transactionHelper = Repository.getRetryingTransactionHelper(context);
        transactionHelper.setMaxRetries(1);
        final NodeService runtimeNodeService = (NodeService)FacesContextUtils.getRequiredWebApplicationContext((FacesContext)context).getBean("nodeService");
        result = (String)transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

            public String execute() throws Throwable {
                return Repository.getNamePath(runtimeNodeService, path, rootNode, separator, prefix);
            }
        });
        return result;
    }

    public static String getMimeTypeForFileName(FacesContext context, String filename) {
        return Repository.getMimeTypeForFile(context, filename, null);
    }

    public static String getMimeTypeForFile(FacesContext context, String filename, File file) {
        String mimetype = "application/octet-stream";
        MimetypeService mimetypeService = Repository.getServiceRegistry(context).getMimetypeService();
        if (file != null) {
            try {
                FileContentReader reader = new FileContentReader(file);
                mimetype = mimetypeService.guessMimetype(filename, (ContentReader)reader);
                return mimetype;
            }
            catch (Throwable t) {
                logger.warn((Object)"Error identifying mimetype from file contents ", t);
            }
        }
        mimetype = mimetypeService.guessMimetype(filename);
        return mimetype;
    }

    public static UserTransaction getUserTransaction(FacesContext context) {
        TransactionService transactionService = Repository.getServiceRegistry(context).getTransactionService();
        return transactionService.getUserTransaction();
    }

    public static RetryingTransactionHelper getRetryingTransactionHelper(FacesContext context) {
        TransactionService transactionService = Repository.getServiceRegistry(context).getTransactionService();
        return transactionService.getRetryingTransactionHelper();
    }

    public static UserTransaction getUserTransaction(FacesContext context, boolean readonly) {
        TransactionService transactionService = Repository.getServiceRegistry(context).getTransactionService();
        return transactionService.getUserTransaction(readonly);
    }

    public static ServiceRegistry getServiceRegistry(FacesContext context) {
        if (serviceRegistry == null) {
            serviceRegistry = (ServiceRegistry)FacesContextUtils.getRequiredWebApplicationContext((FacesContext)context).getBean("ServiceRegistry");
        }
        return serviceRegistry;
    }

    public static ServiceRegistry getServiceRegistry(ServletContext context) {
        if (serviceRegistry == null) {
            serviceRegistry = (ServiceRegistry)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)context).getBean("ServiceRegistry");
        }
        return serviceRegistry;
    }

    public static ConfigurableService getConfigurableService(FacesContext context) {
        return (ConfigurableService)FacesContextUtils.getRequiredWebApplicationContext((FacesContext)context).getBean("ConfigurableService");
    }

    public static MetadataExtracterRegistry getMetadataExtracterRegistry(FacesContext context) {
        return (MetadataExtracterRegistry)FacesContextUtils.getRequiredWebApplicationContext((FacesContext)context).getBean(METADATA_EXTACTER_REGISTRY);
    }

    public static boolean extractMetadata(FacesContext context, ContentReader reader, Map<QName, Serializable> destination) {
        String mimetype = reader.getMimetype();
        if (mimetype == null) {
            throw new AlfrescoRuntimeException("The content reader mimetype must be set: " + reader);
        }
        MetadataExtracter extracter = Repository.getMetadataExtracterRegistry(context).getExtracter(mimetype);
        if (extracter == null) {
            return false;
        }
        try {
            extracter.extract(reader, destination);
            return true;
        }
        catch (Throwable e) {
            logger.warn((Object)("Metadata extraction failed: \n   reader: " + reader + "\n" + "   extracter: " + extracter));
            return false;
        }
    }

    public static String guessEncoding(FacesContext context, InputStream is, String mimetype) {
        ContentCharsetFinder charsetFinder = Repository.getServiceRegistry(context).getMimetypeService().getContentCharsetFinder();
        Charset charset = charsetFinder.getCharset(is, mimetype);
        return charset.name();
    }

    public static List<Node> getUsers(FacesContext context, NodeService nodeService, SearchService searchService) {
        PersonService personService = (PersonService)FacesContextUtils.getRequiredWebApplicationContext((FacesContext)context).getBean("personService");
        return Repository.getUsers(context, nodeService, personService);
    }

    public static List<Node> getUsers(FacesContext context, NodeService nodeService, PersonService personService) {
        List<Node> personNodes = null;
        UserTransaction tx = null;
        try {
            tx = Repository.getUserTransaction(context, true);
            tx.begin();
            NodeRef peopleRef = personService.getPeopleContainer();
            List childRefs = nodeService.getChildAssocs(peopleRef);
            personNodes = new ArrayList(childRefs.size());
            for (ChildAssociationRef ref : childRefs) {
                NodeRef nodeRef = ref.getChildRef();
                if (!nodeService.getType(nodeRef).equals((Object)ContentModel.TYPE_PERSON)) continue;
                MapNode node = new MapNode(nodeRef);
                Map<String, Object> props = node.getProperties();
                String firstName = (String)props.get("firstName");
                String lastName = (String)props.get("lastName");
                props.put("fullName", (firstName != null ? firstName : "") + ' ' + (lastName != null ? lastName : ""));
                NodeRef homeFolderNodeRef = (NodeRef)props.get("homeFolder");
                if (homeFolderNodeRef != null) {
                    props.put("homeSpace", homeFolderNodeRef);
                }
                personNodes.add(node);
            }
            tx.commit();
        }
        catch (InvalidNodeRefException refErr) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(context, ERROR_NODEREF), "root"));
            personNodes = Collections.emptyList();
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception tex) {}
        }
        catch (Throwable err) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(context, ERROR_GENERIC), err.getMessage()), err);
            personNodes = Collections.emptyList();
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception tex) {
                // empty catch block
            }
        }
        return personNodes;
    }

    public static boolean getIsGuest(FacesContext context) {
        TenantService tenantService = (TenantService)FacesContextUtils.getRequiredWebApplicationContext((FacesContext)context).getBean("tenantService");
        String userName = Application.getCurrentUser(context).getUserName();
        return tenantService.getBaseNameUser(userName).equalsIgnoreCase(AuthenticationUtil.getGuestUserName());
    }

    public static String safePropertyToString(Serializable value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)((Object)value);
        }
        return value.toString();
    }

    public static QName resolveToQName(String str) {
        return QName.resolveToQName((NamespacePrefixResolver)Repository.getNamespaceService(), (String)str);
    }

    public static String resolveToQNameString(String str) {
        return QName.resolveToQNameString((NamespacePrefixResolver)Repository.getNamespaceService(), (String)str);
    }

    private static NamespaceService getNamespaceService() {
        if (namespaceService == null) {
            ServiceRegistry svcReg = Repository.getServiceRegistry(FacesContext.getCurrentInstance());
            namespaceService = svcReg.getNamespaceService();
        }
        return namespaceService;
    }
}

