/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.repository;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.QNameNodeMap;
import org.alfresco.web.bean.repository.Repository;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransientNode
extends Node {
    private static final long serialVersionUID = 2140554155948154106L;
    private static final Log logger = LogFactory.getLog(TransientNode.class);

    public TransientNode(QName type, String name, Map<QName, Serializable> data) {
        super(new NodeRef(Repository.getStoreRef(), GUID.generate()));
        this.type = type;
        this.name = name;
        this.initNode(data);
    }

    public static TransientNode createNew(DictionaryService dictionaryService, TypeDefinition typeDef, String name, Map<QName, Serializable> data) {
        List aspects = typeDef.getDefaultAspects();
        ArrayList<QName> aspectNames = new ArrayList<QName>(aspects.size());
        TransientNode.getMandatoryAspects((ClassDefinition)typeDef, aspectNames);
        TypeDefinition startTaskDef = dictionaryService.getAnonymousType(typeDef.getName(), aspectNames);
        HashMap<QName, Serializable> startValues = new HashMap<QName, Serializable>();
        if (data != null) {
            startValues.putAll(data);
        }
        Map propertyDefs = startTaskDef.getProperties();
        for (Map.Entry entry : propertyDefs.entrySet()) {
            String defaultValue = ((PropertyDefinition)entry.getValue()).getDefaultValue();
            if (defaultValue == null || startValues.get(entry.getKey()) != null) continue;
            startValues.put((QName)entry.getKey(), (Serializable)DefaultTypeConverter.INSTANCE.convert(((PropertyDefinition)entry.getValue()).getDataType(), (Object)defaultValue));
        }
        return new TransientNode(typeDef.getName(), name, startValues);
    }

    private static void getMandatoryAspects(ClassDefinition classDef, List<QName> aspects) {
        for (AspectDefinition aspect : classDef.getDefaultAspects()) {
            QName aspectName = aspect.getName();
            if (aspects.contains(aspectName)) continue;
            aspects.add(aspect.getName());
            TransientNode.getMandatoryAspects((ClassDefinition)aspect, aspects);
        }
    }

    protected void initNode(Map<QName, Serializable> data) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Initialising transient node with data: " + data));
        }
        DictionaryService ddService = this.getServiceRegistry().getDictionaryService();
        this.associations = new QNameNodeMap(this, this);
        this.childAssociations = new QNameNodeMap(this, this);
        if (data != null) {
            for (QName item : data.keySet()) {
                List targets;
                ArrayList<Object> assocs;
                Serializable obj;
                PropertyDefinition propDef = ddService.getProperty(item);
                if (propDef != null) {
                    this.properties.put(item, data.get(item));
                    continue;
                }
                AssociationDefinition assocDef = ddService.getAssociation(item);
                if (assocDef == null) continue;
                if (assocDef.isChild()) {
                    obj = data.get(item);
                    if (obj instanceof NodeRef) {
                        NodeRef child = (NodeRef)obj;
                        assocs = new ArrayList<Object>(1);
                        ChildAssociationRef childRef = new ChildAssociationRef(assocDef.getName(), this.nodeRef, null, child);
                        assocs.add(childRef);
                        this.childAssociations.put(item, assocs);
                        continue;
                    }
                    if (!(obj instanceof List)) continue;
                    targets = (List)((Object)obj);
                    assocs = new ArrayList(targets.size());
                    for (Object target : targets) {
                        if (!(target instanceof NodeRef)) continue;
                        NodeRef currentChild = (NodeRef)target;
                        ChildAssociationRef childRef = new ChildAssociationRef(assocDef.getName(), this.nodeRef, null, currentChild);
                        assocs.add(childRef);
                    }
                    if (assocs.size() <= 0) continue;
                    this.childAssociations.put(item, assocs);
                    continue;
                }
                obj = data.get(item);
                if (obj instanceof NodeRef) {
                    NodeRef target = (NodeRef)obj;
                    assocs = new ArrayList(1);
                    AssociationRef assocRef = new AssociationRef(null, this.nodeRef, assocDef.getName(), target);
                    assocs.add(assocRef);
                    this.associations.put(item, assocs);
                    continue;
                }
                if (!(obj instanceof List)) continue;
                targets = (List)((Object)obj);
                assocs = new ArrayList(targets.size());
                for (Object target : targets) {
                    if (!(target instanceof NodeRef)) continue;
                    NodeRef currentTarget = (NodeRef)target;
                    AssociationRef assocRef = new AssociationRef(null, this.nodeRef, assocDef.getName(), currentTarget);
                    assocs.add(assocRef);
                }
                if (assocs.size() <= 0) continue;
                this.associations.put(item, assocs);
            }
        }
        this.propsRetrieved = true;
        this.assocsRetrieved = true;
        this.childAssocsRetrieved = true;
        TypeDefinition typeDef = ddService.getType(this.type);
        if (typeDef == null) {
            throw new AlfrescoRuntimeException("Failed to find type definition: " + this.type);
        }
        ArrayList<QName> defaultAspects = new ArrayList<QName>(16);
        TransientNode.getMandatoryAspects((ClassDefinition)typeDef, defaultAspects);
        this.aspects = new HashSet<QName>(defaultAspects);
        this.path = null;
        this.locked = Boolean.FALSE;
        this.workingCopyOwner = Boolean.FALSE;
    }

    @Override
    public boolean hasPermission(String permission) {
        return true;
    }

    @Override
    public void reset() {
    }

    @Override
    public String toString() {
        return "Transient node of type: " + this.getType() + "\nProperties: " + this.getProperties().toString();
    }
}

