/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.rules;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.faces.context.FacesContext;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;
import javax.faces.model.SelectItem;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionCondition;
import org.alfresco.service.cmr.action.ActionConditionDefinition;
import org.alfresco.service.cmr.action.CompositeAction;
import org.alfresco.service.cmr.action.CompositeActionCondition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.rule.Rule;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.cmr.rule.RuleType;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.actions.BaseActionWizard;
import org.alfresco.web.bean.actions.IHandler;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.rules.RulesDialog;
import org.alfresco.web.data.QuickSort;
import org.alfresco.web.ui.common.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigService;

public class CreateRuleWizard
extends BaseActionWizard {
    private static final long serialVersionUID = 6197875728665281192L;
    protected static final String PROP_CONDITION_NAME = "conditionName";
    protected static final String PROP_CONDITION_SUMMARY = "conditionSummary";
    private transient RuleService ruleService;
    protected RulesDialog rulesDialog;
    private List<SelectItem> modelTypes;
    private List<SelectItem> mimeTypes;
    private List<SelectItem> types;
    private List<SelectItem> conditions;
    protected Map<String, IHandler> conditionHandlers;
    protected Map<String, Serializable> currentConditionProperties;
    protected transient DataModel allConditionsDataModel;
    protected List<Map<String, Serializable>> allConditionsPropertiesList;
    protected String title;
    protected String description;
    protected String type;
    protected String selectedCondition;
    protected boolean runInBackground;
    protected boolean applyToSubSpaces;
    protected boolean editingCondition;
    protected boolean ruleDisabled;
    private static final Log logger = LogFactory.getLog(CreateRuleWizard.class);

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.title = null;
        this.description = null;
        this.type = "inbound";
        this.selectedCondition = null;
        this.applyToSubSpaces = false;
        this.runInBackground = false;
        this.ruleDisabled = false;
        this.conditions = null;
        this.allConditionsPropertiesList = new ArrayList<Map<String, Serializable>>();
        this.initialiseConditionHandlers();
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"finishImpl called - saving rules");
        }
        Node currentSpace = this.browseBean.getActionSpace();
        Rule rule = new Rule();
        rule.setRuleType(this.getType());
        outcome = this.setupRule(context, rule, outcome);
        this.getRuleService().saveRule(currentSpace.getNodeRef(), rule);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Added rule '" + this.title + "'"));
        }
        return outcome;
    }

    @Override
    public boolean getNextButtonDisabled() {
        boolean disabled = true;
        int step = Application.getWizardManager().getCurrentStep();
        switch (step) {
            case 1: {
                disabled = this.allConditionsDataModel == null || this.allConditionsDataModel.getRowCount() == 0;
                break;
            }
            case 2: {
                disabled = this.allActionsDataModel == null || this.allActionsDataModel.getRowCount() == 0;
                break;
            }
            case 3: {
                disabled = this.title == null || this.title.length() == 0;
            }
        }
        return disabled;
    }

    @Override
    public boolean getFinishButtonDisabled() {
        return this.allActionsDataModel == null || this.allActionsDataModel.getRowCount() <= 0 || this.allConditionsDataModel == null || this.allConditionsDataModel.getRowCount() <= 0 || this.title == null || this.title.length() <= 0;
    }

    public String getSummary() {
        StringBuilder conditionsSummary = new StringBuilder();
        for (Map<String, Serializable> props : this.allConditionsPropertiesList) {
            conditionsSummary.append(Utils.encode((String)((String)((Object)props.get(PROP_CONDITION_SUMMARY)))));
            conditionsSummary.append("<br>");
        }
        StringBuilder actionsSummary = new StringBuilder();
        for (Map props : this.allActionsProperties) {
            actionsSummary.append(Utils.encode((String)((String)props.get("actionSummary"))));
            actionsSummary.append("<br>");
        }
        ResourceBundle bundle = Application.getBundle(FacesContext.getCurrentInstance());
        String backgroundYesNo = this.runInBackground ? bundle.getString("yes") : bundle.getString("no");
        String subSpacesYesNo = this.applyToSubSpaces ? bundle.getString("yes") : bundle.getString("no");
        String ruleDisabledYesNo = this.ruleDisabled ? bundle.getString("yes") : bundle.getString("no");
        return this.buildSummary(new String[]{bundle.getString("rule_type"), bundle.getString("name"), bundle.getString("description"), bundle.getString("apply_to_sub_spaces"), bundle.getString("run_in_background"), bundle.getString("rule_disabled"), bundle.getString("conditions"), bundle.getString("actions")}, new String[]{this.type, Utils.encode((String)this.title), Utils.encode((String)this.description), subSpacesYesNo, backgroundYesNo, ruleDisabledYesNo, conditionsSummary.toString(), actionsSummary.toString()});
    }

    @Override
    protected String getErrorMessageId() {
        return "error_rule";
    }

    protected CompositeAction getCompositeAction(Rule rule) {
        Action ruleAction = rule.getAction();
        if (ruleAction == null) {
            throw new AlfrescoRuntimeException("Rule does not have associated action.");
        }
        if (!(ruleAction instanceof CompositeAction)) {
            throw new AlfrescoRuntimeException("Rules with non-composite actions are not currently supported by the UI");
        }
        return (CompositeAction)ruleAction;
    }

    public boolean getRuleTypeDisabled() {
        return false;
    }

    public DataModel getAllConditionsDataModel() {
        if (this.allConditionsDataModel == null) {
            this.allConditionsDataModel = new ListDataModel();
        }
        this.allConditionsDataModel.setWrappedData(this.allConditionsPropertiesList);
        return this.allConditionsDataModel;
    }

    public List<SelectItem> getModelTypes() {
        if (this.modelTypes == null || Application.isDynamicConfig(FacesContext.getCurrentInstance())) {
            FacesContext context = FacesContext.getCurrentInstance();
            ConfigService svc = Application.getConfigService(context);
            Config wizardCfg = svc.getConfig((Object)"Action Wizards");
            if (wizardCfg != null) {
                ConfigElement typesCfg = wizardCfg.getConfigElement("subtypes");
                if (typesCfg != null) {
                    this.modelTypes = new ArrayList<SelectItem>();
                    for (ConfigElement child : typesCfg.getChildren()) {
                        QName idQName = Repository.resolveToQName(child.getAttribute("name"));
                        String label = Utils.getDisplayLabel(context, child);
                        if (label == null) {
                            TypeDefinition typeDef = this.getDictionaryService().getType(idQName);
                            label = typeDef != null ? typeDef.getTitle() : idQName.getLocalName();
                        }
                        this.modelTypes.add(new SelectItem((Object)idQName.toString(), label));
                    }
                    QuickSort sorter = new QuickSort(this.modelTypes, "label", true, "case-insensitive");
                    sorter.sort();
                } else {
                    logger.warn((Object)"Could not find 'subtypes' configuration element");
                }
            } else {
                logger.warn((Object)"Could not find 'Action Wizards' configuration section");
            }
        }
        return this.modelTypes;
    }

    public List<SelectItem> getMimeTypes() {
        if (this.mimeTypes == null) {
            this.mimeTypes = new ArrayList<SelectItem>(50);
            Map mimeTypes = this.getMimetypeService().getDisplaysByMimetype();
            for (String mimeType : mimeTypes.keySet()) {
                this.mimeTypes.add(new SelectItem((Object)mimeType, (String)mimeTypes.get(mimeType)));
            }
            QuickSort sorter = new QuickSort(this.mimeTypes, "label", true, "case-insensitive");
            sorter.sort();
        }
        return this.mimeTypes;
    }

    public List<SelectItem> getConditions() {
        if (this.conditions == null) {
            List ruleConditions = this.getActionService().getActionConditionDefinitions();
            this.conditions = new ArrayList<SelectItem>(ruleConditions.size());
            for (ActionConditionDefinition ruleConditionDef : ruleConditions) {
                this.conditions.add(new SelectItem((Object)ruleConditionDef.getName(), ruleConditionDef.getTitle()));
            }
            QuickSort sorter = new QuickSort(this.conditions, "label", true, "case-insensitive");
            sorter.sort();
            this.conditions.add(0, new SelectItem((Object)"null", Application.getMessage(FacesContext.getCurrentInstance(), "select_a_condition")));
        }
        return this.conditions;
    }

    public List<SelectItem> getTypes() {
        if (this.types == null) {
            List ruleTypes = this.getRuleService().getRuleTypes();
            this.types = new ArrayList<SelectItem>(ruleTypes.size());
            for (RuleType ruleType : ruleTypes) {
                this.types.add(new SelectItem((Object)ruleType.getName(), ruleType.getDisplayLabel()));
            }
        }
        return this.types;
    }

    public Map<String, Serializable> getConditionProperties() {
        return this.currentConditionProperties;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean getRunInBackground() {
        return this.runInBackground;
    }

    public void setRunInBackground(boolean runInBackground) {
        this.runInBackground = runInBackground;
    }

    public boolean getApplyToSubSpaces() {
        return this.applyToSubSpaces;
    }

    public void setApplyToSubSpaces(boolean applyToSubSpaces) {
        this.applyToSubSpaces = applyToSubSpaces;
    }

    public boolean getRuleDisabled() {
        return this.ruleDisabled;
    }

    public void setRuleDisabled(boolean ruleDisabled) {
        this.ruleDisabled = ruleDisabled;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getCondition() {
        return this.selectedCondition;
    }

    public void setCondition(String condition) {
        this.selectedCondition = condition;
    }

    public void promptForConditionValues() {
        this.editingCondition = false;
        FacesContext context = FacesContext.getCurrentInstance();
        this.returnViewId = context.getViewRoot().getViewId();
        String viewId = null;
        this.currentConditionProperties = new HashMap<String, Serializable>(3);
        this.currentConditionProperties.put(PROP_CONDITION_NAME, (Serializable)((Object)this.selectedCondition));
        this.currentConditionProperties.put("notcondition", Boolean.FALSE);
        IHandler handler = this.conditionHandlers.get(this.selectedCondition);
        if (handler != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found Handler for selected condition - '" + this.selectedCondition + "'"));
            }
            handler.setupUIDefaults(this.currentConditionProperties);
            viewId = handler.getJSPPath();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Handler returned JSP page- '" + viewId + "'  Handler Type " + handler.getClass().toString()));
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Did Not Find a handler for selected condition - '" + this.selectedCondition + "'"));
            }
            ActionConditionDefinition conditionDef = this.getActionService().getActionConditionDefinition(this.selectedCondition);
            this.currentConditionProperties.put(PROP_CONDITION_SUMMARY, (Serializable)((Object)conditionDef.getTitle()));
            this.currentConditionProperties.put("notcondition", Boolean.FALSE);
            this.currentConditionProperties.put("noParamsMarker", (Serializable)((Object)"no-params"));
            this.allConditionsPropertiesList.add(this.currentConditionProperties);
            viewId = this.returnViewId;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Currently creating '" + this.selectedCondition + "' condition"));
        }
        this.goToPage(context, viewId);
    }

    public void editCondition() {
        Map conditionToEdit = (Map)this.allConditionsDataModel.getRowData();
        this.editCondition(conditionToEdit);
    }

    protected void editCondition(Map conditionToEdit) {
        this.editingCondition = true;
        this.selectedCondition = (String)conditionToEdit.get(PROP_CONDITION_NAME);
        this.currentConditionProperties = conditionToEdit;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Editing Condition '" + this.selectedCondition + "'"));
        }
        FacesContext context = FacesContext.getCurrentInstance();
        this.returnViewId = context.getViewRoot().getViewId();
        this.goToPage(context, this.conditionHandlers.get(this.selectedCondition).getJSPPath());
    }

    public void addCondition() {
        IHandler handler;
        String summary;
        FacesContext context = FacesContext.getCurrentInstance();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Adding Condition '" + this.selectedCondition + "'"));
        }
        if ((summary = (handler = this.conditionHandlers.get(this.selectedCondition)).generateSummary(context, this, this.currentConditionProperties)) != null) {
            this.currentConditionProperties.put(PROP_CONDITION_SUMMARY, (Serializable)((Object)summary));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Generated Summary - [" + summary + "] + selectedCondition " + this.selectedCondition));
        }
        if (!this.editingCondition) {
            this.allConditionsPropertiesList.add(this.currentConditionProperties);
        }
        this.selectedCondition = null;
        this.goToPage(context, this.returnViewId);
    }

    public void removeCondition() {
        Map conditionToRemove = (Map)this.allConditionsDataModel.getRowData();
        this.allConditionsPropertiesList.remove(conditionToRemove);
        this.selectedCondition = null;
        FacesContext context = FacesContext.getCurrentInstance();
        this.goToPage(context, context.getViewRoot().getViewId());
    }

    public void cancelAddCondition() {
        if (!this.editingCondition) {
            this.currentConditionProperties.clear();
        }
        this.selectedCondition = null;
        this.goToPage(FacesContext.getCurrentInstance(), this.returnViewId);
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    @Override
    protected RuleService getRuleService() {
        if (this.ruleService == null) {
            this.ruleService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getRuleService();
        }
        return this.ruleService;
    }

    public void setRulesDialog(RulesDialog RulesDialog2) {
        this.rulesDialog = RulesDialog2;
    }

    protected String setupRule(FacesContext context, Rule rule, String outcome) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Saving Rules - setupRule");
        }
        rule.setTitle(this.title);
        rule.setDescription(this.description);
        rule.applyToChildren(this.applyToSubSpaces);
        rule.setExecuteAsynchronously(this.runInBackground);
        rule.setRuleDisabled(this.ruleDisabled);
        CompositeAction compositeAction = this.getActionService().createCompositeAction();
        rule.setAction((Action)compositeAction);
        int i = 1;
        for (Map<String, Serializable> condParamsObj : this.allConditionsPropertiesList) {
            Map<String, Serializable> uiConditionParams;
            ActionCondition condition;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Saving Condition " + i++ + " of " + this.allConditionsPropertiesList.size()));
            }
            if ((condition = this.createCondition(uiConditionParams = condParamsObj)) instanceof CompositeActionCondition) {
                CompositeActionCondition compositeCondition = (CompositeActionCondition)condition;
                List subconditionProps = (List)((Object)uiConditionParams.get("composite-condition"));
                int j = 1;
                compositeCondition.setORCondition(((Boolean)uiConditionParams.get("orconditions")).booleanValue());
                compositeCondition.setInvertCondition(((Boolean)uiConditionParams.get("notcondition")).booleanValue());
                for (Map props : subconditionProps) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Saving Composite Condition " + j++ + " of " + subconditionProps.size()));
                    }
                    compositeCondition.addActionCondition(this.createCondition(props));
                }
            }
            compositeAction.addActionCondition(condition);
        }
        for (Map<String, Serializable> actionParams : this.allActionsProperties) {
            String actionName;
            this.action = actionName = (String)((Object)actionParams.get("actionName"));
            HashMap<String, Serializable> repoActionParams = new HashMap<String, Serializable>();
            IHandler handler = (IHandler)this.actionHandlers.get(this.action);
            if (handler != null) {
                handler.prepareForSave(actionParams, repoActionParams);
            }
            Action action = this.getActionService().createAction(actionName);
            action.setParameterValues(repoActionParams);
            compositeAction.addAction(action);
        }
        return outcome;
    }

    private ActionCondition createCondition(Map<String, Serializable> uiConditionParams) {
        IHandler handler;
        String conditionName = (String)((Object)uiConditionParams.get(PROP_CONDITION_NAME));
        HashMap<String, Serializable> repoCondParams = new HashMap<String, Serializable>();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\tSaving " + conditionName));
        }
        if ((handler = this.conditionHandlers.get(conditionName)) != null) {
            handler.prepareForSave(uiConditionParams, repoCondParams);
        }
        ActionCondition condition = this.getActionService().createActionCondition(conditionName);
        condition.setParameterValues(repoCondParams);
        Boolean not = (Boolean)uiConditionParams.get("notcondition");
        if (not == null) {
            logger.warn((Object)"Property missing NOT parameter value (currently null)");
            not = Boolean.TRUE;
        }
        condition.setInvertCondition(not.booleanValue());
        return condition;
    }

    protected void initialiseConditionHandlers() {
        if (this.conditionHandlers == null || Application.isDynamicConfig(FacesContext.getCurrentInstance())) {
            ConfigService svc = Application.getConfigService(FacesContext.getCurrentInstance());
            Config wizardCfg = svc.getConfig((Object)"Action Wizards");
            if (wizardCfg != null) {
                ConfigElement conditionHandlerCfg = wizardCfg.getConfigElement("condition-handlers");
                if (conditionHandlerCfg != null) {
                    this.conditionHandlers = new HashMap<String, IHandler>(20);
                    for (ConfigElement child : conditionHandlerCfg.getChildren()) {
                        String conditionName = child.getAttribute("name");
                        String handlerClass = child.getAttribute("class");
                        if (conditionName == null || conditionName.length() <= 0 || handlerClass == null || handlerClass.length() <= 0) continue;
                        try {
                            Class<?> klass = Class.forName(handlerClass);
                            IHandler handler = (IHandler)klass.newInstance();
                            this.conditionHandlers.put(conditionName, handler);
                        }
                        catch (Exception e) {
                            throw new AlfrescoRuntimeException("Failed to setup condition handler for '" + conditionName + "'", (Throwable)e);
                        }
                    }
                } else {
                    logger.warn((Object)"Could not find 'condition-handlers' configuration element");
                }
            } else {
                logger.warn((Object)"Could not find 'Action Wizards' configuration section");
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.allConditionsDataModel = new ListDataModel();
        this.allConditionsDataModel.setWrappedData(this.allConditionsPropertiesList);
    }
}

