/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.rules;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionCondition;
import org.alfresco.service.cmr.action.ActionConditionDefinition;
import org.alfresco.service.cmr.action.ActionDefinition;
import org.alfresco.service.cmr.action.CompositeAction;
import org.alfresco.service.cmr.action.CompositeActionCondition;
import org.alfresco.service.cmr.rule.Rule;
import org.alfresco.web.bean.actions.IHandler;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.rules.CreateCompositeRuleWizard;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EditRuleWizard
extends CreateCompositeRuleWizard {
    private static final long serialVersionUID = -7222762769396254445L;
    private static final Log logger = LogFactory.getLog(EditRuleWizard.class);

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        Rule rule = this.rulesDialog.getCurrentRule();
        if (rule == null) {
            throw new AlfrescoRuntimeException("Failed to locate the current rule");
        }
        this.type = (String)rule.getRuleTypes().get(0);
        this.title = rule.getTitle();
        this.description = rule.getDescription();
        this.applyToSubSpaces = rule.isAppliedToChildren();
        this.runInBackground = rule.getExecuteAsynchronously();
        this.ruleDisabled = rule.getRuleDisabled();
        FacesContext context = FacesContext.getCurrentInstance();
        CompositeAction compositeAction = this.getCompositeAction(rule);
        this.populateConditions(context, compositeAction);
        this.populateActions(context, compositeAction);
        this.selectedCondition = null;
        this.action = null;
    }

    protected void populateActions(FacesContext context, CompositeAction compositeAction) {
        List actions = compositeAction.getActions();
        for (Action action : actions) {
            this.currentActionProperties = new HashMap(3);
            this.currentEmailRecipientsDataModel = null;
            this.action = action.getActionDefinitionName();
            this.currentActionProperties.put("actionName", this.action);
            IHandler handler = (IHandler)this.actionHandlers.get(this.action);
            if (handler != null) {
                handler.prepareForEdit(this.currentActionProperties, action.getParameterValues());
                this.currentActionProperties.put("actionSummary", handler.generateSummary(context, this, this.currentActionProperties));
            } else {
                ActionDefinition actionDef = this.getActionService().getActionDefinition(this.action);
                this.currentActionProperties.put("actionSummary", actionDef.getTitle());
                this.currentActionProperties.put("noParamsMarker", "no-params");
            }
            this.allActionsProperties.add(this.currentActionProperties);
        }
    }

    protected void populateConditions(FacesContext context, CompositeAction compositeAction) {
        List conditions = compositeAction.getActionConditions();
        for (ActionCondition toplevel_condition : conditions) {
            this.selectedCondition = toplevel_condition.getActionConditionDefinitionName();
            this.currentConditionProperties = new HashMap();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Preparing for Edit Condition " + this.selectedCondition));
            }
            if (toplevel_condition instanceof CompositeActionCondition) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"\tDetected CompositeCondition");
                }
                CompositeActionCondition compositeCondition = (CompositeActionCondition)toplevel_condition;
                this.currentCompositeConditionPropertiesList = new ArrayList();
                for (ActionCondition subcondition : compositeCondition.getActionConditions()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("\tSetting ... SubConditions " + subcondition.getActionConditionDefinitionName()));
                    }
                    this.selectedCondition = subcondition.getActionConditionDefinitionName();
                    HashMap<String, Serializable> subConditionProperties = new HashMap<String, Serializable>();
                    this.populateProperties(context, subcondition, subConditionProperties);
                    this.currentCompositeConditionPropertiesList.add(subConditionProperties);
                }
                this.selectedCondition = "composite-condition";
                this.currentConditionProperties.put("composite-condition", (Serializable)((Object)this.currentCompositeConditionPropertiesList));
                this.populateProperties(context, (ActionCondition)compositeCondition, this.currentConditionProperties);
            } else {
                this.populateProperties(context, toplevel_condition, this.currentConditionProperties);
            }
            this.allConditionsPropertiesList.add(this.currentConditionProperties);
            this.printConditionState();
        }
    }

    protected void populateProperties(FacesContext context, ActionCondition condition, Map<String, Serializable> uiConditionProperties) {
        uiConditionProperties.put("conditionName", (Serializable)((Object)this.selectedCondition));
        uiConditionProperties.put("notcondition", Boolean.valueOf(condition.getInvertCondition()));
        IHandler handler = (IHandler)this.conditionHandlers.get(this.selectedCondition);
        if (handler != null) {
            handler.prepareForEdit(uiConditionProperties, condition.getParameterValues());
            uiConditionProperties.put("conditionSummary", (Serializable)((Object)handler.generateSummary(context, this, uiConditionProperties)));
        } else {
            ActionConditionDefinition conditionDef = this.getActionService().getActionConditionDefinition(this.selectedCondition);
            uiConditionProperties.put("conditionSummary", (Serializable)((Object)conditionDef.getTitle()));
            uiConditionProperties.put("noParamsMarker", (Serializable)((Object)"no-params"));
        }
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        Node currentSpace = this.browseBean.getActionSpace();
        Rule rule = this.rulesDialog.getCurrentRule();
        CompositeAction compositeAction = this.getCompositeAction(rule);
        compositeAction.removeAllActionConditions();
        compositeAction.removeAllActions();
        outcome = this.setupRule(context, rule, outcome);
        this.getRuleService().saveRule(currentSpace.getNodeRef(), rule);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Updated rule '" + this.title + "'"));
        }
        return outcome;
    }

    @Override
    public boolean getRuleTypeDisabled() {
        return true;
    }
}

