/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.rules.handlers;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.rules.handlers.BaseConditionHandler;
import org.alfresco.web.bean.wizard.IWizardBean;

public class InCategoryHandler
extends BaseConditionHandler {
    private static final long serialVersionUID = -7312917724514125469L;
    protected static final String PROP_CATEGORY = "category";

    @Override
    public String getJSPPath() {
        return this.getJSPPath("in-category");
    }

    @Override
    public void prepareForSave(Map<String, Serializable> conditionProps, Map<String, Serializable> repoProps) {
        NodeRef nodeRef = (NodeRef)conditionProps.get(PROP_CATEGORY);
        repoProps.put("category-value", (Serializable)nodeRef);
        repoProps.put("category-aspect", (Serializable)ContentModel.ASPECT_GEN_CLASSIFIABLE);
    }

    @Override
    public void prepareForEdit(Map<String, Serializable> conditionProps, Map<String, Serializable> repoProps) {
        NodeRef catNodeRef = (NodeRef)repoProps.get("category-value");
        conditionProps.put(PROP_CATEGORY, (Serializable)catNodeRef);
    }

    @Override
    public String generateSummary(FacesContext context, IWizardBean wizard, Map<String, Serializable> conditionProps) {
        Boolean not = (Boolean)conditionProps.get("notcondition");
        String msgId = not != false ? "condition_in_category_not" : "condition_in_category";
        String name = Repository.getNameForNode(Repository.getServiceRegistry(context).getNodeService(), (NodeRef)conditionProps.get(PROP_CATEGORY));
        return MessageFormat.format(Application.getMessage(context, msgId), name);
    }
}

