/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.rules.handlers;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.rules.handlers.BaseConditionHandler;
import org.alfresco.web.bean.wizard.IWizardBean;

public class PropertyValueHandler
extends BaseConditionHandler {
    private static final long serialVersionUID = 6718858865738420012L;
    public static final String PROP_CONTAINS_TEXT = "containstext";

    @Override
    public String getJSPPath() {
        return this.getJSPPath("compare-property-value");
    }

    @Override
    public void prepareForSave(Map<String, Serializable> conditionProps, Map<String, Serializable> repoProps) {
        this.prepareForSaveWithCorrectType(conditionProps, repoProps);
    }

    protected void prepareForSaveWithCorrectType(Map<String, Serializable> conditionProps, Map<String, Serializable> repoProps) {
        String text = (String)((Object)conditionProps.get(PROP_CONTAINS_TEXT));
        repoProps.put("value", (Serializable)((Object)text));
    }

    @Override
    public void prepareForEdit(Map<String, Serializable> conditionProps, Map<String, Serializable> repoProps) {
        this.prepareForEditWithCorrectType(conditionProps, repoProps);
    }

    protected void prepareForEditWithCorrectType(Map<String, Serializable> conditionProps, Map<String, Serializable> repoProps) {
        String propValue = (String)((Object)repoProps.get("value"));
        conditionProps.put(PROP_CONTAINS_TEXT, (Serializable)((Object)propValue));
    }

    @Override
    public String generateSummary(FacesContext context, IWizardBean wizard, Map<String, Serializable> conditionProps) {
        Boolean not = (Boolean)conditionProps.get("notcondition");
        String msgId = not != false ? "condition_compare_property_value_not" : "condition_compare_property_value";
        String text = (String)((Object)conditionProps.get(PROP_CONTAINS_TEXT));
        return MessageFormat.format(Application.getMessage(context, msgId), text);
    }
}

