/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.rules.handlers.property;

import java.io.Serializable;
import java.util.Map;
import org.alfresco.repo.action.evaluator.compare.ComparePropertyValueOperation;
import org.alfresco.web.bean.rules.handlers.property.TextPropertyValueConditionHandler;

public class IntegerPropertyValueConditionHandler
extends TextPropertyValueConditionHandler {
    public static final String NAME = "compare-integer-property";

    @Override
    protected String getConditionName() {
        return NAME;
    }

    @Override
    protected void prepareForSaveWithCorrectType(Map<String, Serializable> conditionProps, Map<String, Serializable> repoProps) {
        Long number = Long.parseLong((String)((Object)conditionProps.get("containstext")));
        repoProps.put("value", number);
    }

    @Override
    protected void prepareForEditWithCorrectType(Map<String, Serializable> conditionProps, Map<String, Serializable> repoProps) {
        Long propValue = (Long)repoProps.get("value");
        conditionProps.put("containstext", (Serializable)((Object)propValue.toString()));
    }

    @Override
    protected String getSummaryStringTemplate(Boolean not) {
        String msgId = not != false ? "condition_compare_integer_property_value_not" : "condition_compare_integer_property_value";
        return msgId;
    }

    @Override
    protected String displayOperation(String operation) {
        ComparePropertyValueOperation op = ComparePropertyValueOperation.valueOf((String)operation);
        switch (op) {
            case EQUALS: {
                return "property_condition_equals";
            }
            case GREATER_THAN: {
                return "property_condition_greaterthan";
            }
            case GREATER_THAN_EQUAL: {
                return "property_condition_greaterthanequals";
            }
            case LESS_THAN: {
                return "property_condition_lessthan";
            }
            case LESS_THAN_EQUAL: {
                return "property_condition_lessthanequals";
            }
        }
        return "property_condition_invalid";
    }
}

