/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.rules.handlers.property;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.repo.action.evaluator.compare.ComparePropertyValueOperation;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.rules.handlers.PropertyValueHandler;
import org.alfresco.web.bean.wizard.IWizardBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TextPropertyValueConditionHandler
extends PropertyValueHandler {
    private static final Log logger = LogFactory.getLog(TextPropertyValueConditionHandler.class);
    public static final String NAME = "compare-text-property";
    public static final String UI_PARAM_OPERATION = "operation";
    public static final String UI_PARAM_QNAME = "qname";
    private static final String DEFAULT_NAMESPACE = "cm";

    @Override
    public String getJSPPath() {
        return this.getJSPPath(this.getConditionName());
    }

    protected String getConditionName() {
        return NAME;
    }

    @Override
    public void prepareForSave(Map<String, Serializable> conditionParams, Map<String, Serializable> repoProps) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Preparing to Save Text Condition Parameters");
        }
        super.prepareForSave(conditionParams, repoProps);
        String propertyString = (String)((Object)conditionParams.get(UI_PARAM_QNAME));
        QName qname = null;
        propertyString = propertyString.indexOf(58) == -1 ? "cm:" + propertyString : propertyString;
        qname = QName.createQName((String)propertyString, (NamespacePrefixResolver)this.getNamespaceService());
        if (logger.isDebugEnabled()) {
            logger.warn((Object)("Storing Property QName  " + qname));
        }
        repoProps.put("property", (Serializable)qname);
        String operation = (String)((Object)conditionParams.get(UI_PARAM_OPERATION));
        repoProps.put(UI_PARAM_OPERATION, (Serializable)((Object)operation));
    }

    @Override
    public void prepareForEdit(Map<String, Serializable> conditionProps, Map<String, Serializable> repoProps) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Retrieving Text Condition Parameters for editing");
        }
        super.prepareForEdit(conditionProps, repoProps);
        conditionProps.put(UI_PARAM_QNAME, (Serializable)((Object)((QName)repoProps.get("property")).toPrefixString((NamespacePrefixResolver)this.getNamespaceService())));
        conditionProps.put(UI_PARAM_OPERATION, (Serializable)((Object)repoProps.get(UI_PARAM_OPERATION).toString()));
    }

    @Override
    public String generateSummary(FacesContext context, IWizardBean wizard, Map<String, Serializable> conditionProps) {
        Boolean not = (Boolean)conditionProps.get("notcondition");
        String msgId = this.getSummaryStringTemplate(not);
        String text = conditionProps.get("containstext").toString();
        String operation = (String)((Object)conditionProps.get(UI_PARAM_OPERATION));
        String qname = (String)((Object)conditionProps.get(UI_PARAM_QNAME));
        return MessageFormat.format(Application.getMessage(context, msgId), qname, Application.getMessage(context, this.displayOperation(operation)), text);
    }

    protected String displayOperation(String operation) {
        ComparePropertyValueOperation op = ComparePropertyValueOperation.valueOf((String)operation);
        switch (op) {
            case EQUALS: {
                return "property_date_condition_equals";
            }
            case CONTAINS: {
                return "property_condition_contains";
            }
            case BEGINS: {
                return "property_condition_beginswith";
            }
            case ENDS: {
                return "property_condition_endswith";
            }
        }
        return "property_condition_invalid";
    }

    protected String getSummaryStringTemplate(Boolean not) {
        String msgId = not != false ? "condition_compare_text_property_value_not" : "condition_compare_text_property_value";
        return msgId;
    }
}

